/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.event;

import javax.mail.event.ConnectionListener;
import javax.mail.event.MailEvent;

public class ConnectionEvent
extends MailEvent {
    public static final int CLOSED = 3;
    public static final int DISCONNECTED = 2;
    public static final int OPENED = 1;
    protected int type;

    public ConnectionEvent(Object source, int type) {
        super(source);
        this.type = type;
        if (type != 2 && type != 1 && type != 3) {
            throw new IllegalArgumentException("Unknown type " + type);
        }
    }

    public void dispatch(Object listener) {
        ConnectionListener l = (ConnectionListener)listener;
        if (this.type == 1) {
            l.opened(this);
        } else if (this.type == 2) {
            l.disconnected(this);
        } else if (this.type == 3) {
            l.closed(this);
        } else {
            throw new IllegalArgumentException("Unknown type " + this.type);
        }
    }

    public int getType() {
        return this.type;
    }
}

