/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.MailEvent;
import javax.mail.event.TransportListener;

public abstract class Service {
    private boolean _connected;
    private List _connectionListeners = new LinkedList();
    protected boolean debug;
    protected Session session;
    protected URLName url;

    protected Service(Session session, URLName url) {
        this.session = session;
        this.url = url;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this._connectionListeners.add(listener);
    }

    public void close() throws MessagingException {
        this.setConnected(false);
    }

    public void connect() throws MessagingException {
        String host = this.session.getProperty("mail.host");
        String user = this.session.getProperty("mail.user");
        this.connect(host, -1, user, null);
    }

    public void connect(String host, int port, String user, String password) throws MessagingException {
        if (this._connected) {
            throw new IllegalStateException("Already connected");
        }
        boolean retry = true;
        while (retry) {
            try {
                retry = !this.protocolConnect(host, port, user, password);
            }
            catch (AuthenticationFailedException e) {
                try {
                    PasswordAuthentication pa = this.session.requestPasswordAuthentication(InetAddress.getByName(host), port, null, "Please enter your password", user);
                    password = pa.getPassword();
                    user = pa.getUserName();
                }
                catch (UnknownHostException uhe) {
                    throw new MessagingException(uhe.toString());
                }
            }
        }
        this.setConnected(true);
        this.setURLName(this.getURLName());
    }

    public void connect(String host, String user, String password) throws MessagingException {
        this.connect(host, -1, user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.close();
        }
    }

    public URLName getURLName() {
        return this.url;
    }

    public boolean isConnected() {
        return this._connected;
    }

    protected void notifyConnectionListeners(int type) {
        ConnectionEvent event = new ConnectionEvent(this, type);
        Iterator it = this._connectionListeners.iterator();
        while (it.hasNext()) {
            TransportListener listener = (TransportListener)it.next();
            event.dispatch(listener);
        }
    }

    protected boolean protocolConnect(String host, int port, String user, String password) throws MessagingException {
        return false;
    }

    protected void queueEvent(MailEvent event, Vector listeners) {
        Enumeration enumeration = listeners.elements();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            event.dispatch(listeners);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this._connectionListeners.remove(listener);
    }

    protected void setConnected(boolean connected) {
        boolean old = this._connected;
        this._connected = connected;
        if (old != this._connected) {
            if (connected) {
                this.notifyConnectionListeners(1);
            } else {
                this.notifyConnectionListeners(3);
            }
        }
    }

    protected void setURLName(URLName url) {
        this.url = url;
    }

    public String toString() {
        if (this.url == null) {
            return super.toString();
        }
        return this.url.toString();
    }
}

