/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.util;

import org.exolab.adaptx.util.ErrorObserverAdapter;
import org.exolab.adaptx.xml.AttributeListImpl;
import org.exolab.adaptx.xml.XMLUtil;
import org.exolab.adaptx.xslt.ResultHandler;
import org.xml.sax.SAXException;

public class ResultFormatter
extends ErrorObserverAdapter {
    private static final String XMLNS_DECL = "xmlns";
    private static final String XMLNS_PRE_DECL = "xmlns:";
    private static final String ATTR_ERR = "attributes may only be added to the current result element before any content has been added.";
    private boolean _allowAtts = false;
    private AttributeListImpl _atts = null;
    private String _elementName = null;
    private String _namespace = null;
    private ResultHandler _handler = null;
    Namespaces _namespaces = null;

    public ResultFormatter(ResultHandler resultHandler) {
        if (resultHandler == null) {
            throw new IllegalArgumentException("Handler must not be null.");
        }
        this._handler = resultHandler;
        this._atts = new AttributeListImpl();
        this._namespaces = new Namespaces();
    }

    private void addNamespaces() {
        Namespaces namespaces = new Namespaces();
        namespaces.previous = this._namespaces;
        this._namespaces = namespaces;
    }

    public void attribute(String string, String string2, String string3) {
        if (string.equals(XMLNS_DECL)) {
            this._namespaces.defaultNS = string2;
            this._atts.addAttribute(string, string2);
        } else if (string.startsWith(XMLNS_PRE_DECL)) {
            String string4 = string.substring(6);
            this._namespaces.addMapping(string4, string2);
            this._atts.addAttribute(string, string2);
        } else if (!this._allowAtts) {
            String string5 = "attributes may only be added to the current result element before any content has been added.\n   -- attr: " + string + "=\"" + string2 + "\"";
            this.receiveError(string5);
        } else {
            int n = string.indexOf(58);
            if (n >= 0) {
                String string6 = string.substring(0, n);
                String string7 = this._namespaces.getNamespace(string6);
                if (string7 == null) {
                    if (string3 != null) {
                        this.declareNamespace(string6, string3);
                    } else {
                        this.receiveError("undeclared namespace prefix: " + string6);
                    }
                } else if (string3 != null && !string7.equals(string3)) {
                    this.declareNamespace(string6, string3);
                }
            } else if (string3 != null) {
                String string8 = this._namespaces.getPrefix(string3);
                if (string8 != null && string8.length() > 0) {
                    string = String.valueOf(string8) + ':' + this._elementName;
                } else {
                    this.receiveError("undeclared namespace: " + string3);
                }
            }
            this._atts.addAttribute(string, string2);
        }
    }

    public boolean attsAllowed() {
        return this._allowAtts;
    }

    public void cdata(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        this.cdata(cArray, 0, cArray.length);
    }

    public void cdata(char[] cArray, int n, int n2) {
        this.content();
        this._handler.cdata(cArray, n, n2);
    }

    public void characters(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        this.characters(cArray, 0, cArray.length);
    }

    public void characters(char[] cArray, int n, int n2) {
        this.content();
        try {
            this._handler.characters(cArray, n, n2);
        }
        catch (SAXException sAXException) {
            this.receiveError(sAXException);
        }
    }

    private void clearAttributes() {
        this._atts.clear();
    }

    public void comment(String string) {
        this.content();
        this._handler.comment(string);
    }

    private void content() {
        if (this._elementName != null) {
            String string;
            if (this._namespace != null && (string = this._namespaces.getPrefix(this._namespace)) != null && string.length() > 0) {
                this._elementName = String.valueOf(string) + ':' + this._elementName;
            }
            try {
                this._handler.startElement(this._elementName, this._atts);
            }
            catch (SAXException sAXException) {
                this.receiveError(sAXException);
            }
            this._atts.clear();
            this._elementName = null;
        }
        this._allowAtts = false;
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            return;
        }
        this._namespaces.addMapping(string, string2);
        StringBuffer stringBuffer = new StringBuffer(XMLNS_DECL);
        if (string.length() > 0) {
            stringBuffer.append(':');
            stringBuffer.append(string);
        }
        this._atts.addAttribute(stringBuffer.toString(), string2);
    }

    public void endElement(String string, String string2) {
        String string3;
        this.content();
        String string4 = "";
        int n = string.indexOf(58);
        if (n > 0) {
            if (string2 == null) {
                string = string.substring(n);
            } else {
                string3 = this._namespaces.getPrefix(string2);
                if (string3 != null && !string3.equals(string4)) {
                    string = String.valueOf(string3) + ':' + string.substring(n);
                }
            }
        } else if (string2 != null && (string3 = this._namespaces.getPrefix(string2)) != null && string3.length() > 0) {
            string = String.valueOf(string3) + ':' + string;
        }
        this.removeNamespaces();
        try {
            this._handler.endElement(string);
        }
        catch (SAXException sAXException) {
            this.receiveError(sAXException);
        }
    }

    public void entityReference(String string) {
        this.content();
        this._handler.entityReference(string);
    }

    public void flush() {
        this.content();
        try {
            this._handler.endDocument();
        }
        catch (SAXException sAXException) {
            this.receiveError(sAXException);
        }
    }

    public ResultHandler getResultHandler() {
        return this._handler;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        try {
            this._handler.ignorableWhitespace(cArray, n, n2);
        }
        catch (SAXException sAXException) {
            this.receiveError(sAXException);
        }
    }

    public boolean isNamespaceDeclared(String string) {
        return this._namespaces.getPrefix(string) != null;
    }

    public void processingInstruction(String string, String string2) {
        this.content();
        try {
            this._handler.processingInstruction(string, string2);
        }
        catch (SAXException sAXException) {
            this.receiveError(sAXException);
        }
    }

    private void removeNamespaces() {
        this._namespaces = this._namespaces.previous;
    }

    public void startElement(String string, String string2) {
        this.content();
        this.addNamespaces();
        int n = string.indexOf(58);
        if (n > 0) {
            string = string.substring(n);
        }
        this._elementName = string;
        this._namespace = string2;
        this._allowAtts = true;
    }

    public void unescapedCharacters(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        this.unescapedCharacters(cArray, 0, cArray.length);
    }

    public void unescapedCharacters(char[] cArray, int n, int n2) {
        block2: {
            if (XMLUtil.isWhitespace(cArray, n, n2)) break block2;
            this.content();
            try {
                this._handler.characters(cArray, n, n2);
            }
            catch (SAXException sAXException) {
                this.receiveError(sAXException);
            }
        }
    }

    class Namespaces {
        private String defaultNS = null;
        NSMapping nsMapping = null;
        Namespaces previous = null;

        Namespaces() {
        }

        static /* synthetic */ String access$0(Namespaces namespaces) {
            return namespaces.defaultNS;
        }

        void addMapping(String string, String string2) {
            if (string2 == null) {
                return;
            }
            if (string == null || string.length() == 0) {
                this.defaultNS = string2;
            }
            NSMapping nSMapping = new NSMapping();
            nSMapping.prefix = string;
            nSMapping.namespace = string2;
            if (this.nsMapping != null) {
                nSMapping.next = this.nsMapping;
            }
            this.nsMapping = nSMapping;
        }

        String getNamespace(String string) {
            NSMapping nSMapping = this.nsMapping;
            while (nSMapping != null) {
                if (string.equals(nSMapping.prefix)) {
                    return nSMapping.namespace;
                }
                nSMapping = nSMapping.next;
            }
            if (this.previous != null) {
                return this.previous.getNamespace(string);
            }
            return null;
        }

        String getPrefix(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals(this.defaultNS)) {
                return "";
            }
            NSMapping nSMapping = this.nsMapping;
            while (nSMapping != null) {
                if (string.equals(nSMapping.namespace)) {
                    return nSMapping.prefix;
                }
                nSMapping = nSMapping.next;
            }
            if (this.previous != null) {
                return this.previous.getPrefix(string);
            }
            return null;
        }
    }

    class NSMapping {
        String prefix = null;
        String namespace = null;
        NSMapping next = null;

        NSMapping() {
        }
    }
}

