/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.handlers;

import org.exolab.adaptx.util.QuickStack;
import org.exolab.adaptx.xml.XMLUtil;
import org.exolab.adaptx.xslt.OutputFormat;
import org.exolab.adaptx.xslt.ResultHandler;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DOMBuilder
implements ResultHandler {
    private static final String RESULT_NAME = "xslp:result";
    private static final String NO_DOC_ELEMENT = "xslp:result has been added, because nodes were being added to the result tree, but no document element was present. XSLT result tree's must be well-formed. ";
    private static final String MULITPLE_DOC_ELEMENTS = "xslp:result has been added, because an element was being added to the result tree at the document level, but a document element already existed. XSLT result tree's must be well-formed. ";
    private StringBuffer buffer = null;
    QuickStack nodeStack = null;
    private Document document = null;
    private boolean started = false;
    private short fragCount = 0;
    private boolean finished = false;

    public DOMBuilder(Document document) {
        if (document == null) {
            String string = "Document passed to constructor of DOMBuilder must not be null.";
            throw new IllegalArgumentException(string);
        }
        Element element = document.getDocumentElement();
        if (element != null) {
            document.removeChild(element);
        }
        this.document = document;
        this.nodeStack = new QuickStack();
        this.nodeStack.push(document);
        this.buffer = new StringBuffer();
    }

    public DOMBuilder(Node node) {
        if (node == null) {
            String string = "The DOM node passed to constructor of DOMBuilder must not be null.";
            throw new IllegalArgumentException(string);
        }
        switch (node.getNodeType()) {
            case 1: {
                this.document = node.getOwnerDocument();
                break;
            }
            case 9: {
                this.document = (Document)node;
                break;
            }
            default: {
                String string = "Invalid node type. The DOM node passed to the constructor of DOMBuilder must be either an Element node or a Document node.";
                throw new IllegalArgumentException(string);
            }
        }
        this.nodeStack = new QuickStack();
        this.nodeStack.push(node);
        this.buffer = new StringBuffer();
    }

    public void cdata(char[] cArray, int n, int n2) {
        Node node;
        Node node2 = (Node)this.nodeStack.peek();
        if (node2 == this.document) {
            if (XMLUtil.isWhitespace(cArray, n, n2)) {
                return;
            }
            node = this.document.createElement(RESULT_NAME);
            this.document.appendChild(node);
            node2 = node;
            Comment comment = this.document.createComment(NO_DOC_ELEMENT);
            node2.appendChild(comment);
        }
        this.buffer.append(cArray, n, n2);
        node = this.document.createCDATASection(this.buffer.toString());
        node2.appendChild(node);
        this.buffer.setLength(0);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Node node;
        Node node2 = (Node)this.nodeStack.peek();
        if (node2 == this.document) {
            if (XMLUtil.isWhitespace(cArray, n, n2)) {
                return;
            }
            node = this.document.createElement(RESULT_NAME);
            this.document.appendChild(node);
            node2 = node;
            Comment comment = this.document.createComment(NO_DOC_ELEMENT);
            node2.appendChild(comment);
        }
        this.buffer.append(cArray, n, n2);
        node = this.document.createTextNode(this.buffer.toString());
        node2.appendChild(node);
        this.buffer.setLength(0);
    }

    public void comment(String string) {
        Node node = (Node)this.nodeStack.peek();
        Comment comment = this.document.createComment(string);
        node.appendChild(comment);
    }

    public void endDocument() throws SAXException {
        this.started = false;
        this.finished = true;
    }

    public void endElement(String string) throws SAXException {
        Node node = (Node)this.nodeStack.peek();
        String string2 = node.getNodeName();
        if (!string2.equals(string)) {
            String string3 = "element mismatch error, expecting </";
            string3 = String.valueOf(string3) + string2 + ">, but recieved </";
            string3 = String.valueOf(string3) + string + "> instead.";
            throw new SAXException(string3);
        }
        this.nodeStack.pop();
        this.finished = this.nodeStack.size() == 1;
    }

    public void entityReference(String string) {
        Node node = (Node)this.nodeStack.peek();
        EntityReference entityReference = this.document.createEntityReference(string);
        node.appendChild(entityReference);
    }

    protected Node getCurrentNode() {
        return (Node)this.nodeStack.peek();
    }

    Document getDocument() {
        return this.document;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        ProcessingInstruction processingInstruction = null;
        processingInstruction = this.document.createProcessingInstruction(string, string2);
        Node node = (Node)this.nodeStack.peek();
        node.appendChild(processingInstruction);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setEscapeText(boolean bl) {
    }

    public void setIndentSize(short s) {
    }

    public void setOutputFormat(OutputFormat outputFormat) {
    }

    public void startDocument() throws SAXException {
        this.started = true;
        this.finished = false;
    }

    protected DocumentFragment startDocumentFragment() {
        DocumentFragment documentFragment = this.document.createDocumentFragment();
        this.nodeStack.push(documentFragment);
        this.fragCount = (short)(this.fragCount + 1);
        return documentFragment;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string == null) {
            throw new SAXException("missing element name");
        }
        Node node = (Node)this.nodeStack.peek();
        Element element = null;
        if (node == this.document && (element = this.document.getDocumentElement()) != null) {
            this.document.removeChild(element);
            Element element2 = this.document.createElement(RESULT_NAME);
            this.document.appendChild(element2);
            element2.appendChild(element);
            node = element2;
            Comment comment = this.document.createComment(MULITPLE_DOC_ELEMENTS);
            node.appendChild(comment);
        }
        element = this.document.createElement(string);
        if (attributeList != null) {
            int n = 0;
            while (n < attributeList.getLength()) {
                element.setAttribute(attributeList.getName(n), attributeList.getValue(n));
                ++n;
            }
        }
        node.appendChild(element);
        this.nodeStack.push(element);
    }

    protected void stopDocumentFragment() {
        if (this.fragCount > 0) {
            Node node = (Node)this.nodeStack.peek();
            if (node.getNodeType() == 11) {
                this.nodeStack.pop();
            }
            this.fragCount = (short)(this.fragCount - 1);
        }
    }

    public void unescapedCharacters(char[] cArray, int n, int n2) {
        this.cdata(cArray, n, n2);
    }
}

