/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.functions;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.NumberResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.functions.FunctionCallImpl;

public class SumFunctionCall
extends FunctionCallImpl {
    private static final String SUM = "sum";

    public SumFunctionCall() {
        super(SUM);
    }

    public double computeSum(NodeSet nodeSet) throws XPathException {
        double d = 0.0;
        int n = 0;
        while (n < nodeSet.size()) {
            d += this.getNodeValue(nodeSet.item(n));
            ++n;
        }
        return d;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.getParameterCount() != 1) {
            throw new XPathException("invalid number of parameters for function: " + this.toString());
        }
        XPathResult xPathResult = this.getParameter(0).evaluate(xPathContext);
        if (xPathResult.getResultType() != 3) {
            String string = "unexpected result for function: " + this.toString();
            throw new XPathException(String.valueOf(string) + "; a node-set was expected.");
        }
        return new NumberResult(this.computeSum((NodeSet)xPathResult));
    }

    private double getNodeValue(XPathNode xPathNode) throws XPathException {
        String string = xPathNode.getStringValue();
        double d = 0.0;
        if (string != null && string.length() > 0) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Non-numeric value(s) encountered as arguments to the sum() function.";
                throw new XPathException(string2);
            }
        }
        return d;
    }
}

