/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.ErrorExpr;
import org.exolab.adaptx.xpath.engine.PathExprImpl;
import org.exolab.adaptx.xpath.expressions.PathExpr;
import org.exolab.adaptx.xpath.expressions.UnionExpr;

class UnionExprImpl
extends UnionExpr {
    private ErrorExpr error = null;
    private PathExprImpl _pathExpr = null;
    private UnionExprImpl _unionExpr = null;

    public UnionExprImpl() {
    }

    public UnionExprImpl(ErrorExpr errorExpr) {
        this.error = errorExpr;
    }

    public UnionExprImpl(PathExprImpl pathExprImpl) {
        this._pathExpr = pathExprImpl;
    }

    public UnionExprImpl(PathExprImpl pathExprImpl, UnionExprImpl unionExprImpl) {
        this._pathExpr = pathExprImpl;
        this._unionExpr = unionExprImpl;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        NodeSet nodeSet = null;
        if (this._pathExpr != null) {
            nodeSet = this._pathExpr.evaluate(xPathContext, true);
        }
        if (this._unionExpr != null) {
            nodeSet.add((NodeSet)this._unionExpr.evaluate(xPathContext));
        }
        if (nodeSet == null) {
            return xPathContext.newNodeSet();
        }
        return nodeSet;
    }

    public PathExpr getMatchingExpr(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        PathExpr pathExpr;
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        PathExpr pathExpr2 = null;
        if (this._pathExpr != null && this._pathExpr.matches(xPathNode, xPathContext)) {
            pathExpr2 = this._pathExpr;
        }
        if (this._unionExpr != null && (pathExpr = this._unionExpr.getMatchingExpr(xPathNode, xPathContext)) != null) {
            if (pathExpr2 == null) {
                return pathExpr;
            }
            if (pathExpr.getDefaultPriority() > ((PathExpr)pathExpr2).getDefaultPriority()) {
                pathExpr2 = pathExpr;
            }
        }
        return pathExpr2;
    }

    public PathExpr getPathExpr() {
        return this._pathExpr;
    }

    public UnionExpr getUnionExpr() {
        return this._unionExpr;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        if (this.error != null) {
            this.error.evaluate(null);
        }
        if (this._pathExpr != null && this._pathExpr.matches(xPathNode, xPathContext)) {
            return true;
        }
        if (this._unionExpr != null) {
            return this._unionExpr.matches(xPathNode, xPathContext);
        }
        return false;
    }

    public void setPathExpr(PathExprImpl pathExprImpl) {
        this._pathExpr = pathExprImpl;
    }

    public void setUnionExpr(UnionExprImpl unionExprImpl) {
        this._unionExpr = unionExprImpl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    private void toString(StringBuffer stringBuffer) {
        if (this._pathExpr != null) {
            stringBuffer.append(this._pathExpr.toString());
        }
        if (this._unionExpr != null) {
            stringBuffer.append(" | ");
            this._unionExpr.toString(stringBuffer);
        }
    }
}

