/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.BinaryExprImpl;
import org.exolab.adaptx.xpath.engine.NumericOperation;
import org.exolab.adaptx.xpath.engine.NumericOperator;
import org.exolab.adaptx.xpath.expressions.Operator;

class MultiplicativeExpr
extends BinaryExprImpl {
    public static final short MULTIPLY = 0;
    public static final short DIVIDE = 1;
    public static final short MODULUS = 2;
    public static final short QUOTIENT = 3;
    private short op = 0;
    private static final String[] ops = new String[]{"*", "div", "mod", "quo"};
    private static final NumericOperator[] _operators = new NumericOperator[]{new NumericOperator(new MultiplyOperation(), 5), new NumericOperator(new DivideOperation(), 2), new NumericOperator(new ModulusOperation(), 4), new NumericOperator(new QuotientOperation(), 7)};

    public MultiplicativeExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        super(xPathExpression, xPathExpression2);
    }

    public MultiplicativeExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2, String string) throws XPathException {
        super(xPathExpression, xPathExpression2);
        this.op = (short)-1;
        if (string != null) {
            int n = 0;
            while (n < ops.length) {
                if (ops[n].equals(string)) {
                    this.op = (short)n;
                    break;
                }
                n = (short)(n + 1);
            }
        }
        if (this.op == -1) {
            String string2 = "The operator '" + string + "' is invalid for a muliplicative expression.";
            throw new XPathException(string2);
        }
    }

    public MultiplicativeExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2, short s) throws XPathException {
        super(xPathExpression, xPathExpression2);
        if (s < 0 || s >= ops.length) {
            throw new XPathException("invalid operator for multiplicative expression");
        }
        this.op = s;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        NumericOperator numericOperator = _operators[this.op];
        return numericOperator.execute(this.getLeftSide(), this.getRightSide(), xPathContext);
    }

    public short getExprType() {
        return 4;
    }

    public Operator getOperator() {
        return _operators[this.op];
    }

    public static boolean isMultiplicativeOperator(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < ops.length) {
            if (ops[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static class DivideOperation
    implements NumericOperation {
        DivideOperation() {
        }

        public double execute(double d, double d2) {
            return d / d2;
        }

        public String toString() {
            return "div";
        }
    }

    static class ModulusOperation
    implements NumericOperation {
        ModulusOperation() {
        }

        public double execute(double d, double d2) {
            return d % d2;
        }

        public String toString() {
            return "mod";
        }
    }

    static class MultiplyOperation
    implements NumericOperation {
        MultiplyOperation() {
        }

        public double execute(double d, double d2) {
            return d * d2;
        }

        public String toString() {
            return "*";
        }
    }

    static class QuotientOperation
    implements NumericOperation {
        QuotientOperation() {
        }

        public double execute(double d, double d2) {
            return Math.floor(d / d2);
        }

        public String toString() {
            return "quo";
        }
    }
}

