/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.engine.ParseException;
import org.exolab.adaptx.xpath.engine.Token;
import org.exolab.adaptx.xpath.engine.TokenItem;

public class Lexer {
    private static final String INVALID_AXIS_IDENTIFIER = "invalid axis identifier";
    public static final char FORWARD_SLASH = '/';
    public static final char L_PAREN = '(';
    public static final char R_PAREN = ')';
    public static final char L_BRACKET = '[';
    public static final char R_BRACKET = ']';
    public static final char PERIOD = '.';
    public static final char COMMA = ',';
    public static final char AT_SYMBOL = '@';
    public static final char DOLLAR_SYMBOL = '$';
    public static final char S_QUOTE = '\'';
    public static final char D_QUOTE = '\"';
    public static final char VERT_BAR = '|';
    public static final char COLON = ':';
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char NEGATION_OP = '!';
    public static final char EQUALS_OP = '=';
    public static final char ADDITION_OP = '+';
    public static final char SUBTRACTION_OP = '-';
    public static final char LESS_THAN_OP = '<';
    public static final char GREATER_THAN_OP = '>';
    public static final char MULTIPLY_OP = '*';
    private static final char[] delimiters = new char[]{'/', '|', '(', ')', '[', ']', '.', ',', '@', '$', '\'', '\"', ':', ' ', '\t', '\r', '\n', '!', '=', '+', '-', '*', '<', '>'};
    public static final Token[] tokenSet = new Token[]{new Token("and", 301), new Token("or", 302), new Token("mod", 303), new Token("div", 304), new Token("quo", 305), new Token("comment", 202), new Token("processing-instruction", 204), new Token("node", 201), new Token("text", 203), new Token("*", 101), new Token("ancestor", 601), new Token("ancestor-or-self", 602), new Token("attribute", 603), new Token("child", 604), new Token("descendant", 605), new Token("descendant-or-self", 606), new Token("following", 607), new Token("following-sibling", 608), new Token("namespace", 613), new Token("parent", 609), new Token("preceding", 610), new Token("preceding-sibling", 611), new Token("self", 612)};
    private TokenItem first = null;
    private TokenItem current = null;
    private TokenItem prev = null;
    private TokenItem last = new TokenItem(new Token(null, 0));

    public Lexer(String string) throws ParseException {
        this.parse(string);
    }

    private void addToken(Token token) {
        TokenItem tokenItem = new TokenItem(token);
        if (this.first == null) {
            this.current = tokenItem;
            this.first = tokenItem;
            this.last = tokenItem;
        } else {
            tokenItem.prevItem = this.last;
            this.last.nextItem = tokenItem;
            this.last = tokenItem;
        }
    }

    public int countTokens() {
        if (this.current == null) {
            return 0;
        }
        TokenItem tokenItem = this.current;
        int n = 1;
        while ((tokenItem = tokenItem.nextItem) != null) {
            ++n;
        }
        return n;
    }

    private Token delimiterToken(char c) {
        switch (c) {
            case '/': {
                return new Token(null, 306);
            }
            case '|': {
                return new Token(null, 308);
            }
            case '(': {
                return new Token(null, 1);
            }
            case ')': {
                return new Token(null, 2);
            }
            case '[': {
                return new Token(null, 3);
            }
            case ']': {
                return new Token(null, 4);
            }
            case '.': {
                return new Token(null, 5);
            }
            case ',': {
                return new Token(null, 6);
            }
            case '@': {
                return new Token(null, 7);
            }
            case '=': {
                return new Token(null, 312);
            }
            case '+': {
                return new Token(null, 309);
            }
            case '-': {
                return new Token(null, 310);
            }
            case '*': {
                return new Token(null, 311);
            }
            case '<': {
                return new Token(null, 314);
            }
            case '>': {
                return new Token(null, 315);
            }
        }
        return null;
    }

    private void freeBuffer(StringBuffer stringBuffer, char c) {
        if (stringBuffer.length() > 0) {
            String string = stringBuffer.toString();
            Token token = this.match(string, c);
            if (token != null) {
                if (Lexer.isAxisIdentifier(token)) {
                    if (c == ':') {
                        this.addToken(token);
                    } else {
                        token = null;
                    }
                } else {
                    if (Lexer.isMultiplicativeOp(token)) {
                        if (this.last == null || this.last.token.type == 0 || this.last.token.type == 7 || this.last.token.type == 1 || this.last.token.type == 3 || this.isOperator(this.last.token)) {
                            token.type = (short)102;
                        }
                    } else if (token.type == 301 || token.type == 302) {
                        if (this.last == null || this.last.token.type == 0 || this.isOperator(this.last.token)) {
                            token.type = (short)102;
                        }
                    } else if (this.last != null && this.last.token.type == 7 && token.type != 101) {
                        token.type = (short)102;
                    }
                    this.addToken(token);
                }
            }
            if (token == null) {
                this.addToken(new Token(string, 102));
            }
            stringBuffer.setLength(0);
        }
    }

    public boolean hasMoreTokens() {
        return this.current != null;
    }

    public static boolean isAdditiveOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 309: 
            case 310: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAxisIdentifier(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: 
            case 613: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinaryOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: {
                return true;
            }
        }
        return false;
    }

    public boolean isDelimiter(char c) {
        int n = 0;
        while (n < delimiters.length) {
            if (c == delimiters[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isEqualityOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 312: 
            case 313: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLetter(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isMultiplicativeOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 303: 
            case 304: 
            case 305: 
            case 311: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNCNameChar(char c) {
        if (Lexer.isLetter(c)) {
            return true;
        }
        if (Lexer.isDigit(c)) {
            return true;
        }
        return c == '.' || c == '_' || c == '-';
    }

    public boolean isOperator(Token token) {
        if (token == null) {
            return false;
        }
        if (Lexer.isBinaryOp(token)) {
            return true;
        }
        switch (token.type) {
            case 306: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public static boolean isQNameChar(char c) {
        return Lexer.isNCNameChar(c) || c == ':';
    }

    public static boolean isRelationalOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 314: 
            case 315: 
            case 316: 
            case 317: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public Token lookAhead(int n) throws IllegalArgumentException {
        if (n < 0) {
            return null;
        }
        TokenItem tokenItem = this.current;
        int n2 = 0;
        while (n2 < n) {
            if (tokenItem == null) {
                return null;
            }
            tokenItem = tokenItem.nextItem;
            ++n2;
        }
        if (tokenItem == null) {
            return null;
        }
        return tokenItem.token;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        var1_1 = null;
        var1_1 = "(not($exclude-unused-prefixes) or ($element | $element//@* | $element//*)[namespace-uri()=current()]) and not(string($declaredAbove)) and name()!='xml'";
        System.out.println("Expr: " + var1_1);
        var2_2 = null;
        try {
            var2_2 = new Lexer(var1_1);
            if (true) ** GOTO lbl24
        }
        catch (ParseException var3_3) {
            System.out.println(var3_3.toString());
            return;
        }
        do {
            var3_4 = var2_2.nextToken();
            var4_5 = var3_4.toString();
            System.out.print("TOKEN: " + var4_5);
            var5_6 = 0;
            if (var4_5 != null) {
                var5_6 = var4_5.length();
            }
            var6_7 = var5_6;
            while (var6_7 < 20) {
                System.out.print(" ");
                ++var6_7;
            }
            System.out.println(" type: " + var3_4.type);
lbl24:
            // 2 sources

        } while (var2_2.hasMoreTokens());
    }

    private Token match(String string, char c) {
        if (string == null) {
            return new Token(null, 0);
        }
        int n = 0;
        while (n < tokenSet.length) {
            Token token = tokenSet[n];
            if (token.value.equals(string)) {
                return new Token(token.value, token.type);
            }
            ++n;
        }
        return null;
    }

    public Token nextToken() {
        this.prev = this.current;
        if (this.current != null) {
            this.current = this.current.nextItem;
        }
        if (this.prev != null) {
            return this.prev.token;
        }
        return null;
    }

    private void parse(String string) throws ParseException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        char[] cArray = string.toCharArray();
        char c2 = '\'';
        int n = 0;
        block28: while (n < cArray.length) {
            char c3 = c;
            c = cArray[n++];
            if (bl) {
                switch (c) {
                    case '\"': 
                    case '\'': {
                        if (c == c2) {
                            bl = false;
                            this.addToken(new Token(stringBuffer.toString(), 701));
                            stringBuffer.setLength(0);
                            break;
                        }
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            if (bl2) {
                if (Lexer.isDigit(c) || c == '.') {
                    stringBuffer.append(c);
                    continue;
                }
                bl2 = false;
                this.addToken(new Token(stringBuffer.toString(), 401));
                stringBuffer.setLength(0);
                --n;
                continue;
            }
            if (bl3) {
                if (c == '-') {
                    char c4 = '\u0000';
                    if (n < cArray.length) {
                        c4 = cArray[n];
                    }
                    if (!Lexer.isNCNameChar(c4)) {
                        bl3 = false;
                    } else {
                        stringBuffer.append(c);
                    }
                } else if (Lexer.isNCNameChar(c)) {
                    stringBuffer.append(c);
                } else {
                    bl3 = false;
                }
                if (bl3) continue;
                this.addToken(new Token(stringBuffer.toString(), 801));
                stringBuffer.setLength(0);
                --n;
                continue;
            }
            if (this.isDelimiter(c)) {
                Token token = null;
                block3 : switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        this.freeBuffer(stringBuffer, c);
                        break;
                    }
                    case '(': {
                        this.freeBuffer(stringBuffer, c);
                        if (this.last.token.type == 102) {
                            this.last.token.type = (short)501;
                        }
                        this.addToken(new Token(null, 1));
                        break;
                    }
                    case ')': {
                        this.freeBuffer(stringBuffer, c);
                        this.addToken(new Token(null, 2));
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        this.freeBuffer(stringBuffer, c);
                        bl = true;
                        c2 = c;
                        break;
                    }
                    case '/': {
                        this.freeBuffer(stringBuffer, c);
                        switch (this.last.token.type) {
                            case 306: {
                                this.last.token.type = (short)307;
                                break block3;
                            }
                            case 307: {
                                throw new ParseException(string, "too many '/'", n);
                            }
                        }
                        this.addToken(new Token(null, 306));
                        break;
                    }
                    case '.': {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(c);
                            break;
                        }
                        switch (this.last.token.type) {
                            case 802: {
                                this.last.token.type = (short)803;
                                break block3;
                            }
                            case 803: {
                                throw new ParseException(string, "too many '.'", n);
                            }
                        }
                        this.addToken(new Token(null, 802));
                        break;
                    }
                    case ':': {
                        char c5;
                        if (cArray.length > n) {
                            c5 = cArray[n];
                            if (c5 == ':') {
                                this.freeBuffer(stringBuffer, c);
                                if (Lexer.isAxisIdentifier(this.last.token)) {
                                    ++n;
                                    break;
                                }
                                throw new ParseException(string, INVALID_AXIS_IDENTIFIER, n);
                            }
                            if (c5 == '*') {
                                stringBuffer.append(c);
                                stringBuffer.append('*');
                                ++n;
                                break;
                            }
                            stringBuffer.append(c);
                            break;
                        }
                        throw new ParseException(string, "missing remainder of expression", n);
                    }
                    case '$': {
                        this.freeBuffer(stringBuffer, c);
                        bl3 = true;
                        break;
                    }
                    case '@': {
                        this.freeBuffer(stringBuffer, c);
                        this.addToken(new Token("@", 7));
                        break;
                    }
                    case '!': {
                        char c5;
                        this.freeBuffer(stringBuffer, c);
                        if (cArray.length > n) {
                            if ((c5 = cArray[n++]) != '=') {
                                throw new ParseException(string, "missing '=' after '!'", n);
                            }
                        } else {
                            throw new ParseException(string, "illegal end of expression", n);
                        }
                        this.addToken(new Token("!=", 313));
                        break;
                    }
                    case '=': {
                        if (stringBuffer.length() == 0) {
                            if (this.last.token.type == 314) {
                                this.last.token.type = (short)316;
                                break;
                            }
                            if (this.last.token.type == 315) {
                                this.last.token.type = (short)317;
                                break;
                            }
                        }
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '<': 
                    case '>': {
                        if (stringBuffer.length() > 0 && c != '-') {
                            this.freeBuffer(stringBuffer, c);
                            this.addToken(this.delimiterToken(c));
                            break;
                        }
                        if (!this.isOperator(this.last.token) && !Lexer.isAxisIdentifier(this.last.token)) {
                            switch (this.last.token.type) {
                                case 0: 
                                case 1: 
                                case 3: 
                                case 6: 
                                case 7: {
                                    stringBuffer.append(c);
                                    break block3;
                                }
                            }
                            this.freeBuffer(stringBuffer, c);
                            this.addToken(this.delimiterToken(c));
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    default: {
                        this.freeBuffer(stringBuffer, c);
                        token = this.delimiterToken(c);
                        if (token == null) continue block28;
                        this.addToken(token);
                        break;
                    }
                }
                continue;
            }
            if (Lexer.isDigit(c)) {
                if (stringBuffer.length() == 0 || stringBuffer.length() == 1 && c3 == '-') {
                    bl2 = true;
                    stringBuffer.append(c);
                    continue;
                }
                Token token = this.match(stringBuffer.toString(), c);
                if (token != null && this.isOperator(token)) {
                    this.addToken(token);
                    stringBuffer.setLength(0);
                    stringBuffer.append(c);
                    bl2 = true;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl2) {
            this.addToken(new Token(stringBuffer.toString(), 401));
        } else {
            if (bl) {
                throw new ParseException(string, "missing remainder of string literal", n);
            }
            if (bl3) {
                this.addToken(new Token(stringBuffer.toString(), 801));
            } else {
                this.freeBuffer(stringBuffer, c);
            }
        }
        if (this.countTokens() > 1 && this.isOperator(this.last.token)) {
            String string2 = "missing remainder of expression.";
            throw new ParseException(string, string2, string.length());
        }
    }

    public void pushBack() {
        if (this.current != this.first) {
            this.current = this.prev;
            this.prev = this.prev.prevItem;
        }
    }

    public void resetPosition() {
        this.current = this.first;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        TokenItem tokenItem = this.first;
        while (tokenItem != null) {
            stringBuffer.append(tokenItem.token);
            tokenItem = tokenItem.nextItem;
        }
        return stringBuffer.toString();
    }

    public String toStringPrevious() {
        StringBuffer stringBuffer = new StringBuffer();
        TokenItem tokenItem = this.first;
        while (tokenItem != null && tokenItem != this.current) {
            stringBuffer.append(tokenItem.token);
            tokenItem = tokenItem.nextItem;
        }
        return stringBuffer.toString();
    }

    public String toStringRemainder() {
        StringBuffer stringBuffer = new StringBuffer();
        TokenItem tokenItem = this.current;
        while (tokenItem != null) {
            stringBuffer.append(tokenItem.token);
            tokenItem = tokenItem.nextItem;
        }
        return stringBuffer.toString();
    }
}

