/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.BooleanResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.BinaryExprImpl;
import org.exolab.adaptx.xpath.expressions.Operator;

class AndExpr
extends BinaryExprImpl {
    private static String AND = " and ";
    private static final Operator _operator = new AndOperator();

    public AndExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        super(xPathExpression, xPathExpression2);
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        return _operator.execute(this.leftExpr, this.rightExpr, xPathContext);
    }

    public short getExprType() {
        return 0;
    }

    public Operator getOperator() {
        return _operator;
    }

    static class AndOperator
    implements Operator {
        AndOperator() {
        }

        public XPathResult execute(XPathExpression xPathExpression, XPathExpression xPathExpression2, XPathContext xPathContext) throws XPathException {
            if (xPathExpression == null || xPathExpression2 == null) {
                return BooleanResult.FALSE;
            }
            if (!xPathExpression.evaluate(xPathContext).booleanValue()) {
                return BooleanResult.FALSE;
            }
            return BooleanResult.from(xPathExpression2.evaluate(xPathContext));
        }

        public XPathResult execute(XPathResult xPathResult, XPathResult xPathResult2) throws XPathException {
            if (xPathResult == null || xPathResult2 == null) {
                return BooleanResult.FALSE;
            }
            if (!xPathResult.booleanValue()) {
                return BooleanResult.FALSE;
            }
            return BooleanResult.from(xPathResult2.booleanValue());
        }

        public int getOperatorType() {
            return 1;
        }

        public String toString() {
            return AND;
        }
    }
}

