/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NumberResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.BinaryExprImpl;
import org.exolab.adaptx.xpath.expressions.Operator;

class AdditionExpr
extends BinaryExprImpl {
    static final String OP_STRING = " + ";
    private static final Operator _operator = new AddOperator();

    public AdditionExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        super(xPathExpression, xPathExpression2);
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        return _operator.execute(this.getLeftSide(), this.getRightSide(), xPathContext);
    }

    public short getExprType() {
        return 4;
    }

    public Operator getOperator() {
        return _operator;
    }

    static class AddOperator
    implements Operator {
        AddOperator() {
        }

        public XPathResult execute(XPathExpression xPathExpression, XPathExpression xPathExpression2, XPathContext xPathContext) throws XPathException {
            if (xPathExpression == null || xPathExpression2 == null) {
                return NumberResult.NaN;
            }
            XPathResult xPathResult = xPathExpression2.evaluate(xPathContext);
            XPathResult xPathResult2 = xPathExpression.evaluate(xPathContext);
            return new NumberResult(xPathResult2.numberValue() + xPathResult.numberValue());
        }

        public XPathResult execute(XPathResult xPathResult, XPathResult xPathResult2) throws XPathException {
            if (xPathResult == null || xPathResult2 == null) {
                return NumberResult.NaN;
            }
            return new NumberResult(xPathResult.numberValue() + xPathResult2.numberValue());
        }

        public int getOperatorType() {
            return 0;
        }

        public String toString() {
            return AdditionExpr.OP_STRING;
        }
    }
}

