/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.PredicateExprImpl;
import org.exolab.adaptx.xpath.expressions.PathComponent;
import org.exolab.adaptx.xpath.expressions.PredicateExpr;

public abstract class AbstractPathComponent
implements PathComponent {
    PredicateExprImpl _predicate = null;

    public void addPredicate(XPathExpression xPathExpression) throws XPathException {
        this.addPredicate(new PredicateExprImpl(xPathExpression));
    }

    public void addPredicate(PredicateExprImpl predicateExprImpl) throws XPathException {
        if (this._predicate == null) {
            this._predicate = predicateExprImpl;
        } else {
            PredicateExprImpl predicateExprImpl2 = this._predicate;
            while (predicateExprImpl2.hasNext()) {
                predicateExprImpl2 = (PredicateExprImpl)predicateExprImpl2.getNext();
            }
            predicateExprImpl2.setNext(predicateExprImpl);
        }
    }

    public abstract XPathResult evaluate(XPathContext var1) throws XPathException;

    public void evaluatePredicates(NodeSet nodeSet, XPathContext xPathContext) throws XPathException {
        if (this._predicate == null || nodeSet == null) {
            return;
        }
        if (nodeSet.size() == 0) {
            return;
        }
        PredicateExpr predicateExpr = this._predicate;
        NodeSet nodeSet2 = xPathContext.newNodeSet(nodeSet.size());
        while (predicateExpr != null) {
            XPathContext xPathContext2 = xPathContext.newContext(nodeSet, 0);
            int n = 0;
            while (n < nodeSet.size()) {
                if (n > 0) {
                    xPathContext2.setPosition(n);
                }
                XPathResult xPathResult = ((PredicateExpr)predicateExpr).evaluate(xPathContext2);
                switch (xPathResult.getResultType()) {
                    case 1: {
                        double d = xPathResult.numberValue();
                        if (d == (double)(n + 1)) break;
                        nodeSet2.add(xPathContext2.getNode());
                        break;
                    }
                    default: {
                        if (xPathResult.booleanValue()) break;
                        nodeSet2.add(xPathContext2.getNode());
                        break;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < nodeSet2.size()) {
                nodeSet.remove(nodeSet2.item(n));
                ++n;
            }
            nodeSet2.clear();
            predicateExpr = ((PredicateExpr)predicateExpr).getNext();
        }
    }

    public abstract double getDefaultPriority();

    public abstract short getExprType();

    public PredicateExpr getPredicate() {
        return this._predicate;
    }

    public abstract XPathExpression getSubExpression();

    public boolean hasPredicates() {
        return this._predicate != null;
    }

    public abstract boolean isFilterExpr();

    public abstract boolean isLocationStep();

    public abstract boolean matches(XPathNode var1, XPathContext var2) throws XPathException;

    private PredicateExpr removePredicate(PredicateExpr predicateExpr) throws XPathException {
        if (this._predicate == null) {
            return null;
        }
        if (this._predicate == predicateExpr) {
            this._predicate = (PredicateExprImpl)this._predicate.getNext();
        } else {
            PredicateExprImpl predicateExprImpl = (PredicateExprImpl)this._predicate.getNext();
            PredicateExprImpl predicateExprImpl2 = this._predicate;
            while (predicateExprImpl != null) {
                if (predicateExprImpl == predicateExpr) {
                    predicateExprImpl2.setNext((PredicateExprImpl)predicateExprImpl.getNext());
                    return predicateExprImpl;
                }
                predicateExprImpl2 = predicateExprImpl;
                predicateExprImpl = (PredicateExprImpl)predicateExprImpl.getNext();
            }
        }
        return null;
    }

    public String toString() {
        if (this._predicate == null) {
            return "";
        }
        return this._predicate.toString();
    }
}

