/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.exolab.adaptx.util.List;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xslt.dom.BaseNode;
import org.exolab.adaptx.xslt.dom.Element;
import org.exolab.adaptx.xslt.dom.Location;
import org.exolab.adaptx.xslt.dom.XPNReader;

public class XMLDiff {
    private boolean _ignoreWhitespace = true;
    private boolean _returnAtFirstDiff = false;
    private boolean _strictChildOrder = false;
    static /* synthetic */ Class class$org$exolab$adaptx$xml$XMLDiff;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int compare(String string, String string2) throws IOException {
        if (string == null) {
            String string3 = "The argument 'url1' may not be null.";
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = "The argument 'url2' may not be null.";
            throw new IllegalArgumentException(string4);
        }
        XPNReader xPNReader = new XPNReader(string);
        xPNReader.setSaveLocation(true);
        XPathNode xPathNode = xPNReader.read();
        xPNReader = new XPNReader(string2);
        xPNReader.setSaveLocation(true);
        XPathNode xPathNode2 = xPNReader.read();
        StateInfo stateInfo = new StateInfo();
        stateInfo.url1 = string;
        stateInfo.url2 = string2;
        stateInfo.header = true;
        stateInfo.pw = new PrintWriter(System.out, true);
        return this.compare(xPathNode, xPathNode2, stateInfo);
    }

    public int compare(XPathNode xPathNode, String string, XPathNode xPathNode2, String string2) {
        StateInfo stateInfo = new StateInfo();
        stateInfo.url1 = string;
        stateInfo.url2 = string2;
        stateInfo.pw = new PrintWriter(System.out, true);
        stateInfo.header = true;
        return this.compare(xPathNode, xPathNode2, stateInfo);
    }

    public int compare(XPathNode xPathNode, XPathNode xPathNode2) {
        StateInfo stateInfo = new StateInfo();
        stateInfo.url1 = "filename unavailable";
        stateInfo.url2 = "filename unavailable";
        stateInfo.pw = new PrintWriter(System.out, true);
        stateInfo.header = true;
        return this.compare(xPathNode, xPathNode2, stateInfo);
    }

    private int compare(XPathNode xPathNode, XPathNode xPathNode2, StateInfo stateInfo) {
        String string;
        boolean bl;
        int n = 0;
        boolean bl2 = bl = stateInfo.pw != null;
        if (xPathNode.getNodeType() != xPathNode2.getNodeType()) {
            if (bl) {
                stateInfo.pw.println("type differ: <" + xPathNode.getLocalName() + ">");
            }
            return 1;
        }
        String string2 = xPathNode.getNamespaceURI();
        String string3 = xPathNode2.getNamespaceURI();
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (!string2.equals(string3)) {
            if (bl) {
                string = "namespaces differ: ('" + string2 + "' != '" + string3 + "').";
                stateInfo.pw.println(string);
            }
            if (this._returnAtFirstDiff) {
                return 1;
            }
            ++n;
        }
        string = xPathNode.getLocalName();
        String string4 = xPathNode2.getLocalName();
        if (string == null) {
            if (string4 != null) {
                if (bl) {
                    stateInfo.pw.println("names differ: null vs. '" + string4 + '\'');
                }
                return ++n;
            }
        } else if (!string.equals(string4)) {
            if (bl) {
                stateInfo.pw.println("name differ: <" + string + "(1)> != <" + string4 + "(2)>");
            }
            return ++n;
        }
        switch (xPathNode.getNodeType()) {
            case 9: {
                XPathNode xPathNode3 = xPathNode.getFirstChild();
                XPathNode xPathNode4 = xPathNode2.getFirstChild();
                while (xPathNode3 != null && xPathNode4 != null) {
                    int n2;
                    if (this._ignoreWhitespace) {
                        n2 = 0;
                        if (xPathNode3.getNodeType() == 3 && this.compareText(xPathNode3.getStringValue(), "")) {
                            xPathNode3 = xPathNode3.getNext();
                            n2 = 1;
                        }
                        if (xPathNode4.getNodeType() == 3 && this.compareText(xPathNode4.getStringValue(), "")) {
                            xPathNode4 = xPathNode4.getNext();
                            n2 = 1;
                        }
                        if (n2 != 0) continue;
                    }
                    if ((n2 = this.compare(xPathNode3, xPathNode4, stateInfo)) != 0) {
                        if (this._returnAtFirstDiff) {
                            return n2;
                        }
                        n += n2;
                    }
                    xPathNode3 = xPathNode3.getNext();
                    xPathNode4 = xPathNode4.getNext();
                }
                while (xPathNode3 != null) {
                    if (this._ignoreWhitespace && xPathNode3.getNodeType() == 3 && this.compareText(xPathNode3.getStringValue(), "")) {
                        xPathNode3 = xPathNode3.getNext();
                        continue;
                    }
                    if (bl) {
                        this.printLocationInfo(xPathNode3, null, stateInfo);
                        stateInfo.pw.println("- ");
                    }
                    if (this._returnAtFirstDiff) {
                        return 1;
                    }
                    ++n;
                    xPathNode3 = xPathNode3.getNext();
                }
                while (xPathNode4 != null) {
                    if (this._ignoreWhitespace && xPathNode4.getNodeType() == 3 && this.compareText(xPathNode4.getStringValue(), "")) {
                        xPathNode4 = xPathNode4.getNext();
                        continue;
                    }
                    if (bl) {
                        this.printLocationInfo(xPathNode4, null, stateInfo);
                        stateInfo.pw.println("+ ");
                    }
                    if (this._returnAtFirstDiff) {
                        return 1;
                    }
                    ++n;
                    xPathNode4 = xPathNode4.getNext();
                }
                break;
            }
            case 1: {
                if ((n += this.compareElements(xPathNode, xPathNode2, stateInfo)) <= 0 || !this._returnAtFirstDiff) break;
                return n;
            }
            case 2: {
                if (this.compareText(xPathNode.getStringValue(), xPathNode2.getStringValue())) break;
                if (this._returnAtFirstDiff) {
                    return 1;
                }
                ++n;
                break;
            }
            case 3: {
                if (this.compareText(xPathNode.getStringValue(), xPathNode2.getStringValue())) break;
                if (stateInfo.pw != null) {
                    stateInfo.pw.println();
                    this.printLocationInfo(xPathNode, xPathNode2, stateInfo);
                    XMLDiff.printText("- ", xPathNode.getStringValue(), stateInfo.pw);
                    stateInfo.pw.println();
                    XMLDiff.printText("+ ", xPathNode2.getStringValue(), stateInfo.pw);
                }
                if (this._returnAtFirstDiff) {
                    return 1;
                }
                ++n;
                break;
            }
        }
        return n;
    }

    private boolean compareAttributes(XPathNode xPathNode, XPathNode xPathNode2, StateInfo stateInfo) {
        boolean bl;
        XPathNode xPathNode3 = xPathNode.getFirstAttribute();
        XPathNode xPathNode4 = xPathNode2.getFirstAttribute();
        boolean bl2 = bl = stateInfo.pw != null;
        if (xPathNode3 == null) {
            if (xPathNode4 == null) {
                return true;
            }
            if (bl) {
                stateInfo.pw.print("- ");
                XMLDiff.printStartTag(xPathNode, stateInfo.pw);
                stateInfo.pw.print("+ ");
                XMLDiff.printStartTag(xPathNode2, stateInfo.pw);
            }
            return false;
        }
        if (xPathNode4 == null) {
            if (bl) {
                stateInfo.pw.print("- ");
                XMLDiff.printStartTag(xPathNode, stateInfo.pw);
                stateInfo.pw.print("+ ");
                XMLDiff.printStartTag(xPathNode2, stateInfo.pw);
            }
            return false;
        }
        int n = 0;
        while (xPathNode3 != null) {
            String string = xPathNode3.getNamespaceURI();
            String string2 = xPathNode2.getAttribute(string, xPathNode3.getLocalName());
            if (string2 == null) {
                if (bl) {
                    stateInfo.pw.print("- ");
                    XMLDiff.printStartTag(xPathNode, stateInfo.pw);
                    stateInfo.pw.print("+ ");
                    XMLDiff.printStartTag(xPathNode2, stateInfo.pw);
                    stateInfo.pw.println("The attribute '" + xPathNode3.getLocalName() + "' does not exist in the second node.");
                }
                return false;
            }
            String string3 = xPathNode3.getStringValue();
            if (!this.compareText(string3, string2)) {
                boolean bl3 = false;
                int n2 = string3.indexOf(58);
                int n3 = string2.indexOf(58);
                if (n2 >= 0 || n3 >= 0) {
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    String string7 = "";
                    if (n2 >= 0) {
                        string4 = string3.substring(0, n2);
                        string3 = string3.substring(n2 + 1);
                    }
                    string6 = xPathNode.getNamespaceURI(string4);
                    if (n3 >= 0) {
                        string5 = string2.substring(0, n3);
                        string2 = string2.substring(n3 + 1);
                    }
                    string7 = xPathNode2.getNamespaceURI(string5);
                    if (this.compareText(string3, string2)) {
                        if (string6 == null) {
                            string6 = "";
                        }
                        if (string7 == null) {
                            string7 = "";
                        }
                        bl3 = string6.equals(string7);
                    }
                }
                if (!bl3 && bl) {
                    stateInfo.pw.print("- ");
                    XMLDiff.printStartTag(xPathNode, stateInfo.pw);
                    stateInfo.pw.print("+ ");
                    XMLDiff.printStartTag(xPathNode2, stateInfo.pw);
                    stateInfo.pw.println("The attribute '" + xPathNode3.getLocalName() + "' contains a difference value in the second node.");
                }
                return bl3;
            }
            ++n;
            xPathNode3 = xPathNode3.getNext();
        }
        int n4 = 0;
        while (xPathNode4 != null) {
            ++n4;
            xPathNode4 = xPathNode4.getNext();
        }
        if (n != n4) {
            if (bl) {
                this.printLocationInfo(xPathNode, xPathNode2, stateInfo);
                stateInfo.pw.print("- ");
                XMLDiff.printStartTag(xPathNode, stateInfo.pw);
                stateInfo.pw.print("+ ");
                XMLDiff.printStartTag(xPathNode2, stateInfo.pw);
            }
            return false;
        }
        return true;
    }

    private int compareElements(XPathNode xPathNode, XPathNode xPathNode2, StateInfo stateInfo) {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = stateInfo.pw != null;
        if (!this.compareAttributes(xPathNode, xPathNode2, stateInfo)) {
            if (this._returnAtFirstDiff) {
                return 1;
            }
            ++n;
        }
        String string = xPathNode.getLocalName();
        String string2 = xPathNode2.getLocalName();
        if (this._strictChildOrder) {
            XPathNode xPathNode3 = xPathNode.getFirstChild();
            XPathNode xPathNode4 = xPathNode2.getFirstChild();
            while (xPathNode3 != null && xPathNode4 != null) {
                int n2;
                if (this._ignoreWhitespace) {
                    n2 = 0;
                    if (xPathNode3.getNodeType() == 3 && this.compareText(xPathNode3.getStringValue(), "")) {
                        xPathNode3 = xPathNode3.getNext();
                        n2 = 1;
                    }
                    if (xPathNode4.getNodeType() == 3 && this.compareText(xPathNode4.getStringValue(), "")) {
                        xPathNode4 = xPathNode4.getNext();
                        n2 = 1;
                    }
                    if (n2 != 0) continue;
                }
                if ((n2 = this.compare(xPathNode3, xPathNode4, stateInfo)) != 0) {
                    if (this._returnAtFirstDiff) {
                        return n2;
                    }
                    n += n2;
                }
                xPathNode3 = xPathNode3.getNext();
                xPathNode4 = xPathNode4.getNext();
            }
            while (xPathNode3 != null) {
                if (this._ignoreWhitespace && xPathNode3.getNodeType() == 3 && this.compareText(xPathNode3.getStringValue(), "")) {
                    xPathNode3 = xPathNode3.getNext();
                    continue;
                }
                if (bl) {
                    this.printLocationInfo(xPathNode3, null, stateInfo);
                    stateInfo.pw.print("- ");
                }
                if (this._returnAtFirstDiff) {
                    return 1;
                }
                ++n;
                xPathNode3 = xPathNode3.getNext();
            }
            while (xPathNode4 != null) {
                if (this._ignoreWhitespace && xPathNode4.getNodeType() == 3 && this.compareText(xPathNode4.getStringValue(), "")) {
                    xPathNode4 = xPathNode4.getNext();
                    continue;
                }
                if (bl) {
                    this.printLocationInfo(xPathNode4, null, stateInfo);
                    stateInfo.pw.print("+ ");
                }
                if (this._returnAtFirstDiff) {
                    return 1;
                }
                ++n;
                xPathNode4 = xPathNode4.getNext();
            }
        } else {
            int n3;
            XPathNode xPathNode5 = xPathNode.getFirstChild();
            XPathNode xPathNode6 = xPathNode2.getFirstChild();
            int n4 = 0;
            PrintWriter printWriter = stateInfo.pw;
            stateInfo.pw = null;
            List list = new List();
            while (xPathNode5 != null) {
                if (this._ignoreWhitespace && xPathNode5.getNodeType() == 3 && this.compareText(xPathNode5.getStringValue(), "")) {
                    xPathNode5 = xPathNode5.getNext();
                    continue;
                }
                ++n4;
                xPathNode6 = xPathNode2.getFirstChild();
                n3 = 1;
                while (xPathNode6 != null && n3 != 0) {
                    if (!list.contains(xPathNode6)) {
                        n3 = this.compare(xPathNode5, xPathNode6, stateInfo);
                        if (n3 > 0) {
                            xPathNode6 = xPathNode6.getNext();
                            continue;
                        }
                        list.add(xPathNode6);
                        continue;
                    }
                    xPathNode6 = xPathNode6.getNext();
                }
                if (n3 != 0) {
                    if (bl) {
                        stateInfo.pw = printWriter;
                        xPathNode6 = xPathNode2.getFirstChild();
                        while (xPathNode6 != null) {
                            if (!list.contains(xPathNode6) && this.hasSameType(xPathNode5, xPathNode6) && this.hasSameName(xPathNode5, xPathNode6)) {
                                n3 = this.compare(xPathNode5, xPathNode6, stateInfo);
                                break;
                            }
                            xPathNode6 = xPathNode6.getNext();
                        }
                        stateInfo.pw = null;
                    }
                    if (this._returnAtFirstDiff) {
                        return n3;
                    }
                    n += n3;
                }
                xPathNode5 = xPathNode5.getNext();
            }
            stateInfo.pw = printWriter;
            n3 = 0;
            xPathNode6 = xPathNode2.getFirstChild();
            while (xPathNode6 != null) {
                if (this._ignoreWhitespace && xPathNode6.getNodeType() == 3 && this.compareText(xPathNode6.getStringValue(), "")) {
                    xPathNode6 = xPathNode6.getNext();
                    continue;
                }
                ++n3;
                xPathNode6 = xPathNode6.getNext();
            }
            if (n4 > n3) {
                String string3 = "additional child elements are contained within element '" + string + "' of the first node.";
                if (bl) {
                    stateInfo.pw.println(string3);
                }
                if (this._returnAtFirstDiff) {
                    return 1;
                }
                n += n4 - n3;
            } else if (n3 > n4) {
                String string4 = "additional child elements are contained within element '" + string2 + "' of the second node.";
                if (stateInfo.pw != null) {
                    stateInfo.pw.println(string4);
                }
                if (this._returnAtFirstDiff) {
                    return 1;
                }
                n += n3 - n4;
            }
        }
        return n;
    }

    private boolean compareText(String string, String string2) {
        if (!string.equals(string2)) {
            if (this._ignoreWhitespace) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
                    if (stringTokenizer.nextToken().equals(stringTokenizer2.nextToken())) continue;
                    return false;
                }
                if (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static String getNodeLocation(XPathNode xPathNode) {
        Object object;
        Location location;
        if (xPathNode == null) {
            return "??";
        }
        int n = -1;
        int n2 = -1;
        String string = "XPATH: " + XMLDiff.getXPath(xPathNode);
        if (xPathNode instanceof Element && (location = (Location)((BaseNode)(object = (Element)xPathNode)).getProperty(Element.LOCATION_PROPERTY)) != null) {
            n2 = location.getLineNumber();
            n = location.getColumnNumber();
        }
        object = null;
        object = n2 >= 0 ? "[" + n2 + ", " + n + "] " + string : string;
        return object;
    }

    private static String getXPath(XPathNode xPathNode) {
        String string = "";
        if (xPathNode != null) {
            switch (xPathNode.getNodeType()) {
                case 2: {
                    string = XMLDiff.getXPath(xPathNode.getParentNode());
                    string = String.valueOf(string) + "/@" + xPathNode.getLocalName();
                    break;
                }
                case 1: {
                    boolean bl;
                    String string2 = xPathNode.getLocalName();
                    string = XMLDiff.getXPath(xPathNode.getParentNode());
                    string = String.valueOf(string) + "/" + string2;
                    int n = 1;
                    XPathNode xPathNode2 = xPathNode.getPrevious();
                    while (xPathNode2 != null) {
                        if (string2.equals(xPathNode2.getLocalName())) {
                            ++n;
                        }
                        xPathNode2 = xPathNode2.getPrevious();
                    }
                    boolean bl2 = bl = n > 1;
                    if (!bl) {
                        XPathNode xPathNode3 = xPathNode.getNext();
                        while (xPathNode3 != null) {
                            if (string2.equals(xPathNode3.getLocalName())) {
                                bl = true;
                                break;
                            }
                            xPathNode3 = xPathNode3.getNext();
                        }
                    }
                    if (!bl) break;
                    string = String.valueOf(string) + "[" + n + "]";
                    break;
                }
                case 3: {
                    string = XMLDiff.getXPath(xPathNode.getParentNode());
                    string = String.valueOf(string) + "/text()";
                    break;
                }
            }
        }
        return string;
    }

    private boolean hasSameName(XPathNode xPathNode, XPathNode xPathNode2) {
        String string = xPathNode.getLocalName();
        String string2 = xPathNode2.getLocalName();
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private boolean hasSameType(XPathNode xPathNode, XPathNode xPathNode2) {
        return xPathNode.getNodeType() == xPathNode2.getNodeType();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println();
            System.out.println(" error: missing arguments.");
            System.out.println();
            String string = (class$org$exolab$adaptx$xml$XMLDiff != null ? class$org$exolab$adaptx$xml$XMLDiff : (class$org$exolab$adaptx$xml$XMLDiff = XMLDiff.class$("org.exolab.adaptx.xml.XMLDiff"))).getName();
            System.out.println(" usage: java " + string + " filename1 filename2");
            return;
        }
        XMLDiff xMLDiff = new XMLDiff();
        try {
            int n = xMLDiff.compare(stringArray[0], stringArray[1]);
            String string = null;
            string = n == 0 ? "XMLDiff exited normally with no differences found." : "XMLDiff exited normally with " + n + " difference(s) found.";
            System.out.println();
            System.out.println(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printLocationInfo(XPathNode xPathNode, XPathNode xPathNode2, StateInfo stateInfo) {
        if (stateInfo.header) {
            stateInfo.header = false;
            stateInfo.pw.println("--- " + stateInfo.url1);
            stateInfo.pw.println("+++ " + stateInfo.url2);
        }
        stateInfo.pw.print("@@ -");
        stateInfo.pw.print(XMLDiff.getNodeLocation(xPathNode));
        stateInfo.pw.print(" +");
        stateInfo.pw.print(XMLDiff.getNodeLocation(xPathNode2));
        stateInfo.pw.println(" @@");
    }

    private static void printStartTag(XPathNode xPathNode, PrintWriter printWriter) {
        if (xPathNode.getNodeType() != 1) {
            return;
        }
        printWriter.print(String.valueOf('<') + xPathNode.getLocalName());
        XPathNode xPathNode2 = xPathNode.getFirstAttribute();
        while (xPathNode2 != null) {
            printWriter.print(' ');
            printWriter.print(xPathNode2.getLocalName());
            printWriter.print("=\"");
            printWriter.print(xPathNode2.getStringValue());
            printWriter.print("\"");
            xPathNode2 = xPathNode2.getNext();
        }
        printWriter.println('>');
    }

    private static void printText(String string, String string2, PrintWriter printWriter) {
        if (string == null) {
            if (string2 != null) {
                printWriter.println(string2);
            }
            return;
        }
        if (string2 == null) {
            printWriter.println(string);
            return;
        }
        int n = 0;
        while ((n = string2.indexOf(10)) >= 0) {
            printWriter.print(string);
            printWriter.println(string2.substring(0, n));
            string2 = string2.substring(n + 1);
        }
        printWriter.print(string);
        printWriter.println(string2);
    }

    public void setIgnoreChildOrder(boolean bl) {
        this._strictChildOrder = bl ^ true;
    }

    public void setIgnoreWhitespace(boolean bl) {
        this._ignoreWhitespace = bl;
    }

    public void setReturnOnFirstDifference(boolean bl) {
        this._returnAtFirstDiff = bl;
    }

    class StateInfo {
        PrintWriter pw = null;
        String url1 = null;
        String url2 = null;
        boolean header = false;

        StateInfo() {
        }
    }
}

