/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.adaptx.net.ObjectURILocation;
import org.exolab.adaptx.net.impl.URIUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class SAXURILocation
extends ObjectURILocation {
    private String _documentBase = null;
    private String _absoluteURI = null;
    private String _relativeURI = null;
    private XMLReader _reader;
    private InputSource _source;

    public SAXURILocation(XMLReader xMLReader, InputSource inputSource) {
        if (inputSource == null) {
            String string = "The argument 'source' must not be null.";
            throw new IllegalArgumentException(string);
        }
        this._source = inputSource;
        this._reader = xMLReader;
        this._absoluteURI = this._source.getSystemId();
    }

    public String getAbsoluteURI() {
        return this._absoluteURI;
    }

    public String getBaseURI() {
        if (this._documentBase == null && this._absoluteURI != null) {
            this._documentBase = URIUtils.getDocumentBase(this._absoluteURI);
        }
        return this._documentBase;
    }

    public InputSource getInputSource() {
        return this._source;
    }

    public Object getObject() {
        return this.getXMLReader();
    }

    public Reader getReader() throws IOException {
        if (this._reader == null) {
            Reader reader = this._source.getCharacterStream();
            if (reader != null) {
                return reader;
            }
            InputStream inputStream = this._source.getByteStream();
            if (inputStream != null) {
                return new InputStreamReader(inputStream);
            }
            if (this._absoluteURI != null) {
                return URIUtils.getReader(this._absoluteURI, null);
            }
        }
        return null;
    }

    public String getRelativeURI() {
        if (this._relativeURI == null && this._absoluteURI != null) {
            int n = this.getBaseURI().length();
            this._relativeURI = this._absoluteURI.substring(n);
        }
        return this._relativeURI;
    }

    public XMLReader getXMLReader() {
        return this._reader;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SAXURILocation at ");
        if (this.getAbsoluteURI() != null) {
            stringBuffer.append(this.getAbsoluteURI());
        } else {
            stringBuffer.append("unspecified or unknown URL");
        }
        return stringBuffer.toString();
    }
}

