/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.net.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URIUtils {
    private static final String FILE_PROTOCOL = "file";
    private static final String FILE_PROTOCOL_PREFIX = "file:///";
    private static final char HREF_PATH_SEP = '/';
    private static final char DEVICE_SEP = '|';

    private static String createFileURL(String string) {
        if (string == null) {
            return FILE_PROTOCOL_PREFIX;
        }
        int n = string.length() + FILE_PROTOCOL_PREFIX.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(FILE_PROTOCOL_PREFIX);
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            switch (c) {
                case '\\': {
                    stringBuffer.append('/');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getDocumentBase(String string) {
        int n;
        String string2;
        block4: {
            string2 = "";
            if (string == null) {
                return string2;
            }
            n = -1;
            try {
                URL uRL = new URL(string);
                uRL = null;
                n = string.lastIndexOf(47);
            }
            catch (MalformedURLException malformedURLException) {
                int n2 = string.lastIndexOf(47);
                n = string.lastIndexOf(File.separator);
                if (n2 <= n) break block4;
                n = n2;
            }
        }
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static InputStream getInputStream(String string, String string2) throws FileNotFoundException, IOException {
        URL uRL = null;
        uRL = URIUtils.getURL(string);
        if (uRL != null) {
            return uRL.openStream();
        }
        String string3 = URIUtils.makeAbsolute(string, string2);
        uRL = URIUtils.getURL(string3);
        if (uRL != null) {
            return uRL.openStream();
        }
        File file = new File(string);
        if (file.exists()) {
            File file2;
            if (!file.isAbsolute() && (file2 = new File(string3)).exists()) {
                file = file2;
            }
        } else {
            file = new File(string3);
        }
        return new FileInputStream(file);
    }

    public static OutputStream getOutputStream(String string, String string2) throws FileNotFoundException, IOException {
        File file;
        Object object;
        URL uRL = null;
        uRL = URIUtils.getURL(string);
        if (uRL != null) {
            if (FILE_PROTOCOL.equals(uRL.getProtocol())) {
                object = new File(uRL.getFile());
                if (((File)object).exists()) {
                    return new FileOutputStream((File)object);
                }
            } else {
                URLConnection uRLConnection = uRL.openConnection();
                return uRLConnection.getOutputStream();
            }
        }
        if ((uRL = URIUtils.getURL((String)(object = URIUtils.makeAbsolute(string, string2)))) != null) {
            if (FILE_PROTOCOL.equals(uRL.getProtocol())) {
                file = new File(uRL.getFile());
                if (file.exists()) {
                    return new FileOutputStream(file);
                }
            } else {
                URLConnection uRLConnection = uRL.openConnection();
                return uRLConnection.getOutputStream();
            }
        }
        if ((file = new File(string)).exists()) {
            File file2;
            if (!file.isAbsolute() && (file2 = new File((String)object)).exists()) {
                file = file2;
            }
        } else {
            file = new File((String)object);
        }
        return new FileOutputStream(file);
    }

    public static Reader getReader(String string, String string2) throws FileNotFoundException, IOException {
        InputStream inputStream = URIUtils.getInputStream(string, string2);
        return new InputStreamReader(inputStream);
    }

    public static String getRelativeURI(String string) {
        int n;
        block4: {
            if (string == null) {
                return string;
            }
            n = -1;
            try {
                URL uRL = new URL(string);
                uRL = null;
                n = string.lastIndexOf(47);
            }
            catch (MalformedURLException malformedURLException) {
                int n2 = string.lastIndexOf(47);
                n = string.lastIndexOf(File.separator);
                if (n2 <= n) break block4;
                n = n2;
            }
        }
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private static URL getURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Writer getWriter(String string, String string2) throws FileNotFoundException, IOException {
        OutputStream outputStream = URIUtils.getOutputStream(string, string2);
        return new OutputStreamWriter(outputStream);
    }

    private static String makeAbsolute(String string, String string2) {
        String string3 = null;
        if (string2 != null && string2.length() > 0) {
            if (string.startsWith(string2)) {
                return string;
            }
            int n = string2.lastIndexOf(47);
            string3 = n == string2.length() - 1 ? String.valueOf(string2) + string : String.valueOf(string2) + '/' + string;
        } else {
            string3 = string;
        }
        return string3;
    }

    public static String resolveAsString(String string, String string2) {
        if (URIUtils.getURL(string) != null) {
            return string;
        }
        String string3 = URIUtils.makeAbsolute(string, string2);
        if (URIUtils.getURL(string3) != null) {
            return string3;
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            string3 = URIUtils.createFileURL(file.getAbsolutePath());
        } else {
            file = new File(string3);
            string3 = URIUtils.createFileURL(file.getAbsolutePath());
        }
        return string3;
    }
}

