/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.jaxp.transform;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.exolab.adaptx.net.URIException;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.net.impl.URILocationImpl;
import org.exolab.adaptx.xml.DOMURILocation;
import org.exolab.adaptx.xml.SAXURILocation;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class URIResolverWrapper
implements org.exolab.adaptx.net.URIResolver {
    private URIResolver _resolver = null;

    public URIResolverWrapper(URIResolver uRIResolver) {
        this._resolver = uRIResolver;
    }

    public URIResolver getResolver() {
        return this._resolver;
    }

    public URILocation resolve(String string, String string2) throws URIException {
        Source source = null;
        try {
            source = this._resolver.resolve(string, string2);
        }
        catch (TransformerException transformerException) {
            throw new URIException(transformerException);
        }
        if (source != null) {
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                Reader reader = streamSource.getReader();
                if (reader != null) {
                    return new URILocationImpl(reader, streamSource.getSystemId());
                }
                InputStream inputStream = streamSource.getInputStream();
                if (inputStream != null) {
                    return new URILocationImpl(inputStream, streamSource.getSystemId());
                }
                return new URILocationImpl(streamSource.getSystemId(), string2);
            }
            if (source instanceof DOMSource) {
                DOMSource dOMSource = (DOMSource)source;
                return new DOMURILocation(dOMSource.getNode(), dOMSource.getSystemId());
            }
            if (source instanceof SAXSource) {
                SAXSource sAXSource = (SAXSource)source;
                XMLReader xMLReader = sAXSource.getXMLReader();
                InputSource inputSource = sAXSource.getInputSource();
                return new SAXURILocation(xMLReader, inputSource);
            }
            String string3 = "Error: unsupported javax.xml.transform.Source implementation encountered; ";
            throw new URIException(String.valueOf(string3) + source.getClass().getName());
        }
        return new URILocationImpl(string, string2);
    }
}

