/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.jaxp.transform;

import java.io.IOException;
import java.util.Hashtable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.exolab.adaptx.jaxp.transform.IdentityTransformer;
import org.exolab.adaptx.jaxp.transform.TemplatesImpl;
import org.exolab.adaptx.jaxp.transform.URIResolverWrapper;
import org.exolab.adaptx.jaxp.transform.sax.TemplatesHandlerImpl;
import org.exolab.adaptx.jaxp.transform.sax.TransformerHandlerImpl;
import org.exolab.adaptx.xslt.XSLException;
import org.exolab.adaptx.xslt.XSLTReader;
import org.exolab.adaptx.xslt.XSLTStylesheet;
import org.exolab.adaptx.xslt.util.StylesheetHandler;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private ErrorListener _errorListener = null;
    private URIResolverWrapper _uriResolver = null;
    private Hashtable _attributes = null;
    public static final String[] SUPPORTED_FEATURES = new String[]{"http://javax.xml.transform.dom.DOMResult/feature", "http://javax.xml.transform.dom.DOMSource/feature", "http://javax.xml.transform.stream.StreamResult/feature", "http://javax.xml.transform.stream.StreamSource/feature", "http://javax.xml.transform.sax.SAXResult/feature", "http://javax.xml.transform.sax.SAXSource/feature", "http://javax.xml.transform.sax.SAXTransformerFactory/feature"};

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        String string4 = "TransfomerFactory#getAssociatedStylesheet is not supported.";
        throw new TransformerConfigurationException(string4);
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (this._attributes == null) {
            return null;
        }
        return (String)this._attributes.get(string);
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    public boolean getFeature(String string) {
        int n = 0;
        while (n < SUPPORTED_FEATURES.length) {
            if (SUPPORTED_FEATURES[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public URIResolver getURIResolver() {
        if (this._uriResolver != null) {
            return this._uriResolver.getResolver();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        XSLTReader xSLTReader = null;
        xSLTReader = this._uriResolver != null ? new XSLTReader(this._uriResolver) : new XSLTReader();
        XSLTStylesheet xSLTStylesheet = null;
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            InputSource inputSource = ((SAXSource)source).getInputSource();
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (xMLReader != null) {
                StylesheetHandler stylesheetHandler = new StylesheetHandler();
                xMLReader.setContentHandler(stylesheetHandler);
                try {
                    xMLReader.parse(inputSource);
                }
                catch (IOException iOException) {
                    throw new TransformerConfigurationException(iOException);
                }
                catch (SAXException sAXException) {
                    throw new TransformerConfigurationException(sAXException);
                }
                xSLTStylesheet = stylesheetHandler.getStylesheet();
                return new TemplatesImpl(xSLTStylesheet);
            }
            try {
                xSLTStylesheet = xSLTReader.read(inputSource);
                return new TemplatesImpl(xSLTStylesheet);
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException(iOException);
            }
            catch (XSLException xSLException) {
                throw new TransformerConfigurationException(xSLException);
            }
        }
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            try {
                xSLTStylesheet = xSLTReader.read(node, source.getSystemId());
                return new TemplatesImpl(xSLTStylesheet);
            }
            catch (XSLException xSLException) {
                throw new TransformerConfigurationException(xSLException);
            }
        } else if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            try {
                InputSource inputSource = new InputSource(streamSource.getSystemId());
                inputSource.setPublicId(streamSource.getPublicId());
                if (streamSource.getInputStream() != null) {
                    inputSource.setByteStream(streamSource.getInputStream());
                } else if (streamSource.getReader() != null) {
                    inputSource.setCharacterStream(streamSource.getReader());
                }
                xSLTStylesheet = xSLTReader.read(inputSource);
                return new TemplatesImpl(xSLTStylesheet);
            }
            catch (XSLException xSLException) {
                throw new TransformerConfigurationException(xSLException);
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException(iOException);
            }
        } else {
            String string = "Source instances of type: " + source.getClass().getName() + " are not supported.";
            throw new TransformerConfigurationException(string);
        }
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new IdentityTransformer();
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        if (source == null) {
            return this.newTransformer();
        }
        return this.newTemplates(source).newTransformer();
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return new TransformerHandlerImpl();
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        return this.newTransformerHandler(this.newTemplates(source));
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        return new TransformerHandlerImpl(((TemplatesImpl)templates).getStylesheet());
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        return this.newXMLFilter(this.newTemplates(source));
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        TransformerHandler transformerHandler = this.newTransformerHandler(templates);
        XMLFilterImpl xMLFilterImpl = new XMLFilterImpl();
        xMLFilterImpl.setContentHandler(transformerHandler);
        return xMLFilterImpl;
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (this._attributes == null) {
            this._attributes = new Hashtable();
        }
        this._attributes.put(string, object);
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException("ErrorListener is null");
        }
        this._errorListener = errorListener;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        if (uRIResolver == null) {
            this._uriResolver = null;
        }
        this._uriResolver = new URIResolverWrapper(uRIResolver);
    }
}

