/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.jaxp.transform;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.exolab.adaptx.net.impl.URIUtils;
import org.exolab.adaptx.xml.DOM2SAX;
import org.exolab.adaptx.xml.parser.DOMParser;
import org.exolab.adaptx.xslt.ResultHandler;
import org.exolab.adaptx.xslt.handlers.DOMBuilder;
import org.exolab.adaptx.xslt.handlers.DefaultHandler;
import org.exolab.adaptx.xslt.handlers.ResultHandlerAdapter2;
import org.exolab.adaptx.xslt.util.Configuration;
import org.exolab.adaptx.xslt.util.SAX2ResultHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class IdentityTransformer
extends Transformer {
    private URIResolver _uriResolver = null;
    private ErrorListener _errorListener = null;
    private Properties _outputProperties = null;
    private Hashtable _params = null;

    public void clearParameters() {
        if (this._params != null) {
            this._params.clear();
        }
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    public Properties getOutputProperties() {
        if (this._outputProperties == null) {
            return new Properties();
        }
        return new Properties(this._outputProperties);
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        if (this._outputProperties == null) {
            return null;
        }
        return this._outputProperties.getProperty(string);
    }

    public Object getParameter(String string) {
        if (this._params == null || string == null) {
            return null;
        }
        return this._params.get(string);
    }

    public static final ResultHandler getResultHandler(Result result) throws TransformerException {
        ResultHandler resultHandler = null;
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            Writer writer = null;
            if (streamResult.getOutputStream() != null) {
                writer = new OutputStreamWriter(streamResult.getOutputStream());
            } else if (streamResult.getWriter() != null) {
                writer = streamResult.getWriter();
            } else if (streamResult.getSystemId() != null) {
                try {
                    writer = URIUtils.getWriter(streamResult.getSystemId(), null);
                }
                catch (IOException iOException) {
                    throw new TransformerException(iOException);
                }
            } else {
                String string = "Invalid StreamResult, missing Writer, or OutputStream.";
                throw new TransformerException(string);
            }
            resultHandler = new DefaultHandler(writer);
        } else if (result instanceof DOMResult) {
            DOMResult dOMResult = (DOMResult)result;
            Node node = dOMResult.getNode();
            if (node == null) {
                DOMParser dOMParser = Configuration.getDOMParser();
                Document document = dOMParser.createDocument();
                dOMResult.setNode(document);
                resultHandler = new DOMBuilder(document);
            } else {
                resultHandler = new DOMBuilder(node);
            }
        } else if (result instanceof SAXResult) {
            resultHandler = new ResultHandlerAdapter2(((SAXResult)result).getHandler());
        } else {
            String string = "The Result of type '" + result.getClass().getName();
            string = String.valueOf(string) + "' is not supported by this Transformer.";
            throw new TransformerException(string);
        }
        return resultHandler;
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this._errorListener = errorListener;
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (properties == null) {
            this._outputProperties = null;
        } else {
            this._outputProperties = new Properties();
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                this._outputProperties.setProperty(string, string2);
            }
        }
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        if (this._outputProperties == null) {
            this._outputProperties = new Properties();
        }
        this._outputProperties.setProperty(string, string2);
    }

    public void setParameter(String string, Object object) {
        if (string == null) {
            return;
        }
        if (this._params == null) {
            if (object == null) {
                return;
            }
            this._params = new Hashtable();
        }
        if (object == null) {
            this._params.remove(string);
        } else {
            this._params.put(string, object);
        }
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver;
    }

    public void transform(Source source, Result result) throws TransformerException {
        ResultHandler resultHandler = IdentityTransformer.getResultHandler(result);
        if (source instanceof DOMSource) {
            Object object;
            DOMSource dOMSource = (DOMSource)source;
            Node node = dOMSource.getNode();
            boolean bl = false;
            if (node == null) {
                object = Configuration.getDOMParser();
                Document document = object.createDocument();
                node = document;
            }
            switch (node.getNodeType()) {
                case 1: 
                case 9: {
                    try {
                        object = new DOM2SAX();
                        DOM2SAX.process(node, (DocumentHandler)resultHandler);
                        break;
                    }
                    catch (SAXException sAXException) {
                        throw new TransformerException(sAXException);
                    }
                }
                default: {
                    object = "Invalid node type. Only Document and Element nodes are supported as input to a trasformation.";
                    throw new TransformerException((String)object);
                }
            }
            if (bl) {
                dOMSource.setNode(node);
            }
        } else {
            Source source2;
            InputSource inputSource = null;
            XMLReader xMLReader = null;
            if (source instanceof StreamSource) {
                source2 = (StreamSource)source;
                String string = ((StreamSource)source2).getSystemId();
                if (string == null) {
                    string = ((StreamSource)source2).getPublicId();
                }
                inputSource = ((StreamSource)source2).getInputStream() != null ? new InputSource(((StreamSource)source2).getInputStream()) : (((StreamSource)source2).getReader() != null ? new InputSource(((StreamSource)source2).getReader()) : new InputSource(string));
            } else if (source instanceof SAXSource) {
                source2 = (SAXSource)source;
                inputSource = ((SAXSource)source2).getInputSource();
                xMLReader = ((SAXSource)source2).getXMLReader();
                if (inputSource == null) {
                    return;
                }
            } else {
                String string = "The Source of type '" + source.getClass().getName();
                string = String.valueOf(string) + "' is not supported by this Transformer.";
                throw new TransformerException(string);
            }
            if (xMLReader == null) {
                xMLReader = Configuration.getXMLReader();
            }
            try {
                if (resultHandler instanceof ContentHandler) {
                    xMLReader.setContentHandler((ContentHandler)((Object)resultHandler));
                } else {
                    xMLReader.setContentHandler(new SAX2ResultHandler(resultHandler));
                }
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        }
    }
}

