/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.interceptor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.mockejb.interceptor.Interceptor;

public class ObjectInvoker
implements Serializable {
    private transient ListIterator iter;
    private Map context = new HashMap();
    private List interceptorList;

    public ObjectInvoker(List interceptorList) {
        this.setInterceptorList(interceptorList);
    }

    public void setInterceptorList(List interceptorList) {
        this.verifyInterceptors(interceptorList);
        this.interceptorList = interceptorList;
        this.reset();
    }

    public List getInterceptorList() {
        return this.interceptorList;
    }

    public ListIterator getInterceptorIterator() {
        return this.iter;
    }

    private void verifyInterceptors(List interceptorList) {
        if (interceptorList == null) {
            throw new IllegalArgumentException("Interceptor list can't be null");
        }
        Iterator i = interceptorList.iterator();
        while (i.hasNext()) {
            Object interceptor = i.next();
            if (interceptor instanceof Interceptor) continue;
            throw new IllegalArgumentException("Object " + interceptor + " in the interceptor list does not implement interceptor interface");
        }
    }

    public void reset() {
        this.iter = this.interceptorList.listIterator();
    }

    public void clear() {
        this.reset();
        this.context.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object targetObj, Method method, Object[] paramVals) throws Exception {
        Object returnObj;
        block7: {
            returnObj = null;
            if (!this.iter.hasPrevious()) {
                this.reset();
            }
            if (this.iter.hasNext()) {
                Interceptor nextInterceptor = (Interceptor)this.iter.next();
                try {
                    returnObj = nextInterceptor.intercept(this, targetObj, method, paramVals);
                    Object var7_7 = null;
                    this.iter.previous();
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.iter.previous();
                    throw throwable;
                }
                {
                    break block7;
                }
            }
            try {
                returnObj = this.invokeMethod(targetObj, method, paramVals);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (!(throwable instanceof Exception)) break block7;
                throw (Exception)throwable;
            }
        }
        return returnObj;
    }

    public void setInvocationContext(String key, Object data) {
        this.context.put(key, data);
    }

    public Object getInvocationContext(String key) {
        return this.context.get(key);
    }

    protected Object invokeMethod(Object targetObj, Method method, Object[] paramVals) throws Throwable {
        Object returnObj;
        try {
            returnObj = method.invoke(targetObj, paramVals);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        return returnObj;
    }
}

