/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb;

import java.lang.reflect.Method;
import java.util.LinkedList;
import javax.ejb.EnterpriseBean;
import org.mockejb.ExceptionHandler;
import org.mockejb.MockEjbSystemException;
import org.mockejb.interceptor.ObjectInvoker;

class StandardEjbMethodInvoker
extends ExceptionHandler {
    ObjectInvoker objectInvoker = new ObjectInvoker(new LinkedList());

    StandardEjbMethodInvoker(Class ifaceClass) {
        super(ifaceClass);
    }

    Object invokeStandardMethod(EnterpriseBean bean, String methodName, Class[] paramTypes, Object[] paramVals) throws Exception {
        Method method;
        try {
            method = bean.getClass().getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException noSuchMethodEx) {
            throw new MockEjbSystemException("EJB " + bean.getClass().getName() + " does not implement method " + methodName, noSuchMethodEx);
        }
        return this.intercept(this.objectInvoker, bean, method, paramVals);
    }

    Object invokeStandardMethod(EnterpriseBean bean, String methodName) throws Exception {
        Class[] paramTypes = new Class[]{};
        Object[] args = new Object[]{};
        return this.invokeStandardMethod(bean, methodName, paramTypes, args);
    }

    void invokeCreate(EnterpriseBean bean, String createMethodName, Class[] paramTypes, Object[] args) throws Exception {
        String methodName = "ejbC" + createMethodName.substring(1);
        this.invokeStandardMethod(bean, methodName, paramTypes, args);
    }

    EnterpriseBean invokeNewInstance(Class beanClass) {
        EnterpriseBean bean = null;
        try {
            bean = (EnterpriseBean)beanClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new MockEjbSystemException("Error instantiating a bean " + beanClass.getName(), iae);
        }
        catch (InstantiationException ie) {
            throw new MockEjbSystemException("Error instantiating a bean " + beanClass.getName(), ie);
        }
        return bean;
    }
}

