/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EnterpriseBean;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import org.mockejb.ExceptionHandler;
import org.mockejb.MethodContainer;
import org.mockejb.MethodNotImplementedException;
import org.mockejb.MockEjbContext;
import org.mockejb.TransactionManager;
import org.mockejb.TransactionPolicy;
import org.mockejb.interceptor.Interceptor;
import org.mockejb.interceptor.ObjectInvoker;

public class MockEjbObject
implements InvocationHandler,
EnterpriseBean,
Serializable {
    private List interceptorList = new LinkedList();
    private ObjectInvoker objectInvoker = new ObjectInvoker(this.interceptorList);
    private TransactionManager transactionInvoker;
    private Object homeImpl;
    private Object homeProxy;
    private Class ifaceClass;
    private EnterpriseBean bean;
    private Object proxy;
    private static MethodContainer standardMethods = new MethodContainer(class$org$mockejb$MockEjbObject == null ? (class$org$mockejb$MockEjbObject = MockEjbObject.class$("org.mockejb.MockEjbObject")) : class$org$mockejb$MockEjbObject);
    static /* synthetic */ Class class$org$mockejb$MockEjbObject;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$mockejb$MockEjbContext;

    MockEjbObject(Class ifaceClass) {
        this.ifaceClass = ifaceClass;
        this.interceptorList.add(new ExceptionHandler(ifaceClass));
        this.transactionInvoker = new TransactionManager();
        this.interceptorList.add(this.transactionInvoker);
    }

    void setHomeImpl(Object homeImpl) {
        this.homeImpl = homeImpl;
    }

    void setHomeProxy(Object homeProxy) {
        this.homeProxy = homeProxy;
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptorList.add(interceptor);
    }

    public List getInterceptorList() {
        return this.interceptorList;
    }

    public void setInterceptorList(List interceptorList) {
        interceptorList.clear();
        interceptorList.add(interceptorList);
    }

    public void setTransactionPolicy(TransactionPolicy policy) {
        this.transactionInvoker.setPolicy(policy);
    }

    Object createProxy(EnterpriseBean bean, MockEjbContext ejbContext) {
        this.bean = bean;
        this.proxy = Proxy.newProxyInstance(this.ifaceClass.getClassLoader(), new Class[]{this.ifaceClass}, (InvocationHandler)this);
        ejbContext.setEjbObjectProxy(this.proxy);
        this.objectInvoker.setInvocationContext((class$org$mockejb$MockEjbContext == null ? (class$org$mockejb$MockEjbContext = MockEjbObject.class$("org.mockejb.MockEjbContext")) : class$org$mockejb$MockEjbContext).getName(), ejbContext);
        return this.proxy;
    }

    public Object invoke(Object proxy, Method ifaceMethod, Object[] paramVals) throws Throwable {
        Method beanMethod = null;
        Object returnValue = null;
        MockEjbObject beanToInvoke = null;
        beanMethod = standardMethods.find(ifaceMethod);
        if (beanMethod != null) {
            beanToInvoke = this;
        } else {
            beanToInvoke = this.bean;
            beanMethod = this.bean.getClass().getMethod(ifaceMethod.getName(), ifaceMethod.getParameterTypes());
        }
        returnValue = this.objectInvoker.invoke(beanToInvoke, beanMethod, paramVals);
        return returnValue;
    }

    Object getHomeImpl() {
        return this.homeImpl;
    }

    public MockEjbContext getEjbContext() {
        if (this.objectInvoker.getInvocationContext((class$org$mockejb$MockEjbContext == null ? (class$org$mockejb$MockEjbContext = MockEjbObject.class$("org.mockejb.MockEjbContext")) : class$org$mockejb$MockEjbContext).getName()) == null) {
            throw new IllegalStateException("Context does not exist. Most likely this EJB has not been created yet");
        }
        return (MockEjbContext)this.objectInvoker.getInvocationContext((class$org$mockejb$MockEjbContext == null ? (class$org$mockejb$MockEjbContext = MockEjbObject.class$("org.mockejb.MockEjbContext")) : class$org$mockejb$MockEjbContext).getName());
    }

    public EJBHome getEJBHome() {
        if (this.homeProxy == null) {
            throw new IllegalStateException("Attempt to request a home for the Bean that does not have one, such as MDB");
        }
        return (EJBHome)this.homeProxy;
    }

    public EJBLocalHome getEJBLocalHome() {
        if (this.homeProxy == null) {
            throw new IllegalStateException("Attempt to request a home for the Bean that does not have one, such as MDB");
        }
        return (EJBLocalHome)this.homeProxy;
    }

    public Handle getHandle() throws RemoteException {
        this.throwMethodNotImplemented("getHandle");
        return null;
    }

    public Object getPrimaryKey() {
        throw new EJBException("Attempt to invoke 'getPrimaryKey' for a session bean");
    }

    public void remove() throws RemoveException {
    }

    public boolean isIdentical(Object object) {
        return this.equals(object);
    }

    public boolean equals(Object obj) {
        if (this.ifaceClass.isInstance(obj)) {
            return this.proxy == obj;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "EJB object:  BusinessIface: " + this.ifaceClass.getName() + "\nBean: " + this.bean.getClass().getName();
    }

    private void throwMethodNotImplemented(String methodName) {
        throw new MethodNotImplementedException(methodName, this.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        standardMethods.add("getEJBHome");
        standardMethods.add("getEJBLocalHome");
        standardMethods.add("getHandle");
        standardMethods.add("getPrimaryKey");
        standardMethods.add("remove");
        Class[] objectArg = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = MockEjbObject.class$("java.lang.Object")) : class$java$lang$Object};
        standardMethods.add("isIdentical", objectArg);
        standardMethods.add("equals", objectArg);
        standardMethods.add("hashCode");
        standardMethods.add("toString");
    }
}

