/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;

public class IDDatatypeValidator
extends StringDatatypeValidator {
    private static StringDatatypeValidator fgStrValidator = null;
    private static Object fNullValue = null;
    protected static Hashtable fTableOfId = null;
    public static final int IDREF_STORE = 0;
    public static final int ID_CLEAR = 1;

    public IDDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
        Cloneable cloneable;
        if (bl) {
            return;
        }
        if (fgStrValidator == null) {
            cloneable = new Hashtable<String, String>();
            ((Hashtable)cloneable).put("whiteSpace", "collapse");
            ((Hashtable)cloneable).put("pattern", "[\\i-[:]][\\c-[:]]*");
            fgStrValidator = new StringDatatypeValidator(null, (Hashtable)cloneable, false);
        }
        cloneable = null;
        if (hashtable != null) {
            cloneable = (Vector)hashtable.get("enumeration");
        }
        if (cloneable != null) {
            int n = 0;
            try {
                while (n < ((Vector)cloneable).size()) {
                    fgStrValidator.validate((String)((Vector)cloneable).elementAt(n), null);
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new InvalidDatatypeFacetException("Value of enumeration = '" + ((Vector)cloneable).elementAt(n) + "' must be from the value space of base.");
            }
        }
    }

    private boolean addId(String string, Object object) {
        if (fTableOfId == null) {
            fTableOfId = new Hashtable();
        } else if (fTableOfId.containsKey(string)) {
            return false;
        }
        if (fNullValue == null) {
            fNullValue = new Object();
        }
        try {
            fTableOfId.put(string, fNullValue);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Out of Memory: Hashtable of ID's has " + fTableOfId.size() + " Elements");
            outOfMemoryError.printStackTrace();
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public short getWSFacet() {
        return fgStrValidator.getWSFacet();
    }

    protected void resetIDs() {
        if (fTableOfId != null) {
            fTableOfId.clear();
            fTableOfId = null;
        }
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        Object object2;
        if (object != null && (object2 = (StateMessageDatatype)object).getDatatypeState() == 1) {
            if (fTableOfId != null) {
                fTableOfId.clear();
                fTableOfId = null;
            }
            return null;
        }
        super.validate(string, object);
        try {
            fgStrValidator.validate(string, null);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            object2 = new InvalidDatatypeValueException("ID is not valid: " + string);
            ((InvalidDatatypeValueException)object2).setMinorCode(75);
            ((InvalidDatatypeValueException)object2).setMajorCode(76);
            throw object2;
        }
        if (!this.addId(string, object)) {
            object2 = new InvalidDatatypeValueException("ID '" + string + "'  has to be unique");
            ((InvalidDatatypeValueException)object2).setMinorCode(76);
            ((InvalidDatatypeValueException)object2).setMajorCode(76);
            throw object2;
        }
        return fTableOfId;
    }
}

