// Generated by Cap'n Proto compiler, DO NOT EDIT
// source: schema.capnp

#ifndef CAPNP_INCLUDED_b471df2f45ca32c7_
#define CAPNP_INCLUDED_b471df2f45ca32c7_

#include <capnp/generated-header-support.h>

namespace capnp {
namespace schema {

struct Node {
  Node() = delete;

  class Reader;
  class Builder;
  struct Body;
  struct NestedNode;
};

struct Node::Body {
  Body() = delete;
  class Reader;
  class Builder;

  enum Which: uint16_t {
    FILE_NODE,
    STRUCT_NODE,
    ENUM_NODE,
    INTERFACE_NODE,
    CONST_NODE,
    ANNOTATION_NODE,
  };
};

struct Node::NestedNode {
  NestedNode() = delete;

  class Reader;
  class Builder;
};

struct Type {
  Type() = delete;

  class Reader;
  class Builder;
  struct Body;
};

struct Type::Body {
  Body() = delete;
  class Reader;
  class Builder;

  enum Which: uint16_t {
    VOID_TYPE,
    BOOL_TYPE,
    INT8_TYPE,
    INT16_TYPE,
    INT32_TYPE,
    INT64_TYPE,
    UINT8_TYPE,
    UINT16_TYPE,
    UINT32_TYPE,
    UINT64_TYPE,
    FLOAT32_TYPE,
    FLOAT64_TYPE,
    TEXT_TYPE,
    DATA_TYPE,
    LIST_TYPE,
    ENUM_TYPE,
    STRUCT_TYPE,
    INTERFACE_TYPE,
    OBJECT_TYPE,
  };
};

struct Value {
  Value() = delete;

  class Reader;
  class Builder;
  struct Body;
};

struct Value::Body {
  Body() = delete;
  class Reader;
  class Builder;

  enum Which: uint16_t {
    UINT64_VALUE,
    BOOL_VALUE,
    INT8_VALUE,
    INT16_VALUE,
    INT32_VALUE,
    INT64_VALUE,
    UINT8_VALUE,
    UINT16_VALUE,
    UINT32_VALUE,
    VOID_VALUE,
    FLOAT32_VALUE,
    FLOAT64_VALUE,
    TEXT_VALUE,
    DATA_VALUE,
    LIST_VALUE,
    ENUM_VALUE,
    STRUCT_VALUE,
    INTERFACE_VALUE,
    OBJECT_VALUE,
  };
};

struct Annotation {
  Annotation() = delete;

  class Reader;
  class Builder;
};

struct FileNode {
  FileNode() = delete;

  class Reader;
  class Builder;
  struct Import;
};

struct FileNode::Import {
  Import() = delete;

  class Reader;
  class Builder;
};

enum class ElementSize: uint16_t {
  EMPTY,
  BIT,
  BYTE,
  TWO_BYTES,
  FOUR_BYTES,
  EIGHT_BYTES,
  POINTER,
  INLINE_COMPOSITE,
};

struct StructNode {
  StructNode() = delete;

  class Reader;
  class Builder;
  struct Member;
  struct Field;
  struct Union;
  struct Group;
};

struct StructNode::Member {
  Member() = delete;

  class Reader;
  class Builder;
  struct Body;
};

struct StructNode::Member::Body {
  Body() = delete;
  class Reader;
  class Builder;

  enum Which: uint16_t {
    FIELD_MEMBER,
    UNION_MEMBER,
    GROUP_MEMBER,
  };
};

struct StructNode::Field {
  Field() = delete;

  class Reader;
  class Builder;
};

struct StructNode::Union {
  Union() = delete;

  class Reader;
  class Builder;
};

struct StructNode::Group {
  Group() = delete;

  class Reader;
  class Builder;
};

struct EnumNode {
  EnumNode() = delete;

  class Reader;
  class Builder;
  struct Enumerant;
};

struct EnumNode::Enumerant {
  Enumerant() = delete;

  class Reader;
  class Builder;
};

struct InterfaceNode {
  InterfaceNode() = delete;

  class Reader;
  class Builder;
  struct Method;
};

struct InterfaceNode::Method {
  Method() = delete;

  class Reader;
  class Builder;
  struct Param;
};

struct InterfaceNode::Method::Param {
  Param() = delete;

  class Reader;
  class Builder;
};

struct ConstNode {
  ConstNode() = delete;

  class Reader;
  class Builder;
};

struct AnnotationNode {
  AnnotationNode() = delete;

  class Reader;
  class Builder;
};

struct CodeGeneratorRequest {
  CodeGeneratorRequest() = delete;

  class Reader;
  class Builder;
};

}  // namespace
}  // namespace

// =======================================================================================

namespace capnp {
namespace schemas {

extern const ::capnp::_::RawSchema s_96ae9bbee664c195;
extern const ::capnp::_::RawSchema s_adfe8e889429ee28;
extern const ::capnp::_::RawSchema s_dddca9a9ee299e42;
extern const ::capnp::_::RawSchema s_c2c768aee22269ee;
extern const ::capnp::_::RawSchema s_db785131c0cfee73;
extern const ::capnp::_::RawSchema s_d59c380b31b76b1f;
extern const ::capnp::_::RawSchema s_d5d6a9044d63c158;
extern const ::capnp::_::RawSchema s_d7326bd22e1c298c;
extern const ::capnp::_::RawSchema s_bf81d92a0b7e0c1f;
extern const ::capnp::_::RawSchema s_9a2db4bd6b74f8c1;
extern const ::capnp::_::RawSchema s_c75846e17057a41f;
extern const ::capnp::_::RawSchema s_efff479ae161da06;
extern const ::capnp::_::RawSchema s_ac91947f51b055ed;
extern const ::capnp::_::RawSchema s_d612f44d78962abf;
extern const ::capnp::_::RawSchema s_c9ac441973b9f177;
extern const ::capnp::_::RawSchema s_b8a6ecfa2d5121e6;
extern const ::capnp::_::RawSchema s_bdd7f6f0832387ac;
extern const ::capnp::_::RawSchema s_d6d38cf4e366e91c;
extern const ::capnp::_::RawSchema s_8f0cf892b24a8062;
extern const ::capnp::_::RawSchema s_f386f41ae9f5cbe5;
extern const ::capnp::_::RawSchema s_d095654a26e15f1d;

}  // namespace schemas
namespace _ {  // private

CAPNP_DECLARE_STRUCT(
    ::capnp::schema::Node, 96ae9bbee664c195,
    3, 4, INLINE_COMPOSITE);
CAPNP_DECLARE_UNION(
    ::capnp::schema::Node::Body,
    ::capnp::schema::Node, 5);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::Node::NestedNode, adfe8e889429ee28,
    1, 1, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::Type, dddca9a9ee299e42,
    2, 1, INLINE_COMPOSITE);
CAPNP_DECLARE_UNION(
    ::capnp::schema::Type::Body,
    ::capnp::schema::Type, 0);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::Value, c2c768aee22269ee,
    2, 1, INLINE_COMPOSITE);
CAPNP_DECLARE_UNION(
    ::capnp::schema::Value::Body,
    ::capnp::schema::Value, 0);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::Annotation, db785131c0cfee73,
    1, 1, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::FileNode, d59c380b31b76b1f,
    0, 1, POINTER);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::FileNode::Import, d5d6a9044d63c158,
    1, 1, INLINE_COMPOSITE);
CAPNP_DECLARE_ENUM(
    ::capnp::schema::ElementSize, d7326bd22e1c298c);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::StructNode, bf81d92a0b7e0c1f,
    1, 1, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::StructNode::Member, 9a2db4bd6b74f8c1,
    1, 3, INLINE_COMPOSITE);
CAPNP_DECLARE_UNION(
    ::capnp::schema::StructNode::Member::Body,
    ::capnp::schema::StructNode::Member, 4);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::StructNode::Field, c75846e17057a41f,
    1, 2, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::StructNode::Union, efff479ae161da06,
    1, 1, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::StructNode::Group, ac91947f51b055ed,
    0, 1, POINTER);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::EnumNode, d612f44d78962abf,
    0, 1, POINTER);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::EnumNode::Enumerant, c9ac441973b9f177,
    1, 2, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::InterfaceNode, b8a6ecfa2d5121e6,
    0, 1, POINTER);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::InterfaceNode::Method, bdd7f6f0832387ac,
    1, 4, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::InterfaceNode::Method::Param, d6d38cf4e366e91c,
    0, 4, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::ConstNode, 8f0cf892b24a8062,
    0, 2, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::AnnotationNode, f386f41ae9f5cbe5,
    1, 1, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::schema::CodeGeneratorRequest, d095654a26e15f1d,
    0, 2, INLINE_COMPOSITE);

}  // namespace _ (private)
}  // namespace capnp

// =======================================================================================

namespace capnp {
namespace schema {

class Node::Reader {
public:
  typedef Node Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline  ::uint64_t getId() const;

  inline bool hasDisplayName() const;
  inline  ::capnp::Text::Reader getDisplayName() const;

  inline  ::uint64_t getScopeId() const;

  inline bool hasNestedNodes() const;
  inline  ::capnp::List< ::capnp::schema::Node::NestedNode>::Reader getNestedNodes() const;

  inline bool hasAnnotations() const;
  inline  ::capnp::List< ::capnp::schema::Annotation>::Reader getAnnotations() const;

inline Body::Reader getBody() const;
  inline  ::uint32_t getDisplayNamePrefixLength() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Node::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Node::Reader reader) {
  return ::capnp::_::structString<Node>(reader._reader);
}

class Node::Builder {
public:
  typedef Node Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline  ::uint64_t getId();
  inline void setId( ::uint64_t value);

  inline bool hasDisplayName();
  inline  ::capnp::Text::Builder getDisplayName();
  inline void setDisplayName( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initDisplayName(unsigned int size);
  inline void adoptDisplayName(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownDisplayName();

  inline  ::uint64_t getScopeId();
  inline void setScopeId( ::uint64_t value);

  inline bool hasNestedNodes();
  inline  ::capnp::List< ::capnp::schema::Node::NestedNode>::Builder getNestedNodes();
  inline void setNestedNodes( ::capnp::List< ::capnp::schema::Node::NestedNode>::Reader value);
  inline  ::capnp::List< ::capnp::schema::Node::NestedNode>::Builder initNestedNodes(unsigned int size);
  inline void adoptNestedNodes(::capnp::Orphan< ::capnp::List< ::capnp::schema::Node::NestedNode>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Node::NestedNode>> disownNestedNodes();

  inline bool hasAnnotations();
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder getAnnotations();
  inline void setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value);
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder initAnnotations(unsigned int size);
  inline void adoptAnnotations(::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> disownAnnotations();

inline Body::Builder getBody();
  inline  ::uint32_t getDisplayNamePrefixLength();
  inline void setDisplayNamePrefixLength( ::uint32_t value);

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Node::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Node::Builder builder) {
  return ::capnp::_::structString<Node>(builder._builder.asReader());
}

class Node::Body::Reader {
public:
  typedef Body Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

inline Which which() const;
  inline bool hasFileNode() const;
  inline  ::capnp::schema::FileNode::Reader getFileNode() const;

  inline bool hasStructNode() const;
  inline  ::capnp::schema::StructNode::Reader getStructNode() const;

  inline bool hasEnumNode() const;
  inline  ::capnp::schema::EnumNode::Reader getEnumNode() const;

  inline bool hasInterfaceNode() const;
  inline  ::capnp::schema::InterfaceNode::Reader getInterfaceNode() const;

  inline bool hasConstNode() const;
  inline  ::capnp::schema::ConstNode::Reader getConstNode() const;

  inline bool hasAnnotationNode() const;
  inline  ::capnp::schema::AnnotationNode::Reader getAnnotationNode() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Node::Body::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Node::Body::Reader reader) {
  return ::capnp::_::unionString<Node::Body>(reader._reader);
}

class Node::Body::Builder {
public:
  typedef Body Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

inline Which which();
  inline bool hasFileNode();
  inline  ::capnp::schema::FileNode::Builder getFileNode();
  inline void setFileNode( ::capnp::schema::FileNode::Reader value);
  inline  ::capnp::schema::FileNode::Builder initFileNode();
  inline void adoptFileNode(::capnp::Orphan< ::capnp::schema::FileNode>&& value);
  inline ::capnp::Orphan< ::capnp::schema::FileNode> disownFileNode();

  inline bool hasStructNode();
  inline  ::capnp::schema::StructNode::Builder getStructNode();
  inline void setStructNode( ::capnp::schema::StructNode::Reader value);
  inline  ::capnp::schema::StructNode::Builder initStructNode();
  inline void adoptStructNode(::capnp::Orphan< ::capnp::schema::StructNode>&& value);
  inline ::capnp::Orphan< ::capnp::schema::StructNode> disownStructNode();

  inline bool hasEnumNode();
  inline  ::capnp::schema::EnumNode::Builder getEnumNode();
  inline void setEnumNode( ::capnp::schema::EnumNode::Reader value);
  inline  ::capnp::schema::EnumNode::Builder initEnumNode();
  inline void adoptEnumNode(::capnp::Orphan< ::capnp::schema::EnumNode>&& value);
  inline ::capnp::Orphan< ::capnp::schema::EnumNode> disownEnumNode();

  inline bool hasInterfaceNode();
  inline  ::capnp::schema::InterfaceNode::Builder getInterfaceNode();
  inline void setInterfaceNode( ::capnp::schema::InterfaceNode::Reader value);
  inline  ::capnp::schema::InterfaceNode::Builder initInterfaceNode();
  inline void adoptInterfaceNode(::capnp::Orphan< ::capnp::schema::InterfaceNode>&& value);
  inline ::capnp::Orphan< ::capnp::schema::InterfaceNode> disownInterfaceNode();

  inline bool hasConstNode();
  inline  ::capnp::schema::ConstNode::Builder getConstNode();
  inline void setConstNode( ::capnp::schema::ConstNode::Reader value);
  inline  ::capnp::schema::ConstNode::Builder initConstNode();
  inline void adoptConstNode(::capnp::Orphan< ::capnp::schema::ConstNode>&& value);
  inline ::capnp::Orphan< ::capnp::schema::ConstNode> disownConstNode();

  inline bool hasAnnotationNode();
  inline  ::capnp::schema::AnnotationNode::Builder getAnnotationNode();
  inline void setAnnotationNode( ::capnp::schema::AnnotationNode::Reader value);
  inline  ::capnp::schema::AnnotationNode::Builder initAnnotationNode();
  inline void adoptAnnotationNode(::capnp::Orphan< ::capnp::schema::AnnotationNode>&& value);
  inline ::capnp::Orphan< ::capnp::schema::AnnotationNode> disownAnnotationNode();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Node::Body::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Node::Body::Builder builder) {
  return ::capnp::_::unionString<Node::Body>(builder._builder.asReader());
}

class Node::NestedNode::Reader {
public:
  typedef NestedNode Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasName() const;
  inline  ::capnp::Text::Reader getName() const;

  inline  ::uint64_t getId() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Node::NestedNode::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Node::NestedNode::Reader reader) {
  return ::capnp::_::structString<Node::NestedNode>(reader._reader);
}

class Node::NestedNode::Builder {
public:
  typedef NestedNode Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasName();
  inline  ::capnp::Text::Builder getName();
  inline void setName( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initName(unsigned int size);
  inline void adoptName(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownName();

  inline  ::uint64_t getId();
  inline void setId( ::uint64_t value);

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Node::NestedNode::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Node::NestedNode::Builder builder) {
  return ::capnp::_::structString<Node::NestedNode>(builder._builder.asReader());
}

class Type::Reader {
public:
  typedef Type Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

inline Body::Reader getBody() const;
private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Type::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Type::Reader reader) {
  return ::capnp::_::structString<Type>(reader._reader);
}

class Type::Builder {
public:
  typedef Type Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

inline Body::Builder getBody();
private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Type::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Type::Builder builder) {
  return ::capnp::_::structString<Type>(builder._builder.asReader());
}

class Type::Body::Reader {
public:
  typedef Body Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

inline Which which() const;
  inline  ::capnp::Void getVoidType() const;

  inline  ::capnp::Void getBoolType() const;

  inline  ::capnp::Void getInt8Type() const;

  inline  ::capnp::Void getInt16Type() const;

  inline  ::capnp::Void getInt32Type() const;

  inline  ::capnp::Void getInt64Type() const;

  inline  ::capnp::Void getUint8Type() const;

  inline  ::capnp::Void getUint16Type() const;

  inline  ::capnp::Void getUint32Type() const;

  inline  ::capnp::Void getUint64Type() const;

  inline  ::capnp::Void getFloat32Type() const;

  inline  ::capnp::Void getFloat64Type() const;

  inline  ::capnp::Void getTextType() const;

  inline  ::capnp::Void getDataType() const;

  inline bool hasListType() const;
  inline  ::capnp::schema::Type::Reader getListType() const;

  inline  ::uint64_t getEnumType() const;

  inline  ::uint64_t getStructType() const;

  inline  ::uint64_t getInterfaceType() const;

  inline  ::capnp::Void getObjectType() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Type::Body::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Type::Body::Reader reader) {
  return ::capnp::_::unionString<Type::Body>(reader._reader);
}

class Type::Body::Builder {
public:
  typedef Body Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

inline Which which();
  inline  ::capnp::Void getVoidType();
  inline void setVoidType( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getBoolType();
  inline void setBoolType( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getInt8Type();
  inline void setInt8Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getInt16Type();
  inline void setInt16Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getInt32Type();
  inline void setInt32Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getInt64Type();
  inline void setInt64Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getUint8Type();
  inline void setUint8Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getUint16Type();
  inline void setUint16Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getUint32Type();
  inline void setUint32Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getUint64Type();
  inline void setUint64Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getFloat32Type();
  inline void setFloat32Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getFloat64Type();
  inline void setFloat64Type( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getTextType();
  inline void setTextType( ::capnp::Void value = ::capnp::Void::VOID);

  inline  ::capnp::Void getDataType();
  inline void setDataType( ::capnp::Void value = ::capnp::Void::VOID);

  inline bool hasListType();
  inline  ::capnp::schema::Type::Builder getListType();
  inline void setListType( ::capnp::schema::Type::Reader value);
  inline  ::capnp::schema::Type::Builder initListType();
  inline void adoptListType(::capnp::Orphan< ::capnp::schema::Type>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Type> disownListType();

  inline  ::uint64_t getEnumType();
  inline void setEnumType( ::uint64_t value);

  inline  ::uint64_t getStructType();
  inline void setStructType( ::uint64_t value);

  inline  ::uint64_t getInterfaceType();
  inline void setInterfaceType( ::uint64_t value);

  inline  ::capnp::Void getObjectType();
  inline void setObjectType( ::capnp::Void value = ::capnp::Void::VOID);

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Type::Body::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Type::Body::Builder builder) {
  return ::capnp::_::unionString<Type::Body>(builder._builder.asReader());
}

class Value::Reader {
public:
  typedef Value Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

inline Body::Reader getBody() const;
private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Value::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Value::Reader reader) {
  return ::capnp::_::structString<Value>(reader._reader);
}

class Value::Builder {
public:
  typedef Value Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

inline Body::Builder getBody();
private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Value::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Value::Builder builder) {
  return ::capnp::_::structString<Value>(builder._builder.asReader());
}

class Value::Body::Reader {
public:
  typedef Body Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

inline Which which() const;
  inline  ::uint64_t getUint64Value() const;

  inline bool getBoolValue() const;

  inline  ::int8_t getInt8Value() const;

  inline  ::int16_t getInt16Value() const;

  inline  ::int32_t getInt32Value() const;

  inline  ::int64_t getInt64Value() const;

  inline  ::uint8_t getUint8Value() const;

  inline  ::uint16_t getUint16Value() const;

  inline  ::uint32_t getUint32Value() const;

  inline  ::capnp::Void getVoidValue() const;

  inline float getFloat32Value() const;

  inline double getFloat64Value() const;

  inline bool hasTextValue() const;
  inline  ::capnp::Text::Reader getTextValue() const;

  inline bool hasDataValue() const;
  inline  ::capnp::Data::Reader getDataValue() const;

  inline bool hasListValue() const;
  template <typename T>
  inline typename T::Reader getListValue() const;
  template <typename T, typename Param>
  inline typename T::Reader getListValue(Param&& param) const;

  inline  ::uint16_t getEnumValue() const;

  inline bool hasStructValue() const;
  template <typename T>
  inline typename T::Reader getStructValue() const;
  template <typename T, typename Param>
  inline typename T::Reader getStructValue(Param&& param) const;

  inline  ::capnp::Void getInterfaceValue() const;

  inline bool hasObjectValue() const;
  template <typename T>
  inline typename T::Reader getObjectValue() const;
  template <typename T, typename Param>
  inline typename T::Reader getObjectValue(Param&& param) const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Value::Body::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Value::Body::Reader reader) {
  return ::capnp::_::unionString<Value::Body>(reader._reader);
}

class Value::Body::Builder {
public:
  typedef Body Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

inline Which which();
  inline  ::uint64_t getUint64Value();
  inline void setUint64Value( ::uint64_t value);

  inline bool getBoolValue();
  inline void setBoolValue(bool value);

  inline  ::int8_t getInt8Value();
  inline void setInt8Value( ::int8_t value);

  inline  ::int16_t getInt16Value();
  inline void setInt16Value( ::int16_t value);

  inline  ::int32_t getInt32Value();
  inline void setInt32Value( ::int32_t value);

  inline  ::int64_t getInt64Value();
  inline void setInt64Value( ::int64_t value);

  inline  ::uint8_t getUint8Value();
  inline void setUint8Value( ::uint8_t value);

  inline  ::uint16_t getUint16Value();
  inline void setUint16Value( ::uint16_t value);

  inline  ::uint32_t getUint32Value();
  inline void setUint32Value( ::uint32_t value);

  inline  ::capnp::Void getVoidValue();
  inline void setVoidValue( ::capnp::Void value = ::capnp::Void::VOID);

  inline float getFloat32Value();
  inline void setFloat32Value(float value);

  inline double getFloat64Value();
  inline void setFloat64Value(double value);

  inline bool hasTextValue();
  inline  ::capnp::Text::Builder getTextValue();
  inline void setTextValue( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initTextValue(unsigned int size);
  inline void adoptTextValue(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownTextValue();

  inline bool hasDataValue();
  inline  ::capnp::Data::Builder getDataValue();
  inline void setDataValue( ::capnp::Data::Reader value);
  inline  ::capnp::Data::Builder initDataValue(unsigned int size);
  inline void adoptDataValue(::capnp::Orphan< ::capnp::Data>&& value);
  inline ::capnp::Orphan< ::capnp::Data> disownDataValue();

  inline bool hasListValue();
  template <typename T>
  inline typename T::Builder getListValue();
  template <typename T, typename Param>
  inline typename T::Builder getListValue(Param&& param);
  template <typename T>
  inline void setListValue(typename T::Reader value);
  template <typename T, typename U>  inline void setListValue(std::initializer_list<U> value);
  template <typename T, typename... Params>
  inline typename T::Builder initListValue(Params&&... params);
  template <typename T>
  inline void adoptListValue(::capnp::Orphan<T>&& value);
  template <typename T, typename... Params>
  inline ::capnp::Orphan<T> disownListValue(Params&&... params);

  inline  ::uint16_t getEnumValue();
  inline void setEnumValue( ::uint16_t value);

  inline bool hasStructValue();
  template <typename T>
  inline typename T::Builder getStructValue();
  template <typename T, typename Param>
  inline typename T::Builder getStructValue(Param&& param);
  template <typename T>
  inline void setStructValue(typename T::Reader value);
  template <typename T, typename U>  inline void setStructValue(std::initializer_list<U> value);
  template <typename T, typename... Params>
  inline typename T::Builder initStructValue(Params&&... params);
  template <typename T>
  inline void adoptStructValue(::capnp::Orphan<T>&& value);
  template <typename T, typename... Params>
  inline ::capnp::Orphan<T> disownStructValue(Params&&... params);

  inline  ::capnp::Void getInterfaceValue();
  inline void setInterfaceValue( ::capnp::Void value = ::capnp::Void::VOID);

  inline bool hasObjectValue();
  template <typename T>
  inline typename T::Builder getObjectValue();
  template <typename T, typename Param>
  inline typename T::Builder getObjectValue(Param&& param);
  template <typename T>
  inline void setObjectValue(typename T::Reader value);
  template <typename T, typename U>  inline void setObjectValue(std::initializer_list<U> value);
  template <typename T, typename... Params>
  inline typename T::Builder initObjectValue(Params&&... params);
  template <typename T>
  inline void adoptObjectValue(::capnp::Orphan<T>&& value);
  template <typename T, typename... Params>
  inline ::capnp::Orphan<T> disownObjectValue(Params&&... params);

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Value::Body::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Value::Body::Builder builder) {
  return ::capnp::_::unionString<Value::Body>(builder._builder.asReader());
}

class Annotation::Reader {
public:
  typedef Annotation Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline  ::uint64_t getId() const;

  inline bool hasValue() const;
  inline  ::capnp::schema::Value::Reader getValue() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Annotation::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Annotation::Reader reader) {
  return ::capnp::_::structString<Annotation>(reader._reader);
}

class Annotation::Builder {
public:
  typedef Annotation Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline  ::uint64_t getId();
  inline void setId( ::uint64_t value);

  inline bool hasValue();
  inline  ::capnp::schema::Value::Builder getValue();
  inline void setValue( ::capnp::schema::Value::Reader value);
  inline  ::capnp::schema::Value::Builder initValue();
  inline void adoptValue(::capnp::Orphan< ::capnp::schema::Value>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Value> disownValue();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Annotation::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Annotation::Builder builder) {
  return ::capnp::_::structString<Annotation>(builder._builder.asReader());
}

class FileNode::Reader {
public:
  typedef FileNode Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasImports() const;
  inline  ::capnp::List< ::capnp::schema::FileNode::Import>::Reader getImports() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(FileNode::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(FileNode::Reader reader) {
  return ::capnp::_::structString<FileNode>(reader._reader);
}

class FileNode::Builder {
public:
  typedef FileNode Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasImports();
  inline  ::capnp::List< ::capnp::schema::FileNode::Import>::Builder getImports();
  inline void setImports( ::capnp::List< ::capnp::schema::FileNode::Import>::Reader value);
  inline  ::capnp::List< ::capnp::schema::FileNode::Import>::Builder initImports(unsigned int size);
  inline void adoptImports(::capnp::Orphan< ::capnp::List< ::capnp::schema::FileNode::Import>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::FileNode::Import>> disownImports();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(FileNode::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(FileNode::Builder builder) {
  return ::capnp::_::structString<FileNode>(builder._builder.asReader());
}

class FileNode::Import::Reader {
public:
  typedef Import Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline  ::uint64_t getId() const;

  inline bool hasName() const;
  inline  ::capnp::Text::Reader getName() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(FileNode::Import::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(FileNode::Import::Reader reader) {
  return ::capnp::_::structString<FileNode::Import>(reader._reader);
}

class FileNode::Import::Builder {
public:
  typedef Import Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline  ::uint64_t getId();
  inline void setId( ::uint64_t value);

  inline bool hasName();
  inline  ::capnp::Text::Builder getName();
  inline void setName( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initName(unsigned int size);
  inline void adoptName(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownName();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(FileNode::Import::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(FileNode::Import::Builder builder) {
  return ::capnp::_::structString<FileNode::Import>(builder._builder.asReader());
}

class StructNode::Reader {
public:
  typedef StructNode Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline  ::uint16_t getDataSectionWordSize() const;

  inline  ::uint16_t getPointerSectionSize() const;

  inline  ::capnp::schema::ElementSize getPreferredListEncoding() const;

  inline bool hasMembers() const;
  inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Reader getMembers() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Reader reader) {
  return ::capnp::_::structString<StructNode>(reader._reader);
}

class StructNode::Builder {
public:
  typedef StructNode Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline  ::uint16_t getDataSectionWordSize();
  inline void setDataSectionWordSize( ::uint16_t value);

  inline  ::uint16_t getPointerSectionSize();
  inline void setPointerSectionSize( ::uint16_t value);

  inline  ::capnp::schema::ElementSize getPreferredListEncoding();
  inline void setPreferredListEncoding( ::capnp::schema::ElementSize value);

  inline bool hasMembers();
  inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder getMembers();
  inline void setMembers( ::capnp::List< ::capnp::schema::StructNode::Member>::Reader value);
  inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder initMembers(unsigned int size);
  inline void adoptMembers(::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>> disownMembers();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Builder builder) {
  return ::capnp::_::structString<StructNode>(builder._builder.asReader());
}

class StructNode::Member::Reader {
public:
  typedef Member Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasName() const;
  inline  ::capnp::Text::Reader getName() const;

  inline  ::uint16_t getOrdinal() const;

  inline  ::uint16_t getCodeOrder() const;

  inline bool hasAnnotations() const;
  inline  ::capnp::List< ::capnp::schema::Annotation>::Reader getAnnotations() const;

inline Body::Reader getBody() const;
private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Member::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Member::Reader reader) {
  return ::capnp::_::structString<StructNode::Member>(reader._reader);
}

class StructNode::Member::Builder {
public:
  typedef Member Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasName();
  inline  ::capnp::Text::Builder getName();
  inline void setName( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initName(unsigned int size);
  inline void adoptName(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownName();

  inline  ::uint16_t getOrdinal();
  inline void setOrdinal( ::uint16_t value);

  inline  ::uint16_t getCodeOrder();
  inline void setCodeOrder( ::uint16_t value);

  inline bool hasAnnotations();
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder getAnnotations();
  inline void setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value);
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder initAnnotations(unsigned int size);
  inline void adoptAnnotations(::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> disownAnnotations();

inline Body::Builder getBody();
private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Member::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Member::Builder builder) {
  return ::capnp::_::structString<StructNode::Member>(builder._builder.asReader());
}

class StructNode::Member::Body::Reader {
public:
  typedef Body Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

inline Which which() const;
  inline bool hasFieldMember() const;
  inline  ::capnp::schema::StructNode::Field::Reader getFieldMember() const;

  inline bool hasUnionMember() const;
  inline  ::capnp::schema::StructNode::Union::Reader getUnionMember() const;

  inline bool hasGroupMember() const;
  inline  ::capnp::schema::StructNode::Group::Reader getGroupMember() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Member::Body::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Member::Body::Reader reader) {
  return ::capnp::_::unionString<StructNode::Member::Body>(reader._reader);
}

class StructNode::Member::Body::Builder {
public:
  typedef Body Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

inline Which which();
  inline bool hasFieldMember();
  inline  ::capnp::schema::StructNode::Field::Builder getFieldMember();
  inline void setFieldMember( ::capnp::schema::StructNode::Field::Reader value);
  inline  ::capnp::schema::StructNode::Field::Builder initFieldMember();
  inline void adoptFieldMember(::capnp::Orphan< ::capnp::schema::StructNode::Field>&& value);
  inline ::capnp::Orphan< ::capnp::schema::StructNode::Field> disownFieldMember();

  inline bool hasUnionMember();
  inline  ::capnp::schema::StructNode::Union::Builder getUnionMember();
  inline void setUnionMember( ::capnp::schema::StructNode::Union::Reader value);
  inline  ::capnp::schema::StructNode::Union::Builder initUnionMember();
  inline void adoptUnionMember(::capnp::Orphan< ::capnp::schema::StructNode::Union>&& value);
  inline ::capnp::Orphan< ::capnp::schema::StructNode::Union> disownUnionMember();

  inline bool hasGroupMember();
  inline  ::capnp::schema::StructNode::Group::Builder getGroupMember();
  inline void setGroupMember( ::capnp::schema::StructNode::Group::Reader value);
  inline  ::capnp::schema::StructNode::Group::Builder initGroupMember();
  inline void adoptGroupMember(::capnp::Orphan< ::capnp::schema::StructNode::Group>&& value);
  inline ::capnp::Orphan< ::capnp::schema::StructNode::Group> disownGroupMember();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Member::Body::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Member::Body::Builder builder) {
  return ::capnp::_::unionString<StructNode::Member::Body>(builder._builder.asReader());
}

class StructNode::Field::Reader {
public:
  typedef Field Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline  ::uint32_t getOffset() const;

  inline bool hasType() const;
  inline  ::capnp::schema::Type::Reader getType() const;

  inline bool hasDefaultValue() const;
  inline  ::capnp::schema::Value::Reader getDefaultValue() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Field::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Field::Reader reader) {
  return ::capnp::_::structString<StructNode::Field>(reader._reader);
}

class StructNode::Field::Builder {
public:
  typedef Field Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline  ::uint32_t getOffset();
  inline void setOffset( ::uint32_t value);

  inline bool hasType();
  inline  ::capnp::schema::Type::Builder getType();
  inline void setType( ::capnp::schema::Type::Reader value);
  inline  ::capnp::schema::Type::Builder initType();
  inline void adoptType(::capnp::Orphan< ::capnp::schema::Type>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Type> disownType();

  inline bool hasDefaultValue();
  inline  ::capnp::schema::Value::Builder getDefaultValue();
  inline void setDefaultValue( ::capnp::schema::Value::Reader value);
  inline  ::capnp::schema::Value::Builder initDefaultValue();
  inline void adoptDefaultValue(::capnp::Orphan< ::capnp::schema::Value>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Value> disownDefaultValue();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Field::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Field::Builder builder) {
  return ::capnp::_::structString<StructNode::Field>(builder._builder.asReader());
}

class StructNode::Union::Reader {
public:
  typedef Union Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline  ::uint32_t getDiscriminantOffset() const;

  inline bool hasMembers() const;
  inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Reader getMembers() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Union::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Union::Reader reader) {
  return ::capnp::_::structString<StructNode::Union>(reader._reader);
}

class StructNode::Union::Builder {
public:
  typedef Union Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline  ::uint32_t getDiscriminantOffset();
  inline void setDiscriminantOffset( ::uint32_t value);

  inline bool hasMembers();
  inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder getMembers();
  inline void setMembers( ::capnp::List< ::capnp::schema::StructNode::Member>::Reader value);
  inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder initMembers(unsigned int size);
  inline void adoptMembers(::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>> disownMembers();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Union::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Union::Builder builder) {
  return ::capnp::_::structString<StructNode::Union>(builder._builder.asReader());
}

class StructNode::Group::Reader {
public:
  typedef Group Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasMembers() const;
  inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Reader getMembers() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Group::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Group::Reader reader) {
  return ::capnp::_::structString<StructNode::Group>(reader._reader);
}

class StructNode::Group::Builder {
public:
  typedef Group Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasMembers();
  inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder getMembers();
  inline void setMembers( ::capnp::List< ::capnp::schema::StructNode::Member>::Reader value);
  inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder initMembers(unsigned int size);
  inline void adoptMembers(::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>> disownMembers();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(StructNode::Group::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(StructNode::Group::Builder builder) {
  return ::capnp::_::structString<StructNode::Group>(builder._builder.asReader());
}

class EnumNode::Reader {
public:
  typedef EnumNode Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasEnumerants() const;
  inline  ::capnp::List< ::capnp::schema::EnumNode::Enumerant>::Reader getEnumerants() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(EnumNode::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(EnumNode::Reader reader) {
  return ::capnp::_::structString<EnumNode>(reader._reader);
}

class EnumNode::Builder {
public:
  typedef EnumNode Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasEnumerants();
  inline  ::capnp::List< ::capnp::schema::EnumNode::Enumerant>::Builder getEnumerants();
  inline void setEnumerants( ::capnp::List< ::capnp::schema::EnumNode::Enumerant>::Reader value);
  inline  ::capnp::List< ::capnp::schema::EnumNode::Enumerant>::Builder initEnumerants(unsigned int size);
  inline void adoptEnumerants(::capnp::Orphan< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>> disownEnumerants();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(EnumNode::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(EnumNode::Builder builder) {
  return ::capnp::_::structString<EnumNode>(builder._builder.asReader());
}

class EnumNode::Enumerant::Reader {
public:
  typedef Enumerant Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasName() const;
  inline  ::capnp::Text::Reader getName() const;

  inline  ::uint16_t getCodeOrder() const;

  inline bool hasAnnotations() const;
  inline  ::capnp::List< ::capnp::schema::Annotation>::Reader getAnnotations() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(EnumNode::Enumerant::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(EnumNode::Enumerant::Reader reader) {
  return ::capnp::_::structString<EnumNode::Enumerant>(reader._reader);
}

class EnumNode::Enumerant::Builder {
public:
  typedef Enumerant Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasName();
  inline  ::capnp::Text::Builder getName();
  inline void setName( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initName(unsigned int size);
  inline void adoptName(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownName();

  inline  ::uint16_t getCodeOrder();
  inline void setCodeOrder( ::uint16_t value);

  inline bool hasAnnotations();
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder getAnnotations();
  inline void setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value);
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder initAnnotations(unsigned int size);
  inline void adoptAnnotations(::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> disownAnnotations();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(EnumNode::Enumerant::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(EnumNode::Enumerant::Builder builder) {
  return ::capnp::_::structString<EnumNode::Enumerant>(builder._builder.asReader());
}

class InterfaceNode::Reader {
public:
  typedef InterfaceNode Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasMethods() const;
  inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method>::Reader getMethods() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Reader reader) {
  return ::capnp::_::structString<InterfaceNode>(reader._reader);
}

class InterfaceNode::Builder {
public:
  typedef InterfaceNode Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasMethods();
  inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method>::Builder getMethods();
  inline void setMethods( ::capnp::List< ::capnp::schema::InterfaceNode::Method>::Reader value);
  inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method>::Builder initMethods(unsigned int size);
  inline void adoptMethods(::capnp::Orphan< ::capnp::List< ::capnp::schema::InterfaceNode::Method>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::InterfaceNode::Method>> disownMethods();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Builder builder) {
  return ::capnp::_::structString<InterfaceNode>(builder._builder.asReader());
}

class InterfaceNode::Method::Reader {
public:
  typedef Method Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasName() const;
  inline  ::capnp::Text::Reader getName() const;

  inline  ::uint16_t getCodeOrder() const;

  inline bool hasParams() const;
  inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>::Reader getParams() const;

  inline  ::uint16_t getRequiredParamCount() const;

  inline bool hasReturnType() const;
  inline  ::capnp::schema::Type::Reader getReturnType() const;

  inline bool hasAnnotations() const;
  inline  ::capnp::List< ::capnp::schema::Annotation>::Reader getAnnotations() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Method::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Method::Reader reader) {
  return ::capnp::_::structString<InterfaceNode::Method>(reader._reader);
}

class InterfaceNode::Method::Builder {
public:
  typedef Method Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasName();
  inline  ::capnp::Text::Builder getName();
  inline void setName( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initName(unsigned int size);
  inline void adoptName(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownName();

  inline  ::uint16_t getCodeOrder();
  inline void setCodeOrder( ::uint16_t value);

  inline bool hasParams();
  inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>::Builder getParams();
  inline void setParams( ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>::Reader value);
  inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>::Builder initParams(unsigned int size);
  inline void adoptParams(::capnp::Orphan< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>> disownParams();

  inline  ::uint16_t getRequiredParamCount();
  inline void setRequiredParamCount( ::uint16_t value);

  inline bool hasReturnType();
  inline  ::capnp::schema::Type::Builder getReturnType();
  inline void setReturnType( ::capnp::schema::Type::Reader value);
  inline  ::capnp::schema::Type::Builder initReturnType();
  inline void adoptReturnType(::capnp::Orphan< ::capnp::schema::Type>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Type> disownReturnType();

  inline bool hasAnnotations();
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder getAnnotations();
  inline void setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value);
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder initAnnotations(unsigned int size);
  inline void adoptAnnotations(::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> disownAnnotations();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Method::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Method::Builder builder) {
  return ::capnp::_::structString<InterfaceNode::Method>(builder._builder.asReader());
}

class InterfaceNode::Method::Param::Reader {
public:
  typedef Param Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasName() const;
  inline  ::capnp::Text::Reader getName() const;

  inline bool hasType() const;
  inline  ::capnp::schema::Type::Reader getType() const;

  inline bool hasDefaultValue() const;
  inline  ::capnp::schema::Value::Reader getDefaultValue() const;

  inline bool hasAnnotations() const;
  inline  ::capnp::List< ::capnp::schema::Annotation>::Reader getAnnotations() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Method::Param::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Method::Param::Reader reader) {
  return ::capnp::_::structString<InterfaceNode::Method::Param>(reader._reader);
}

class InterfaceNode::Method::Param::Builder {
public:
  typedef Param Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasName();
  inline  ::capnp::Text::Builder getName();
  inline void setName( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initName(unsigned int size);
  inline void adoptName(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownName();

  inline bool hasType();
  inline  ::capnp::schema::Type::Builder getType();
  inline void setType( ::capnp::schema::Type::Reader value);
  inline  ::capnp::schema::Type::Builder initType();
  inline void adoptType(::capnp::Orphan< ::capnp::schema::Type>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Type> disownType();

  inline bool hasDefaultValue();
  inline  ::capnp::schema::Value::Builder getDefaultValue();
  inline void setDefaultValue( ::capnp::schema::Value::Reader value);
  inline  ::capnp::schema::Value::Builder initDefaultValue();
  inline void adoptDefaultValue(::capnp::Orphan< ::capnp::schema::Value>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Value> disownDefaultValue();

  inline bool hasAnnotations();
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder getAnnotations();
  inline void setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value);
  inline  ::capnp::List< ::capnp::schema::Annotation>::Builder initAnnotations(unsigned int size);
  inline void adoptAnnotations(::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> disownAnnotations();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Method::Param::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(InterfaceNode::Method::Param::Builder builder) {
  return ::capnp::_::structString<InterfaceNode::Method::Param>(builder._builder.asReader());
}

class ConstNode::Reader {
public:
  typedef ConstNode Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasType() const;
  inline  ::capnp::schema::Type::Reader getType() const;

  inline bool hasValue() const;
  inline  ::capnp::schema::Value::Reader getValue() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(ConstNode::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(ConstNode::Reader reader) {
  return ::capnp::_::structString<ConstNode>(reader._reader);
}

class ConstNode::Builder {
public:
  typedef ConstNode Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasType();
  inline  ::capnp::schema::Type::Builder getType();
  inline void setType( ::capnp::schema::Type::Reader value);
  inline  ::capnp::schema::Type::Builder initType();
  inline void adoptType(::capnp::Orphan< ::capnp::schema::Type>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Type> disownType();

  inline bool hasValue();
  inline  ::capnp::schema::Value::Builder getValue();
  inline void setValue( ::capnp::schema::Value::Reader value);
  inline  ::capnp::schema::Value::Builder initValue();
  inline void adoptValue(::capnp::Orphan< ::capnp::schema::Value>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Value> disownValue();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(ConstNode::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(ConstNode::Builder builder) {
  return ::capnp::_::structString<ConstNode>(builder._builder.asReader());
}

class AnnotationNode::Reader {
public:
  typedef AnnotationNode Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasType() const;
  inline  ::capnp::schema::Type::Reader getType() const;

  inline bool getTargetsFile() const;

  inline bool getTargetsConst() const;

  inline bool getTargetsEnum() const;

  inline bool getTargetsEnumerant() const;

  inline bool getTargetsStruct() const;

  inline bool getTargetsField() const;

  inline bool getTargetsUnion() const;

  inline bool getTargetsInterface() const;

  inline bool getTargetsMethod() const;

  inline bool getTargetsParam() const;

  inline bool getTargetsAnnotation() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(AnnotationNode::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(AnnotationNode::Reader reader) {
  return ::capnp::_::structString<AnnotationNode>(reader._reader);
}

class AnnotationNode::Builder {
public:
  typedef AnnotationNode Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasType();
  inline  ::capnp::schema::Type::Builder getType();
  inline void setType( ::capnp::schema::Type::Reader value);
  inline  ::capnp::schema::Type::Builder initType();
  inline void adoptType(::capnp::Orphan< ::capnp::schema::Type>&& value);
  inline ::capnp::Orphan< ::capnp::schema::Type> disownType();

  inline bool getTargetsFile();
  inline void setTargetsFile(bool value);

  inline bool getTargetsConst();
  inline void setTargetsConst(bool value);

  inline bool getTargetsEnum();
  inline void setTargetsEnum(bool value);

  inline bool getTargetsEnumerant();
  inline void setTargetsEnumerant(bool value);

  inline bool getTargetsStruct();
  inline void setTargetsStruct(bool value);

  inline bool getTargetsField();
  inline void setTargetsField(bool value);

  inline bool getTargetsUnion();
  inline void setTargetsUnion(bool value);

  inline bool getTargetsInterface();
  inline void setTargetsInterface(bool value);

  inline bool getTargetsMethod();
  inline void setTargetsMethod(bool value);

  inline bool getTargetsParam();
  inline void setTargetsParam(bool value);

  inline bool getTargetsAnnotation();
  inline void setTargetsAnnotation(bool value);

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(AnnotationNode::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(AnnotationNode::Builder builder) {
  return ::capnp::_::structString<AnnotationNode>(builder._builder.asReader());
}

class CodeGeneratorRequest::Reader {
public:
  typedef CodeGeneratorRequest Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline size_t totalSizeInWords() const {
    return _reader.totalSize() / ::capnp::WORDS;
  }

  inline bool hasNodes() const;
  inline  ::capnp::List< ::capnp::schema::Node>::Reader getNodes() const;

  inline bool hasRequestedFiles() const;
  inline  ::capnp::List< ::uint64_t>::Reader getRequestedFiles() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(CodeGeneratorRequest::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(CodeGeneratorRequest::Reader reader) {
  return ::capnp::_::structString<CodeGeneratorRequest>(reader._reader);
}

class CodeGeneratorRequest::Builder {
public:
  typedef CodeGeneratorRequest Builds;

  Builder() = default;
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline size_t totalSizeInWords() { return asReader().totalSizeInWords(); }

  inline bool hasNodes();
  inline  ::capnp::List< ::capnp::schema::Node>::Builder getNodes();
  inline void setNodes( ::capnp::List< ::capnp::schema::Node>::Reader value);
  inline  ::capnp::List< ::capnp::schema::Node>::Builder initNodes(unsigned int size);
  inline void adoptNodes(::capnp::Orphan< ::capnp::List< ::capnp::schema::Node>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Node>> disownNodes();

  inline bool hasRequestedFiles();
  inline  ::capnp::List< ::uint64_t>::Builder getRequestedFiles();
  inline void setRequestedFiles( ::capnp::List< ::uint64_t>::Reader value);
  inline void setRequestedFiles(std::initializer_list< ::uint64_t> value);
  inline  ::capnp::List< ::uint64_t>::Builder initRequestedFiles(unsigned int size);
  inline void adoptRequestedFiles(::capnp::Orphan< ::capnp::List< ::uint64_t>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::uint64_t>> disownRequestedFiles();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(CodeGeneratorRequest::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(CodeGeneratorRequest::Builder builder) {
  return ::capnp::_::structString<CodeGeneratorRequest>(builder._builder.asReader());
}

// =======================================================================================

inline  ::uint64_t Node::Reader::getId() const {
  return _reader.getDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Node::Builder::getId() {
  return _builder.getDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS);
}
inline void Node::Builder::setId( ::uint64_t value) {
  _builder.setDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool Node::Reader::hasDisplayName() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool Node::Builder::hasDisplayName() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Reader Node::Reader::getDisplayName() const {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Builder Node::Builder::getDisplayName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void Node::Builder::setDisplayName( ::capnp::Text::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::Text::Builder Node::Builder::initDisplayName(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void Node::Builder::adoptDisplayName(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> Node::Builder::disownDisplayName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline  ::uint64_t Node::Reader::getScopeId() const {
  return _reader.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Node::Builder::getScopeId() {
  return _builder.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}
inline void Node::Builder::setScopeId( ::uint64_t value) {
  _builder.setDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline bool Node::Reader::hasNestedNodes() const {
  return !_reader.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline bool Node::Builder::hasNestedNodes() {
  return !_builder.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Node::NestedNode>::Reader Node::Reader::getNestedNodes() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node::NestedNode>>::get(
      _reader, 1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Node::NestedNode>::Builder Node::Builder::getNestedNodes() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node::NestedNode>>::get(
      _builder, 1 * ::capnp::POINTERS);
}
inline void Node::Builder::setNestedNodes( ::capnp::List< ::capnp::schema::Node::NestedNode>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node::NestedNode>>::set(
      _builder, 1 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::Node::NestedNode>::Builder Node::Builder::initNestedNodes(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node::NestedNode>>::init(
      _builder, 1 * ::capnp::POINTERS, size);
}
inline void Node::Builder::adoptNestedNodes(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::Node::NestedNode>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node::NestedNode>>::adopt(
      _builder, 1 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Node::NestedNode>> Node::Builder::disownNestedNodes() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node::NestedNode>>::disown(
      _builder, 1 * ::capnp::POINTERS);
}

inline bool Node::Reader::hasAnnotations() const {
  return !_reader.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline bool Node::Builder::hasAnnotations() {
  return !_builder.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Reader Node::Reader::getAnnotations() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _reader, 2 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder Node::Builder::getAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _builder, 2 * ::capnp::POINTERS);
}
inline void Node::Builder::setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::set(
      _builder, 2 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder Node::Builder::initAnnotations(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::init(
      _builder, 2 * ::capnp::POINTERS, size);
}
inline void Node::Builder::adoptAnnotations(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::adopt(
      _builder, 2 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> Node::Builder::disownAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::disown(
      _builder, 2 * ::capnp::POINTERS);
}

inline Node::Body::Reader Node::Reader::getBody() const {
  return Node::Body::Reader(_reader);
}
inline Node::Body::Builder Node::Builder::getBody() {
  return Node::Body::Builder(_builder);
}
inline Node::Body::Which Node::Body::Reader::which() const {
  return _reader.getDataField<Which>(8 * ::capnp::ELEMENTS);
}
inline Node::Body::Which Node::Body::Builder::which() {
  return _builder.getDataField<Which>(8 * ::capnp::ELEMENTS);
}

inline bool Node::Body::Reader::hasFileNode() const {
  KJ_IREQUIRE(which() == Body::FILE_NODE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline bool Node::Body::Builder::hasFileNode() {
  KJ_IREQUIRE(which() == Body::FILE_NODE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::FileNode::Reader Node::Body::Reader::getFileNode() const {
  KJ_IREQUIRE(which() == Body::FILE_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::FileNode>::get(
      _reader, 3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::FileNode::Builder Node::Body::Builder::getFileNode() {
  KJ_IREQUIRE(which() == Body::FILE_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::FileNode>::get(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::setFileNode( ::capnp::schema::FileNode::Reader value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::FILE_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::FileNode>::set(
      _builder, 3 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::FileNode::Builder Node::Body::Builder::initFileNode() {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::FILE_NODE);
  return ::capnp::_::PointerHelpers< ::capnp::schema::FileNode>::init(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::adoptFileNode(
    ::capnp::Orphan< ::capnp::schema::FileNode>&& value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::FILE_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::FileNode>::adopt(
      _builder, 3 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::FileNode> Node::Body::Builder::disownFileNode() {
  KJ_IREQUIRE(which() == Body::FILE_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::FileNode>::disown(
      _builder, 3 * ::capnp::POINTERS);
}

inline bool Node::Body::Reader::hasStructNode() const {
  KJ_IREQUIRE(which() == Body::STRUCT_NODE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline bool Node::Body::Builder::hasStructNode() {
  KJ_IREQUIRE(which() == Body::STRUCT_NODE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::StructNode::Reader Node::Body::Reader::getStructNode() const {
  KJ_IREQUIRE(which() == Body::STRUCT_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode>::get(
      _reader, 3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::StructNode::Builder Node::Body::Builder::getStructNode() {
  KJ_IREQUIRE(which() == Body::STRUCT_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode>::get(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::setStructNode( ::capnp::schema::StructNode::Reader value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::STRUCT_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::StructNode>::set(
      _builder, 3 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::StructNode::Builder Node::Body::Builder::initStructNode() {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::STRUCT_NODE);
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode>::init(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::adoptStructNode(
    ::capnp::Orphan< ::capnp::schema::StructNode>&& value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::STRUCT_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::StructNode>::adopt(
      _builder, 3 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::StructNode> Node::Body::Builder::disownStructNode() {
  KJ_IREQUIRE(which() == Body::STRUCT_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode>::disown(
      _builder, 3 * ::capnp::POINTERS);
}

inline bool Node::Body::Reader::hasEnumNode() const {
  KJ_IREQUIRE(which() == Body::ENUM_NODE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline bool Node::Body::Builder::hasEnumNode() {
  KJ_IREQUIRE(which() == Body::ENUM_NODE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::EnumNode::Reader Node::Body::Reader::getEnumNode() const {
  KJ_IREQUIRE(which() == Body::ENUM_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::EnumNode>::get(
      _reader, 3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::EnumNode::Builder Node::Body::Builder::getEnumNode() {
  KJ_IREQUIRE(which() == Body::ENUM_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::EnumNode>::get(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::setEnumNode( ::capnp::schema::EnumNode::Reader value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::ENUM_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::EnumNode>::set(
      _builder, 3 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::EnumNode::Builder Node::Body::Builder::initEnumNode() {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::ENUM_NODE);
  return ::capnp::_::PointerHelpers< ::capnp::schema::EnumNode>::init(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::adoptEnumNode(
    ::capnp::Orphan< ::capnp::schema::EnumNode>&& value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::ENUM_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::EnumNode>::adopt(
      _builder, 3 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::EnumNode> Node::Body::Builder::disownEnumNode() {
  KJ_IREQUIRE(which() == Body::ENUM_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::EnumNode>::disown(
      _builder, 3 * ::capnp::POINTERS);
}

inline bool Node::Body::Reader::hasInterfaceNode() const {
  KJ_IREQUIRE(which() == Body::INTERFACE_NODE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline bool Node::Body::Builder::hasInterfaceNode() {
  KJ_IREQUIRE(which() == Body::INTERFACE_NODE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::InterfaceNode::Reader Node::Body::Reader::getInterfaceNode() const {
  KJ_IREQUIRE(which() == Body::INTERFACE_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::InterfaceNode>::get(
      _reader, 3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::InterfaceNode::Builder Node::Body::Builder::getInterfaceNode() {
  KJ_IREQUIRE(which() == Body::INTERFACE_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::InterfaceNode>::get(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::setInterfaceNode( ::capnp::schema::InterfaceNode::Reader value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::INTERFACE_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::InterfaceNode>::set(
      _builder, 3 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::InterfaceNode::Builder Node::Body::Builder::initInterfaceNode() {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::INTERFACE_NODE);
  return ::capnp::_::PointerHelpers< ::capnp::schema::InterfaceNode>::init(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::adoptInterfaceNode(
    ::capnp::Orphan< ::capnp::schema::InterfaceNode>&& value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::INTERFACE_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::InterfaceNode>::adopt(
      _builder, 3 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::InterfaceNode> Node::Body::Builder::disownInterfaceNode() {
  KJ_IREQUIRE(which() == Body::INTERFACE_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::InterfaceNode>::disown(
      _builder, 3 * ::capnp::POINTERS);
}

inline bool Node::Body::Reader::hasConstNode() const {
  KJ_IREQUIRE(which() == Body::CONST_NODE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline bool Node::Body::Builder::hasConstNode() {
  KJ_IREQUIRE(which() == Body::CONST_NODE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::ConstNode::Reader Node::Body::Reader::getConstNode() const {
  KJ_IREQUIRE(which() == Body::CONST_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::ConstNode>::get(
      _reader, 3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::ConstNode::Builder Node::Body::Builder::getConstNode() {
  KJ_IREQUIRE(which() == Body::CONST_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::ConstNode>::get(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::setConstNode( ::capnp::schema::ConstNode::Reader value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::CONST_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::ConstNode>::set(
      _builder, 3 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::ConstNode::Builder Node::Body::Builder::initConstNode() {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::CONST_NODE);
  return ::capnp::_::PointerHelpers< ::capnp::schema::ConstNode>::init(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::adoptConstNode(
    ::capnp::Orphan< ::capnp::schema::ConstNode>&& value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::CONST_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::ConstNode>::adopt(
      _builder, 3 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::ConstNode> Node::Body::Builder::disownConstNode() {
  KJ_IREQUIRE(which() == Body::CONST_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::ConstNode>::disown(
      _builder, 3 * ::capnp::POINTERS);
}

inline bool Node::Body::Reader::hasAnnotationNode() const {
  KJ_IREQUIRE(which() == Body::ANNOTATION_NODE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline bool Node::Body::Builder::hasAnnotationNode() {
  KJ_IREQUIRE(which() == Body::ANNOTATION_NODE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::AnnotationNode::Reader Node::Body::Reader::getAnnotationNode() const {
  KJ_IREQUIRE(which() == Body::ANNOTATION_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::AnnotationNode>::get(
      _reader, 3 * ::capnp::POINTERS);
}
inline  ::capnp::schema::AnnotationNode::Builder Node::Body::Builder::getAnnotationNode() {
  KJ_IREQUIRE(which() == Body::ANNOTATION_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::AnnotationNode>::get(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::setAnnotationNode( ::capnp::schema::AnnotationNode::Reader value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::ANNOTATION_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::AnnotationNode>::set(
      _builder, 3 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::AnnotationNode::Builder Node::Body::Builder::initAnnotationNode() {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::ANNOTATION_NODE);
  return ::capnp::_::PointerHelpers< ::capnp::schema::AnnotationNode>::init(
      _builder, 3 * ::capnp::POINTERS);
}
inline void Node::Body::Builder::adoptAnnotationNode(
    ::capnp::Orphan< ::capnp::schema::AnnotationNode>&& value) {
  _builder.setDataField<Body::Which>(
      8 * ::capnp::ELEMENTS, Body::ANNOTATION_NODE);
  ::capnp::_::PointerHelpers< ::capnp::schema::AnnotationNode>::adopt(
      _builder, 3 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::AnnotationNode> Node::Body::Builder::disownAnnotationNode() {
  KJ_IREQUIRE(which() == Body::ANNOTATION_NODE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::AnnotationNode>::disown(
      _builder, 3 * ::capnp::POINTERS);
}

inline  ::uint32_t Node::Reader::getDisplayNamePrefixLength() const {
  return _reader.getDataField< ::uint32_t>(
      5 * ::capnp::ELEMENTS);
}

inline  ::uint32_t Node::Builder::getDisplayNamePrefixLength() {
  return _builder.getDataField< ::uint32_t>(
      5 * ::capnp::ELEMENTS);
}
inline void Node::Builder::setDisplayNamePrefixLength( ::uint32_t value) {
  _builder.setDataField< ::uint32_t>(
      5 * ::capnp::ELEMENTS, value);
}

inline bool Node::NestedNode::Reader::hasName() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool Node::NestedNode::Builder::hasName() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Reader Node::NestedNode::Reader::getName() const {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Builder Node::NestedNode::Builder::getName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void Node::NestedNode::Builder::setName( ::capnp::Text::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::Text::Builder Node::NestedNode::Builder::initName(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void Node::NestedNode::Builder::adoptName(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> Node::NestedNode::Builder::disownName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline  ::uint64_t Node::NestedNode::Reader::getId() const {
  return _reader.getDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Node::NestedNode::Builder::getId() {
  return _builder.getDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS);
}
inline void Node::NestedNode::Builder::setId( ::uint64_t value) {
  _builder.setDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline Type::Body::Reader Type::Reader::getBody() const {
  return Type::Body::Reader(_reader);
}
inline Type::Body::Builder Type::Builder::getBody() {
  return Type::Body::Builder(_builder);
}
inline Type::Body::Which Type::Body::Reader::which() const {
  return _reader.getDataField<Which>(0 * ::capnp::ELEMENTS);
}
inline Type::Body::Which Type::Body::Builder::which() {
  return _builder.getDataField<Which>(0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Reader::getVoidType() const {
  KJ_IREQUIRE(which() == Body::VOID_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getVoidType() {
  KJ_IREQUIRE(which() == Body::VOID_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setVoidType( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::VOID_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getBoolType() const {
  KJ_IREQUIRE(which() == Body::BOOL_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getBoolType() {
  KJ_IREQUIRE(which() == Body::BOOL_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setBoolType( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::BOOL_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getInt8Type() const {
  KJ_IREQUIRE(which() == Body::INT8_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getInt8Type() {
  KJ_IREQUIRE(which() == Body::INT8_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setInt8Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INT8_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getInt16Type() const {
  KJ_IREQUIRE(which() == Body::INT16_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getInt16Type() {
  KJ_IREQUIRE(which() == Body::INT16_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setInt16Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INT16_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getInt32Type() const {
  KJ_IREQUIRE(which() == Body::INT32_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getInt32Type() {
  KJ_IREQUIRE(which() == Body::INT32_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setInt32Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INT32_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getInt64Type() const {
  KJ_IREQUIRE(which() == Body::INT64_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getInt64Type() {
  KJ_IREQUIRE(which() == Body::INT64_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setInt64Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INT64_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getUint8Type() const {
  KJ_IREQUIRE(which() == Body::UINT8_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getUint8Type() {
  KJ_IREQUIRE(which() == Body::UINT8_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setUint8Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::UINT8_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getUint16Type() const {
  KJ_IREQUIRE(which() == Body::UINT16_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getUint16Type() {
  KJ_IREQUIRE(which() == Body::UINT16_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setUint16Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::UINT16_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getUint32Type() const {
  KJ_IREQUIRE(which() == Body::UINT32_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getUint32Type() {
  KJ_IREQUIRE(which() == Body::UINT32_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setUint32Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::UINT32_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getUint64Type() const {
  KJ_IREQUIRE(which() == Body::UINT64_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getUint64Type() {
  KJ_IREQUIRE(which() == Body::UINT64_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setUint64Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::UINT64_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getFloat32Type() const {
  KJ_IREQUIRE(which() == Body::FLOAT32_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getFloat32Type() {
  KJ_IREQUIRE(which() == Body::FLOAT32_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setFloat32Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::FLOAT32_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getFloat64Type() const {
  KJ_IREQUIRE(which() == Body::FLOAT64_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getFloat64Type() {
  KJ_IREQUIRE(which() == Body::FLOAT64_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setFloat64Type( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::FLOAT64_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getTextType() const {
  KJ_IREQUIRE(which() == Body::TEXT_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getTextType() {
  KJ_IREQUIRE(which() == Body::TEXT_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setTextType( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::TEXT_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getDataType() const {
  KJ_IREQUIRE(which() == Body::DATA_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getDataType() {
  KJ_IREQUIRE(which() == Body::DATA_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setDataType( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::DATA_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool Type::Body::Reader::hasListType() const {
  KJ_IREQUIRE(which() == Body::LIST_TYPE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool Type::Body::Builder::hasListType() {
  KJ_IREQUIRE(which() == Body::LIST_TYPE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Reader Type::Body::Reader::getListType() const {
  KJ_IREQUIRE(which() == Body::LIST_TYPE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Builder Type::Body::Builder::getListType() {
  KJ_IREQUIRE(which() == Body::LIST_TYPE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void Type::Body::Builder::setListType( ::capnp::schema::Type::Reader value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::LIST_TYPE);
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Type::Builder Type::Body::Builder::initListType() {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::LIST_TYPE);
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::init(
      _builder, 0 * ::capnp::POINTERS);
}
inline void Type::Body::Builder::adoptListType(
    ::capnp::Orphan< ::capnp::schema::Type>&& value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::LIST_TYPE);
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Type> Type::Body::Builder::disownListType() {
  KJ_IREQUIRE(which() == Body::LIST_TYPE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline  ::uint64_t Type::Body::Reader::getEnumType() const {
  KJ_IREQUIRE(which() == Body::ENUM_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Type::Body::Builder::getEnumType() {
  KJ_IREQUIRE(which() == Body::ENUM_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setEnumType( ::uint64_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::ENUM_TYPE);
  _builder.setDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline  ::uint64_t Type::Body::Reader::getStructType() const {
  KJ_IREQUIRE(which() == Body::STRUCT_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Type::Body::Builder::getStructType() {
  KJ_IREQUIRE(which() == Body::STRUCT_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setStructType( ::uint64_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::STRUCT_TYPE);
  _builder.setDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline  ::uint64_t Type::Body::Reader::getInterfaceType() const {
  KJ_IREQUIRE(which() == Body::INTERFACE_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Type::Body::Builder::getInterfaceType() {
  KJ_IREQUIRE(which() == Body::INTERFACE_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setInterfaceType( ::uint64_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INTERFACE_TYPE);
  _builder.setDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Type::Body::Reader::getObjectType() const {
  KJ_IREQUIRE(which() == Body::OBJECT_TYPE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Type::Body::Builder::getObjectType() {
  KJ_IREQUIRE(which() == Body::OBJECT_TYPE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Type::Body::Builder::setObjectType( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::OBJECT_TYPE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline Value::Body::Reader Value::Reader::getBody() const {
  return Value::Body::Reader(_reader);
}
inline Value::Body::Builder Value::Builder::getBody() {
  return Value::Body::Builder(_builder);
}
inline Value::Body::Which Value::Body::Reader::which() const {
  return _reader.getDataField<Which>(0 * ::capnp::ELEMENTS);
}
inline Value::Body::Which Value::Body::Builder::which() {
  return _builder.getDataField<Which>(0 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Value::Body::Reader::getUint64Value() const {
  KJ_IREQUIRE(which() == Body::UINT64_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Value::Body::Builder::getUint64Value() {
  KJ_IREQUIRE(which() == Body::UINT64_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setUint64Value( ::uint64_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::UINT64_VALUE);
  _builder.setDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline bool Value::Body::Reader::getBoolValue() const {
  KJ_IREQUIRE(which() == Body::BOOL_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField<bool>(
      64 * ::capnp::ELEMENTS);
}

inline bool Value::Body::Builder::getBoolValue() {
  KJ_IREQUIRE(which() == Body::BOOL_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField<bool>(
      64 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setBoolValue(bool value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::BOOL_VALUE);
  _builder.setDataField<bool>(
      64 * ::capnp::ELEMENTS, value);
}

inline  ::int8_t Value::Body::Reader::getInt8Value() const {
  KJ_IREQUIRE(which() == Body::INT8_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::int8_t>(
      8 * ::capnp::ELEMENTS);
}

inline  ::int8_t Value::Body::Builder::getInt8Value() {
  KJ_IREQUIRE(which() == Body::INT8_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::int8_t>(
      8 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setInt8Value( ::int8_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INT8_VALUE);
  _builder.setDataField< ::int8_t>(
      8 * ::capnp::ELEMENTS, value);
}

inline  ::int16_t Value::Body::Reader::getInt16Value() const {
  KJ_IREQUIRE(which() == Body::INT16_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::int16_t>(
      4 * ::capnp::ELEMENTS);
}

inline  ::int16_t Value::Body::Builder::getInt16Value() {
  KJ_IREQUIRE(which() == Body::INT16_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::int16_t>(
      4 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setInt16Value( ::int16_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INT16_VALUE);
  _builder.setDataField< ::int16_t>(
      4 * ::capnp::ELEMENTS, value);
}

inline  ::int32_t Value::Body::Reader::getInt32Value() const {
  KJ_IREQUIRE(which() == Body::INT32_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::int32_t>(
      2 * ::capnp::ELEMENTS);
}

inline  ::int32_t Value::Body::Builder::getInt32Value() {
  KJ_IREQUIRE(which() == Body::INT32_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::int32_t>(
      2 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setInt32Value( ::int32_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INT32_VALUE);
  _builder.setDataField< ::int32_t>(
      2 * ::capnp::ELEMENTS, value);
}

inline  ::int64_t Value::Body::Reader::getInt64Value() const {
  KJ_IREQUIRE(which() == Body::INT64_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::int64_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::int64_t Value::Body::Builder::getInt64Value() {
  KJ_IREQUIRE(which() == Body::INT64_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::int64_t>(
      1 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setInt64Value( ::int64_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INT64_VALUE);
  _builder.setDataField< ::int64_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline  ::uint8_t Value::Body::Reader::getUint8Value() const {
  KJ_IREQUIRE(which() == Body::UINT8_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::uint8_t>(
      8 * ::capnp::ELEMENTS);
}

inline  ::uint8_t Value::Body::Builder::getUint8Value() {
  KJ_IREQUIRE(which() == Body::UINT8_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::uint8_t>(
      8 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setUint8Value( ::uint8_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::UINT8_VALUE);
  _builder.setDataField< ::uint8_t>(
      8 * ::capnp::ELEMENTS, value);
}

inline  ::uint16_t Value::Body::Reader::getUint16Value() const {
  KJ_IREQUIRE(which() == Body::UINT16_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::uint16_t>(
      4 * ::capnp::ELEMENTS);
}

inline  ::uint16_t Value::Body::Builder::getUint16Value() {
  KJ_IREQUIRE(which() == Body::UINT16_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::uint16_t>(
      4 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setUint16Value( ::uint16_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::UINT16_VALUE);
  _builder.setDataField< ::uint16_t>(
      4 * ::capnp::ELEMENTS, value);
}

inline  ::uint32_t Value::Body::Reader::getUint32Value() const {
  KJ_IREQUIRE(which() == Body::UINT32_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::uint32_t>(
      2 * ::capnp::ELEMENTS);
}

inline  ::uint32_t Value::Body::Builder::getUint32Value() {
  KJ_IREQUIRE(which() == Body::UINT32_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::uint32_t>(
      2 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setUint32Value( ::uint32_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::UINT32_VALUE);
  _builder.setDataField< ::uint32_t>(
      2 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::Void Value::Body::Reader::getVoidValue() const {
  KJ_IREQUIRE(which() == Body::VOID_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Value::Body::Builder::getVoidValue() {
  KJ_IREQUIRE(which() == Body::VOID_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setVoidValue( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::VOID_VALUE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline float Value::Body::Reader::getFloat32Value() const {
  KJ_IREQUIRE(which() == Body::FLOAT32_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField<float>(
      2 * ::capnp::ELEMENTS);
}

inline float Value::Body::Builder::getFloat32Value() {
  KJ_IREQUIRE(which() == Body::FLOAT32_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField<float>(
      2 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setFloat32Value(float value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::FLOAT32_VALUE);
  _builder.setDataField<float>(
      2 * ::capnp::ELEMENTS, value);
}

inline double Value::Body::Reader::getFloat64Value() const {
  KJ_IREQUIRE(which() == Body::FLOAT64_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField<double>(
      1 * ::capnp::ELEMENTS);
}

inline double Value::Body::Builder::getFloat64Value() {
  KJ_IREQUIRE(which() == Body::FLOAT64_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField<double>(
      1 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setFloat64Value(double value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::FLOAT64_VALUE);
  _builder.setDataField<double>(
      1 * ::capnp::ELEMENTS, value);
}

inline bool Value::Body::Reader::hasTextValue() const {
  KJ_IREQUIRE(which() == Body::TEXT_VALUE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool Value::Body::Builder::hasTextValue() {
  KJ_IREQUIRE(which() == Body::TEXT_VALUE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Reader Value::Body::Reader::getTextValue() const {
  KJ_IREQUIRE(which() == Body::TEXT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Builder Value::Body::Builder::getTextValue() {
  KJ_IREQUIRE(which() == Body::TEXT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void Value::Body::Builder::setTextValue( ::capnp::Text::Reader value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::TEXT_VALUE);
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::Text::Builder Value::Body::Builder::initTextValue(unsigned int size) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::TEXT_VALUE);
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void Value::Body::Builder::adoptTextValue(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::TEXT_VALUE);
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> Value::Body::Builder::disownTextValue() {
  KJ_IREQUIRE(which() == Body::TEXT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool Value::Body::Reader::hasDataValue() const {
  KJ_IREQUIRE(which() == Body::DATA_VALUE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool Value::Body::Builder::hasDataValue() {
  KJ_IREQUIRE(which() == Body::DATA_VALUE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::Data::Reader Value::Body::Reader::getDataValue() const {
  KJ_IREQUIRE(which() == Body::DATA_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Data>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::Data::Builder Value::Body::Builder::getDataValue() {
  KJ_IREQUIRE(which() == Body::DATA_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Data>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void Value::Body::Builder::setDataValue( ::capnp::Data::Reader value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::DATA_VALUE);
  ::capnp::_::PointerHelpers< ::capnp::Data>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::Data::Builder Value::Body::Builder::initDataValue(unsigned int size) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::DATA_VALUE);
  return ::capnp::_::PointerHelpers< ::capnp::Data>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void Value::Body::Builder::adoptDataValue(
    ::capnp::Orphan< ::capnp::Data>&& value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::DATA_VALUE);
  ::capnp::_::PointerHelpers< ::capnp::Data>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Data> Value::Body::Builder::disownDataValue() {
  KJ_IREQUIRE(which() == Body::DATA_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Data>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool Value::Body::Reader::hasListValue() const {
  KJ_IREQUIRE(which() == Body::LIST_VALUE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool Value::Body::Builder::hasListValue() {
  KJ_IREQUIRE(which() == Body::LIST_VALUE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
template <typename T>
inline typename T::Reader Value::Body::Reader::getListValue() const {
  KJ_IREQUIRE(which() == Body::LIST_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::get(
      _reader, 0 * ::capnp::POINTERS);
}
template <typename T>
inline typename T::Builder Value::Body::Builder::getListValue() {
  KJ_IREQUIRE(which() == Body::LIST_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::get(
      _builder, 0 * ::capnp::POINTERS);
}
template <typename T, typename Param>
inline typename T::Reader Value::Body::Reader::getListValue(Param&& param) const {
  KJ_IREQUIRE(which() == Body::LIST_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::getDynamic(
      _reader, 0 * ::capnp::POINTERS, ::kj::fwd<Param>(param));
}
template <typename T, typename Param>
inline typename T::Builder Value::Body::Builder::getListValue(Param&& param) {
  KJ_IREQUIRE(which() == Body::LIST_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::getDynamic(
      _builder, 0 * ::capnp::POINTERS, ::kj::fwd<Param>(param));
}
template <typename T>
inline void Value::Body::Builder::setListValue(typename T::Reader value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::LIST_VALUE);
  ::capnp::_::PointerHelpers<T>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
template <typename T, typename U>inline void Value::Body::Builder::setListValue(std::initializer_list<U> value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::LIST_VALUE);
  ::capnp::_::PointerHelpers<T>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
template <typename T, typename... Params>
inline typename T::Builder Value::Body::Builder::initListValue(Params&&... params) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::LIST_VALUE);
  return ::capnp::_::PointerHelpers<T>::init(
      _builder, 0 * ::capnp::POINTERS, ::kj::fwd<Params>(params)...);
}
template <typename T>
inline void Value::Body::Builder::adoptListValue(::capnp::Orphan<T>&& value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::LIST_VALUE);
  ::capnp::_::PointerHelpers<T>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
template <typename T, typename... Params>
inline ::capnp::Orphan<T> Value::Body::Builder::disownListValue(Params&&... params) {
  KJ_IREQUIRE(which() == Body::LIST_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::disown(
      _builder, 0 * ::capnp::POINTERS, ::kj::fwd<Params>(params)...);
}

inline  ::uint16_t Value::Body::Reader::getEnumValue() const {
  KJ_IREQUIRE(which() == Body::ENUM_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::uint16_t>(
      4 * ::capnp::ELEMENTS);
}

inline  ::uint16_t Value::Body::Builder::getEnumValue() {
  KJ_IREQUIRE(which() == Body::ENUM_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::uint16_t>(
      4 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setEnumValue( ::uint16_t value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::ENUM_VALUE);
  _builder.setDataField< ::uint16_t>(
      4 * ::capnp::ELEMENTS, value);
}

inline bool Value::Body::Reader::hasStructValue() const {
  KJ_IREQUIRE(which() == Body::STRUCT_VALUE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool Value::Body::Builder::hasStructValue() {
  KJ_IREQUIRE(which() == Body::STRUCT_VALUE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
template <typename T>
inline typename T::Reader Value::Body::Reader::getStructValue() const {
  KJ_IREQUIRE(which() == Body::STRUCT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::get(
      _reader, 0 * ::capnp::POINTERS);
}
template <typename T>
inline typename T::Builder Value::Body::Builder::getStructValue() {
  KJ_IREQUIRE(which() == Body::STRUCT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::get(
      _builder, 0 * ::capnp::POINTERS);
}
template <typename T, typename Param>
inline typename T::Reader Value::Body::Reader::getStructValue(Param&& param) const {
  KJ_IREQUIRE(which() == Body::STRUCT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::getDynamic(
      _reader, 0 * ::capnp::POINTERS, ::kj::fwd<Param>(param));
}
template <typename T, typename Param>
inline typename T::Builder Value::Body::Builder::getStructValue(Param&& param) {
  KJ_IREQUIRE(which() == Body::STRUCT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::getDynamic(
      _builder, 0 * ::capnp::POINTERS, ::kj::fwd<Param>(param));
}
template <typename T>
inline void Value::Body::Builder::setStructValue(typename T::Reader value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::STRUCT_VALUE);
  ::capnp::_::PointerHelpers<T>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
template <typename T, typename U>inline void Value::Body::Builder::setStructValue(std::initializer_list<U> value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::STRUCT_VALUE);
  ::capnp::_::PointerHelpers<T>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
template <typename T, typename... Params>
inline typename T::Builder Value::Body::Builder::initStructValue(Params&&... params) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::STRUCT_VALUE);
  return ::capnp::_::PointerHelpers<T>::init(
      _builder, 0 * ::capnp::POINTERS, ::kj::fwd<Params>(params)...);
}
template <typename T>
inline void Value::Body::Builder::adoptStructValue(::capnp::Orphan<T>&& value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::STRUCT_VALUE);
  ::capnp::_::PointerHelpers<T>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
template <typename T, typename... Params>
inline ::capnp::Orphan<T> Value::Body::Builder::disownStructValue(Params&&... params) {
  KJ_IREQUIRE(which() == Body::STRUCT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::disown(
      _builder, 0 * ::capnp::POINTERS, ::kj::fwd<Params>(params)...);
}

inline  ::capnp::Void Value::Body::Reader::getInterfaceValue() const {
  KJ_IREQUIRE(which() == Body::INTERFACE_VALUE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Value::Body::Builder::getInterfaceValue() {
  KJ_IREQUIRE(which() == Body::INTERFACE_VALUE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Value::Body::Builder::setInterfaceValue( ::capnp::Void value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::INTERFACE_VALUE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool Value::Body::Reader::hasObjectValue() const {
  KJ_IREQUIRE(which() == Body::OBJECT_VALUE,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool Value::Body::Builder::hasObjectValue() {
  KJ_IREQUIRE(which() == Body::OBJECT_VALUE,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
template <typename T>
inline typename T::Reader Value::Body::Reader::getObjectValue() const {
  KJ_IREQUIRE(which() == Body::OBJECT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::get(
      _reader, 0 * ::capnp::POINTERS);
}
template <typename T>
inline typename T::Builder Value::Body::Builder::getObjectValue() {
  KJ_IREQUIRE(which() == Body::OBJECT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::get(
      _builder, 0 * ::capnp::POINTERS);
}
template <typename T, typename Param>
inline typename T::Reader Value::Body::Reader::getObjectValue(Param&& param) const {
  KJ_IREQUIRE(which() == Body::OBJECT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::getDynamic(
      _reader, 0 * ::capnp::POINTERS, ::kj::fwd<Param>(param));
}
template <typename T, typename Param>
inline typename T::Builder Value::Body::Builder::getObjectValue(Param&& param) {
  KJ_IREQUIRE(which() == Body::OBJECT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::getDynamic(
      _builder, 0 * ::capnp::POINTERS, ::kj::fwd<Param>(param));
}
template <typename T>
inline void Value::Body::Builder::setObjectValue(typename T::Reader value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::OBJECT_VALUE);
  ::capnp::_::PointerHelpers<T>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
template <typename T, typename U>inline void Value::Body::Builder::setObjectValue(std::initializer_list<U> value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::OBJECT_VALUE);
  ::capnp::_::PointerHelpers<T>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
template <typename T, typename... Params>
inline typename T::Builder Value::Body::Builder::initObjectValue(Params&&... params) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::OBJECT_VALUE);
  return ::capnp::_::PointerHelpers<T>::init(
      _builder, 0 * ::capnp::POINTERS, ::kj::fwd<Params>(params)...);
}
template <typename T>
inline void Value::Body::Builder::adoptObjectValue(::capnp::Orphan<T>&& value) {
  _builder.setDataField<Body::Which>(
      0 * ::capnp::ELEMENTS, Body::OBJECT_VALUE);
  ::capnp::_::PointerHelpers<T>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
template <typename T, typename... Params>
inline ::capnp::Orphan<T> Value::Body::Builder::disownObjectValue(Params&&... params) {
  KJ_IREQUIRE(which() == Body::OBJECT_VALUE,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers<T>::disown(
      _builder, 0 * ::capnp::POINTERS, ::kj::fwd<Params>(params)...);
}

inline  ::uint64_t Annotation::Reader::getId() const {
  return _reader.getDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Annotation::Builder::getId() {
  return _builder.getDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS);
}
inline void Annotation::Builder::setId( ::uint64_t value) {
  _builder.setDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool Annotation::Reader::hasValue() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool Annotation::Builder::hasValue() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Value::Reader Annotation::Reader::getValue() const {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Value::Builder Annotation::Builder::getValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void Annotation::Builder::setValue( ::capnp::schema::Value::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Value>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Value::Builder Annotation::Builder::initValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::init(
      _builder, 0 * ::capnp::POINTERS);
}
inline void Annotation::Builder::adoptValue(
    ::capnp::Orphan< ::capnp::schema::Value>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Value>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Value> Annotation::Builder::disownValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool FileNode::Reader::hasImports() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool FileNode::Builder::hasImports() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::FileNode::Import>::Reader FileNode::Reader::getImports() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::FileNode::Import>>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::FileNode::Import>::Builder FileNode::Builder::getImports() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::FileNode::Import>>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void FileNode::Builder::setImports( ::capnp::List< ::capnp::schema::FileNode::Import>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::FileNode::Import>>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::FileNode::Import>::Builder FileNode::Builder::initImports(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::FileNode::Import>>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void FileNode::Builder::adoptImports(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::FileNode::Import>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::FileNode::Import>>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::FileNode::Import>> FileNode::Builder::disownImports() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::FileNode::Import>>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline  ::uint64_t FileNode::Import::Reader::getId() const {
  return _reader.getDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint64_t FileNode::Import::Builder::getId() {
  return _builder.getDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS);
}
inline void FileNode::Import::Builder::setId( ::uint64_t value) {
  _builder.setDataField< ::uint64_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool FileNode::Import::Reader::hasName() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool FileNode::Import::Builder::hasName() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Reader FileNode::Import::Reader::getName() const {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Builder FileNode::Import::Builder::getName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void FileNode::Import::Builder::setName( ::capnp::Text::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::Text::Builder FileNode::Import::Builder::initName(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void FileNode::Import::Builder::adoptName(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> FileNode::Import::Builder::disownName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline  ::uint16_t StructNode::Reader::getDataSectionWordSize() const {
  return _reader.getDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint16_t StructNode::Builder::getDataSectionWordSize() {
  return _builder.getDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS);
}
inline void StructNode::Builder::setDataSectionWordSize( ::uint16_t value) {
  _builder.setDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::uint16_t StructNode::Reader::getPointerSectionSize() const {
  return _reader.getDataField< ::uint16_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint16_t StructNode::Builder::getPointerSectionSize() {
  return _builder.getDataField< ::uint16_t>(
      1 * ::capnp::ELEMENTS);
}
inline void StructNode::Builder::setPointerSectionSize( ::uint16_t value) {
  _builder.setDataField< ::uint16_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline  ::capnp::schema::ElementSize StructNode::Reader::getPreferredListEncoding() const {
  return _reader.getDataField< ::capnp::schema::ElementSize>(
      2 * ::capnp::ELEMENTS);
}

inline  ::capnp::schema::ElementSize StructNode::Builder::getPreferredListEncoding() {
  return _builder.getDataField< ::capnp::schema::ElementSize>(
      2 * ::capnp::ELEMENTS);
}
inline void StructNode::Builder::setPreferredListEncoding( ::capnp::schema::ElementSize value) {
  _builder.setDataField< ::capnp::schema::ElementSize>(
      2 * ::capnp::ELEMENTS, value);
}

inline bool StructNode::Reader::hasMembers() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool StructNode::Builder::hasMembers() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Reader StructNode::Reader::getMembers() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder StructNode::Builder::getMembers() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void StructNode::Builder::setMembers( ::capnp::List< ::capnp::schema::StructNode::Member>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder StructNode::Builder::initMembers(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void StructNode::Builder::adoptMembers(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>> StructNode::Builder::disownMembers() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool StructNode::Member::Reader::hasName() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool StructNode::Member::Builder::hasName() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Reader StructNode::Member::Reader::getName() const {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Builder StructNode::Member::Builder::getName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void StructNode::Member::Builder::setName( ::capnp::Text::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::Text::Builder StructNode::Member::Builder::initName(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void StructNode::Member::Builder::adoptName(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> StructNode::Member::Builder::disownName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline  ::uint16_t StructNode::Member::Reader::getOrdinal() const {
  return _reader.getDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint16_t StructNode::Member::Builder::getOrdinal() {
  return _builder.getDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS);
}
inline void StructNode::Member::Builder::setOrdinal( ::uint16_t value) {
  _builder.setDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline  ::uint16_t StructNode::Member::Reader::getCodeOrder() const {
  return _reader.getDataField< ::uint16_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint16_t StructNode::Member::Builder::getCodeOrder() {
  return _builder.getDataField< ::uint16_t>(
      1 * ::capnp::ELEMENTS);
}
inline void StructNode::Member::Builder::setCodeOrder( ::uint16_t value) {
  _builder.setDataField< ::uint16_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline bool StructNode::Member::Reader::hasAnnotations() const {
  return !_reader.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline bool StructNode::Member::Builder::hasAnnotations() {
  return !_builder.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Reader StructNode::Member::Reader::getAnnotations() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _reader, 1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder StructNode::Member::Builder::getAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _builder, 1 * ::capnp::POINTERS);
}
inline void StructNode::Member::Builder::setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::set(
      _builder, 1 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder StructNode::Member::Builder::initAnnotations(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::init(
      _builder, 1 * ::capnp::POINTERS, size);
}
inline void StructNode::Member::Builder::adoptAnnotations(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::adopt(
      _builder, 1 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> StructNode::Member::Builder::disownAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::disown(
      _builder, 1 * ::capnp::POINTERS);
}

inline StructNode::Member::Body::Reader StructNode::Member::Reader::getBody() const {
  return StructNode::Member::Body::Reader(_reader);
}
inline StructNode::Member::Body::Builder StructNode::Member::Builder::getBody() {
  return StructNode::Member::Body::Builder(_builder);
}
inline StructNode::Member::Body::Which StructNode::Member::Body::Reader::which() const {
  return _reader.getDataField<Which>(2 * ::capnp::ELEMENTS);
}
inline StructNode::Member::Body::Which StructNode::Member::Body::Builder::which() {
  return _builder.getDataField<Which>(2 * ::capnp::ELEMENTS);
}

inline bool StructNode::Member::Body::Reader::hasFieldMember() const {
  KJ_IREQUIRE(which() == Body::FIELD_MEMBER,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline bool StructNode::Member::Body::Builder::hasFieldMember() {
  KJ_IREQUIRE(which() == Body::FIELD_MEMBER,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::StructNode::Field::Reader StructNode::Member::Body::Reader::getFieldMember() const {
  KJ_IREQUIRE(which() == Body::FIELD_MEMBER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Field>::get(
      _reader, 2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::StructNode::Field::Builder StructNode::Member::Body::Builder::getFieldMember() {
  KJ_IREQUIRE(which() == Body::FIELD_MEMBER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Field>::get(
      _builder, 2 * ::capnp::POINTERS);
}
inline void StructNode::Member::Body::Builder::setFieldMember( ::capnp::schema::StructNode::Field::Reader value) {
  _builder.setDataField<Body::Which>(
      2 * ::capnp::ELEMENTS, Body::FIELD_MEMBER);
  ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Field>::set(
      _builder, 2 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::StructNode::Field::Builder StructNode::Member::Body::Builder::initFieldMember() {
  _builder.setDataField<Body::Which>(
      2 * ::capnp::ELEMENTS, Body::FIELD_MEMBER);
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Field>::init(
      _builder, 2 * ::capnp::POINTERS);
}
inline void StructNode::Member::Body::Builder::adoptFieldMember(
    ::capnp::Orphan< ::capnp::schema::StructNode::Field>&& value) {
  _builder.setDataField<Body::Which>(
      2 * ::capnp::ELEMENTS, Body::FIELD_MEMBER);
  ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Field>::adopt(
      _builder, 2 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::StructNode::Field> StructNode::Member::Body::Builder::disownFieldMember() {
  KJ_IREQUIRE(which() == Body::FIELD_MEMBER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Field>::disown(
      _builder, 2 * ::capnp::POINTERS);
}

inline bool StructNode::Member::Body::Reader::hasUnionMember() const {
  KJ_IREQUIRE(which() == Body::UNION_MEMBER,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline bool StructNode::Member::Body::Builder::hasUnionMember() {
  KJ_IREQUIRE(which() == Body::UNION_MEMBER,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::StructNode::Union::Reader StructNode::Member::Body::Reader::getUnionMember() const {
  KJ_IREQUIRE(which() == Body::UNION_MEMBER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Union>::get(
      _reader, 2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::StructNode::Union::Builder StructNode::Member::Body::Builder::getUnionMember() {
  KJ_IREQUIRE(which() == Body::UNION_MEMBER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Union>::get(
      _builder, 2 * ::capnp::POINTERS);
}
inline void StructNode::Member::Body::Builder::setUnionMember( ::capnp::schema::StructNode::Union::Reader value) {
  _builder.setDataField<Body::Which>(
      2 * ::capnp::ELEMENTS, Body::UNION_MEMBER);
  ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Union>::set(
      _builder, 2 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::StructNode::Union::Builder StructNode::Member::Body::Builder::initUnionMember() {
  _builder.setDataField<Body::Which>(
      2 * ::capnp::ELEMENTS, Body::UNION_MEMBER);
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Union>::init(
      _builder, 2 * ::capnp::POINTERS);
}
inline void StructNode::Member::Body::Builder::adoptUnionMember(
    ::capnp::Orphan< ::capnp::schema::StructNode::Union>&& value) {
  _builder.setDataField<Body::Which>(
      2 * ::capnp::ELEMENTS, Body::UNION_MEMBER);
  ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Union>::adopt(
      _builder, 2 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::StructNode::Union> StructNode::Member::Body::Builder::disownUnionMember() {
  KJ_IREQUIRE(which() == Body::UNION_MEMBER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Union>::disown(
      _builder, 2 * ::capnp::POINTERS);
}

inline bool StructNode::Member::Body::Reader::hasGroupMember() const {
  KJ_IREQUIRE(which() == Body::GROUP_MEMBER,
              "Must check which() before get()ing a union member.");
  return !_reader.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline bool StructNode::Member::Body::Builder::hasGroupMember() {
  KJ_IREQUIRE(which() == Body::GROUP_MEMBER,
              "Must check which() before get()ing a union member.");
  return !_builder.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::StructNode::Group::Reader StructNode::Member::Body::Reader::getGroupMember() const {
  KJ_IREQUIRE(which() == Body::GROUP_MEMBER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Group>::get(
      _reader, 2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::StructNode::Group::Builder StructNode::Member::Body::Builder::getGroupMember() {
  KJ_IREQUIRE(which() == Body::GROUP_MEMBER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Group>::get(
      _builder, 2 * ::capnp::POINTERS);
}
inline void StructNode::Member::Body::Builder::setGroupMember( ::capnp::schema::StructNode::Group::Reader value) {
  _builder.setDataField<Body::Which>(
      2 * ::capnp::ELEMENTS, Body::GROUP_MEMBER);
  ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Group>::set(
      _builder, 2 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::StructNode::Group::Builder StructNode::Member::Body::Builder::initGroupMember() {
  _builder.setDataField<Body::Which>(
      2 * ::capnp::ELEMENTS, Body::GROUP_MEMBER);
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Group>::init(
      _builder, 2 * ::capnp::POINTERS);
}
inline void StructNode::Member::Body::Builder::adoptGroupMember(
    ::capnp::Orphan< ::capnp::schema::StructNode::Group>&& value) {
  _builder.setDataField<Body::Which>(
      2 * ::capnp::ELEMENTS, Body::GROUP_MEMBER);
  ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Group>::adopt(
      _builder, 2 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::StructNode::Group> StructNode::Member::Body::Builder::disownGroupMember() {
  KJ_IREQUIRE(which() == Body::GROUP_MEMBER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::schema::StructNode::Group>::disown(
      _builder, 2 * ::capnp::POINTERS);
}

inline  ::uint32_t StructNode::Field::Reader::getOffset() const {
  return _reader.getDataField< ::uint32_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint32_t StructNode::Field::Builder::getOffset() {
  return _builder.getDataField< ::uint32_t>(
      0 * ::capnp::ELEMENTS);
}
inline void StructNode::Field::Builder::setOffset( ::uint32_t value) {
  _builder.setDataField< ::uint32_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool StructNode::Field::Reader::hasType() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool StructNode::Field::Builder::hasType() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Reader StructNode::Field::Reader::getType() const {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Builder StructNode::Field::Builder::getType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void StructNode::Field::Builder::setType( ::capnp::schema::Type::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Type::Builder StructNode::Field::Builder::initType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::init(
      _builder, 0 * ::capnp::POINTERS);
}
inline void StructNode::Field::Builder::adoptType(
    ::capnp::Orphan< ::capnp::schema::Type>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Type> StructNode::Field::Builder::disownType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool StructNode::Field::Reader::hasDefaultValue() const {
  return !_reader.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline bool StructNode::Field::Builder::hasDefaultValue() {
  return !_builder.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Value::Reader StructNode::Field::Reader::getDefaultValue() const {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::get(
      _reader, 1 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Value::Builder StructNode::Field::Builder::getDefaultValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::get(
      _builder, 1 * ::capnp::POINTERS);
}
inline void StructNode::Field::Builder::setDefaultValue( ::capnp::schema::Value::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Value>::set(
      _builder, 1 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Value::Builder StructNode::Field::Builder::initDefaultValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::init(
      _builder, 1 * ::capnp::POINTERS);
}
inline void StructNode::Field::Builder::adoptDefaultValue(
    ::capnp::Orphan< ::capnp::schema::Value>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Value>::adopt(
      _builder, 1 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Value> StructNode::Field::Builder::disownDefaultValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::disown(
      _builder, 1 * ::capnp::POINTERS);
}

inline  ::uint32_t StructNode::Union::Reader::getDiscriminantOffset() const {
  return _reader.getDataField< ::uint32_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint32_t StructNode::Union::Builder::getDiscriminantOffset() {
  return _builder.getDataField< ::uint32_t>(
      0 * ::capnp::ELEMENTS);
}
inline void StructNode::Union::Builder::setDiscriminantOffset( ::uint32_t value) {
  _builder.setDataField< ::uint32_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool StructNode::Union::Reader::hasMembers() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool StructNode::Union::Builder::hasMembers() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Reader StructNode::Union::Reader::getMembers() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder StructNode::Union::Builder::getMembers() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void StructNode::Union::Builder::setMembers( ::capnp::List< ::capnp::schema::StructNode::Member>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder StructNode::Union::Builder::initMembers(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void StructNode::Union::Builder::adoptMembers(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>> StructNode::Union::Builder::disownMembers() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool StructNode::Group::Reader::hasMembers() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool StructNode::Group::Builder::hasMembers() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Reader StructNode::Group::Reader::getMembers() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder StructNode::Group::Builder::getMembers() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void StructNode::Group::Builder::setMembers( ::capnp::List< ::capnp::schema::StructNode::Member>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::StructNode::Member>::Builder StructNode::Group::Builder::initMembers(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void StructNode::Group::Builder::adoptMembers(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::StructNode::Member>> StructNode::Group::Builder::disownMembers() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::StructNode::Member>>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool EnumNode::Reader::hasEnumerants() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool EnumNode::Builder::hasEnumerants() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::EnumNode::Enumerant>::Reader EnumNode::Reader::getEnumerants() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::EnumNode::Enumerant>::Builder EnumNode::Builder::getEnumerants() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void EnumNode::Builder::setEnumerants( ::capnp::List< ::capnp::schema::EnumNode::Enumerant>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::EnumNode::Enumerant>::Builder EnumNode::Builder::initEnumerants(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void EnumNode::Builder::adoptEnumerants(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>> EnumNode::Builder::disownEnumerants() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::EnumNode::Enumerant>>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool EnumNode::Enumerant::Reader::hasName() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool EnumNode::Enumerant::Builder::hasName() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Reader EnumNode::Enumerant::Reader::getName() const {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Builder EnumNode::Enumerant::Builder::getName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void EnumNode::Enumerant::Builder::setName( ::capnp::Text::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::Text::Builder EnumNode::Enumerant::Builder::initName(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void EnumNode::Enumerant::Builder::adoptName(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> EnumNode::Enumerant::Builder::disownName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline  ::uint16_t EnumNode::Enumerant::Reader::getCodeOrder() const {
  return _reader.getDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint16_t EnumNode::Enumerant::Builder::getCodeOrder() {
  return _builder.getDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS);
}
inline void EnumNode::Enumerant::Builder::setCodeOrder( ::uint16_t value) {
  _builder.setDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool EnumNode::Enumerant::Reader::hasAnnotations() const {
  return !_reader.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline bool EnumNode::Enumerant::Builder::hasAnnotations() {
  return !_builder.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Reader EnumNode::Enumerant::Reader::getAnnotations() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _reader, 1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder EnumNode::Enumerant::Builder::getAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _builder, 1 * ::capnp::POINTERS);
}
inline void EnumNode::Enumerant::Builder::setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::set(
      _builder, 1 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder EnumNode::Enumerant::Builder::initAnnotations(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::init(
      _builder, 1 * ::capnp::POINTERS, size);
}
inline void EnumNode::Enumerant::Builder::adoptAnnotations(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::adopt(
      _builder, 1 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> EnumNode::Enumerant::Builder::disownAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::disown(
      _builder, 1 * ::capnp::POINTERS);
}

inline bool InterfaceNode::Reader::hasMethods() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool InterfaceNode::Builder::hasMethods() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method>::Reader InterfaceNode::Reader::getMethods() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method>>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method>::Builder InterfaceNode::Builder::getMethods() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method>>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void InterfaceNode::Builder::setMethods( ::capnp::List< ::capnp::schema::InterfaceNode::Method>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method>>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method>::Builder InterfaceNode::Builder::initMethods(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method>>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void InterfaceNode::Builder::adoptMethods(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::InterfaceNode::Method>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method>>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::InterfaceNode::Method>> InterfaceNode::Builder::disownMethods() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method>>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool InterfaceNode::Method::Reader::hasName() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool InterfaceNode::Method::Builder::hasName() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Reader InterfaceNode::Method::Reader::getName() const {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Builder InterfaceNode::Method::Builder::getName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Builder::setName( ::capnp::Text::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::Text::Builder InterfaceNode::Method::Builder::initName(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void InterfaceNode::Method::Builder::adoptName(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> InterfaceNode::Method::Builder::disownName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline  ::uint16_t InterfaceNode::Method::Reader::getCodeOrder() const {
  return _reader.getDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS);
}

inline  ::uint16_t InterfaceNode::Method::Builder::getCodeOrder() {
  return _builder.getDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS);
}
inline void InterfaceNode::Method::Builder::setCodeOrder( ::uint16_t value) {
  _builder.setDataField< ::uint16_t>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool InterfaceNode::Method::Reader::hasParams() const {
  return !_reader.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline bool InterfaceNode::Method::Builder::hasParams() {
  return !_builder.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>::Reader InterfaceNode::Method::Reader::getParams() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>>::get(
      _reader, 1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>::Builder InterfaceNode::Method::Builder::getParams() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>>::get(
      _builder, 1 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Builder::setParams( ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>>::set(
      _builder, 1 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>::Builder InterfaceNode::Method::Builder::initParams(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>>::init(
      _builder, 1 * ::capnp::POINTERS, size);
}
inline void InterfaceNode::Method::Builder::adoptParams(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>>::adopt(
      _builder, 1 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>> InterfaceNode::Method::Builder::disownParams() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::InterfaceNode::Method::Param>>::disown(
      _builder, 1 * ::capnp::POINTERS);
}

inline  ::uint16_t InterfaceNode::Method::Reader::getRequiredParamCount() const {
  return _reader.getDataField< ::uint16_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint16_t InterfaceNode::Method::Builder::getRequiredParamCount() {
  return _builder.getDataField< ::uint16_t>(
      1 * ::capnp::ELEMENTS);
}
inline void InterfaceNode::Method::Builder::setRequiredParamCount( ::uint16_t value) {
  _builder.setDataField< ::uint16_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline bool InterfaceNode::Method::Reader::hasReturnType() const {
  return !_reader.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline bool InterfaceNode::Method::Builder::hasReturnType() {
  return !_builder.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Reader InterfaceNode::Method::Reader::getReturnType() const {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _reader, 2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Builder InterfaceNode::Method::Builder::getReturnType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _builder, 2 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Builder::setReturnType( ::capnp::schema::Type::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::set(
      _builder, 2 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Type::Builder InterfaceNode::Method::Builder::initReturnType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::init(
      _builder, 2 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Builder::adoptReturnType(
    ::capnp::Orphan< ::capnp::schema::Type>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::adopt(
      _builder, 2 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Type> InterfaceNode::Method::Builder::disownReturnType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::disown(
      _builder, 2 * ::capnp::POINTERS);
}

inline bool InterfaceNode::Method::Reader::hasAnnotations() const {
  return !_reader.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline bool InterfaceNode::Method::Builder::hasAnnotations() {
  return !_builder.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Reader InterfaceNode::Method::Reader::getAnnotations() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _reader, 3 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder InterfaceNode::Method::Builder::getAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _builder, 3 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Builder::setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::set(
      _builder, 3 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder InterfaceNode::Method::Builder::initAnnotations(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::init(
      _builder, 3 * ::capnp::POINTERS, size);
}
inline void InterfaceNode::Method::Builder::adoptAnnotations(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::adopt(
      _builder, 3 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> InterfaceNode::Method::Builder::disownAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::disown(
      _builder, 3 * ::capnp::POINTERS);
}

inline bool InterfaceNode::Method::Param::Reader::hasName() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool InterfaceNode::Method::Param::Builder::hasName() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Reader InterfaceNode::Method::Param::Reader::getName() const {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::Text::Builder InterfaceNode::Method::Param::Builder::getName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Param::Builder::setName( ::capnp::Text::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::Text::Builder InterfaceNode::Method::Param::Builder::initName(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void InterfaceNode::Method::Param::Builder::adoptName(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> InterfaceNode::Method::Param::Builder::disownName() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool InterfaceNode::Method::Param::Reader::hasType() const {
  return !_reader.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline bool InterfaceNode::Method::Param::Builder::hasType() {
  return !_builder.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Reader InterfaceNode::Method::Param::Reader::getType() const {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _reader, 1 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Builder InterfaceNode::Method::Param::Builder::getType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _builder, 1 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Param::Builder::setType( ::capnp::schema::Type::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::set(
      _builder, 1 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Type::Builder InterfaceNode::Method::Param::Builder::initType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::init(
      _builder, 1 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Param::Builder::adoptType(
    ::capnp::Orphan< ::capnp::schema::Type>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::adopt(
      _builder, 1 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Type> InterfaceNode::Method::Param::Builder::disownType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::disown(
      _builder, 1 * ::capnp::POINTERS);
}

inline bool InterfaceNode::Method::Param::Reader::hasDefaultValue() const {
  return !_reader.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline bool InterfaceNode::Method::Param::Builder::hasDefaultValue() {
  return !_builder.isPointerFieldNull(2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Value::Reader InterfaceNode::Method::Param::Reader::getDefaultValue() const {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::get(
      _reader, 2 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Value::Builder InterfaceNode::Method::Param::Builder::getDefaultValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::get(
      _builder, 2 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Param::Builder::setDefaultValue( ::capnp::schema::Value::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Value>::set(
      _builder, 2 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Value::Builder InterfaceNode::Method::Param::Builder::initDefaultValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::init(
      _builder, 2 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Param::Builder::adoptDefaultValue(
    ::capnp::Orphan< ::capnp::schema::Value>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Value>::adopt(
      _builder, 2 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Value> InterfaceNode::Method::Param::Builder::disownDefaultValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::disown(
      _builder, 2 * ::capnp::POINTERS);
}

inline bool InterfaceNode::Method::Param::Reader::hasAnnotations() const {
  return !_reader.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline bool InterfaceNode::Method::Param::Builder::hasAnnotations() {
  return !_builder.isPointerFieldNull(3 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Reader InterfaceNode::Method::Param::Reader::getAnnotations() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _reader, 3 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder InterfaceNode::Method::Param::Builder::getAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::get(
      _builder, 3 * ::capnp::POINTERS);
}
inline void InterfaceNode::Method::Param::Builder::setAnnotations( ::capnp::List< ::capnp::schema::Annotation>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::set(
      _builder, 3 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::Annotation>::Builder InterfaceNode::Method::Param::Builder::initAnnotations(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::init(
      _builder, 3 * ::capnp::POINTERS, size);
}
inline void InterfaceNode::Method::Param::Builder::adoptAnnotations(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::adopt(
      _builder, 3 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Annotation>> InterfaceNode::Method::Param::Builder::disownAnnotations() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Annotation>>::disown(
      _builder, 3 * ::capnp::POINTERS);
}

inline bool ConstNode::Reader::hasType() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool ConstNode::Builder::hasType() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Reader ConstNode::Reader::getType() const {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Builder ConstNode::Builder::getType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void ConstNode::Builder::setType( ::capnp::schema::Type::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Type::Builder ConstNode::Builder::initType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::init(
      _builder, 0 * ::capnp::POINTERS);
}
inline void ConstNode::Builder::adoptType(
    ::capnp::Orphan< ::capnp::schema::Type>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Type> ConstNode::Builder::disownType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool ConstNode::Reader::hasValue() const {
  return !_reader.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline bool ConstNode::Builder::hasValue() {
  return !_builder.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Value::Reader ConstNode::Reader::getValue() const {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::get(
      _reader, 1 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Value::Builder ConstNode::Builder::getValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::get(
      _builder, 1 * ::capnp::POINTERS);
}
inline void ConstNode::Builder::setValue( ::capnp::schema::Value::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Value>::set(
      _builder, 1 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Value::Builder ConstNode::Builder::initValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::init(
      _builder, 1 * ::capnp::POINTERS);
}
inline void ConstNode::Builder::adoptValue(
    ::capnp::Orphan< ::capnp::schema::Value>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Value>::adopt(
      _builder, 1 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Value> ConstNode::Builder::disownValue() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Value>::disown(
      _builder, 1 * ::capnp::POINTERS);
}

inline bool AnnotationNode::Reader::hasType() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool AnnotationNode::Builder::hasType() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Reader AnnotationNode::Reader::getType() const {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::schema::Type::Builder AnnotationNode::Builder::getType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void AnnotationNode::Builder::setType( ::capnp::schema::Type::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::schema::Type::Builder AnnotationNode::Builder::initType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::init(
      _builder, 0 * ::capnp::POINTERS);
}
inline void AnnotationNode::Builder::adoptType(
    ::capnp::Orphan< ::capnp::schema::Type>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::schema::Type>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::schema::Type> AnnotationNode::Builder::disownType() {
  return ::capnp::_::PointerHelpers< ::capnp::schema::Type>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool AnnotationNode::Reader::getTargetsFile() const {
  return _reader.getDataField<bool>(
      0 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsFile() {
  return _builder.getDataField<bool>(
      0 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsFile(bool value) {
  _builder.setDataField<bool>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsConst() const {
  return _reader.getDataField<bool>(
      1 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsConst() {
  return _builder.getDataField<bool>(
      1 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsConst(bool value) {
  _builder.setDataField<bool>(
      1 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsEnum() const {
  return _reader.getDataField<bool>(
      2 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsEnum() {
  return _builder.getDataField<bool>(
      2 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsEnum(bool value) {
  _builder.setDataField<bool>(
      2 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsEnumerant() const {
  return _reader.getDataField<bool>(
      3 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsEnumerant() {
  return _builder.getDataField<bool>(
      3 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsEnumerant(bool value) {
  _builder.setDataField<bool>(
      3 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsStruct() const {
  return _reader.getDataField<bool>(
      4 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsStruct() {
  return _builder.getDataField<bool>(
      4 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsStruct(bool value) {
  _builder.setDataField<bool>(
      4 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsField() const {
  return _reader.getDataField<bool>(
      5 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsField() {
  return _builder.getDataField<bool>(
      5 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsField(bool value) {
  _builder.setDataField<bool>(
      5 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsUnion() const {
  return _reader.getDataField<bool>(
      6 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsUnion() {
  return _builder.getDataField<bool>(
      6 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsUnion(bool value) {
  _builder.setDataField<bool>(
      6 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsInterface() const {
  return _reader.getDataField<bool>(
      7 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsInterface() {
  return _builder.getDataField<bool>(
      7 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsInterface(bool value) {
  _builder.setDataField<bool>(
      7 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsMethod() const {
  return _reader.getDataField<bool>(
      8 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsMethod() {
  return _builder.getDataField<bool>(
      8 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsMethod(bool value) {
  _builder.setDataField<bool>(
      8 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsParam() const {
  return _reader.getDataField<bool>(
      9 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsParam() {
  return _builder.getDataField<bool>(
      9 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsParam(bool value) {
  _builder.setDataField<bool>(
      9 * ::capnp::ELEMENTS, value);
}

inline bool AnnotationNode::Reader::getTargetsAnnotation() const {
  return _reader.getDataField<bool>(
      10 * ::capnp::ELEMENTS);
}

inline bool AnnotationNode::Builder::getTargetsAnnotation() {
  return _builder.getDataField<bool>(
      10 * ::capnp::ELEMENTS);
}
inline void AnnotationNode::Builder::setTargetsAnnotation(bool value) {
  _builder.setDataField<bool>(
      10 * ::capnp::ELEMENTS, value);
}

inline bool CodeGeneratorRequest::Reader::hasNodes() const {
  return !_reader.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline bool CodeGeneratorRequest::Builder::hasNodes() {
  return !_builder.isPointerFieldNull(0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Node>::Reader CodeGeneratorRequest::Reader::getNodes() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node>>::get(
      _reader, 0 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::capnp::schema::Node>::Builder CodeGeneratorRequest::Builder::getNodes() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node>>::get(
      _builder, 0 * ::capnp::POINTERS);
}
inline void CodeGeneratorRequest::Builder::setNodes( ::capnp::List< ::capnp::schema::Node>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node>>::set(
      _builder, 0 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::capnp::schema::Node>::Builder CodeGeneratorRequest::Builder::initNodes(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node>>::init(
      _builder, 0 * ::capnp::POINTERS, size);
}
inline void CodeGeneratorRequest::Builder::adoptNodes(
    ::capnp::Orphan< ::capnp::List< ::capnp::schema::Node>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node>>::adopt(
      _builder, 0 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::schema::Node>> CodeGeneratorRequest::Builder::disownNodes() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::schema::Node>>::disown(
      _builder, 0 * ::capnp::POINTERS);
}

inline bool CodeGeneratorRequest::Reader::hasRequestedFiles() const {
  return !_reader.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline bool CodeGeneratorRequest::Builder::hasRequestedFiles() {
  return !_builder.isPointerFieldNull(1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::uint64_t>::Reader CodeGeneratorRequest::Reader::getRequestedFiles() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::uint64_t>>::get(
      _reader, 1 * ::capnp::POINTERS);
}
inline  ::capnp::List< ::uint64_t>::Builder CodeGeneratorRequest::Builder::getRequestedFiles() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::uint64_t>>::get(
      _builder, 1 * ::capnp::POINTERS);
}
inline void CodeGeneratorRequest::Builder::setRequestedFiles( ::capnp::List< ::uint64_t>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::uint64_t>>::set(
      _builder, 1 * ::capnp::POINTERS, value);
}
inline void CodeGeneratorRequest::Builder::setRequestedFiles(std::initializer_list< ::uint64_t> value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::uint64_t>>::set(
      _builder, 1 * ::capnp::POINTERS, value);
}
inline  ::capnp::List< ::uint64_t>::Builder CodeGeneratorRequest::Builder::initRequestedFiles(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::uint64_t>>::init(
      _builder, 1 * ::capnp::POINTERS, size);
}
inline void CodeGeneratorRequest::Builder::adoptRequestedFiles(
    ::capnp::Orphan< ::capnp::List< ::uint64_t>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::uint64_t>>::adopt(
      _builder, 1 * ::capnp::POINTERS, kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::uint64_t>> CodeGeneratorRequest::Builder::disownRequestedFiles() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::uint64_t>>::disown(
      _builder, 1 * ::capnp::POINTERS);
}

}  // namespace
}  // namespace

#endif  // CAPNP_INCLUDED_b471df2f45ca32c7_
