MACRO(FIND_SYSTEM_LIBRARY)
  SET(_argn ${ARGN})
  LIST(GET _argn 0 _variable)
  LIST(REMOVE_AT _argn 0 1)

  if("${_variable}" MATCHES "^${_variable}$")
    FOREACH(_arg ${_argn})
      LIST(APPEND CMAKE_REQUIRED_LIBRARIES "-l${_arg}")
      CHECK_CXX_COMPILER_FLAG("" ${_variable})
      # RESET_CMAKE_REQUIRED()

      IF(${_variable})
        UNSET(${_variable} CACHE)
        SET(${_variable} ${_arg} CACHE STRING "A system library.")
        SET(${_variable} ${_arg})
        BREAK()
      ELSE()
        UNSET(${_variable} CACHE)
      ENDIF()
    ENDFOREACH()

    IF(NOT ${_variable})
      SET(${_variable} "${_variable}-NOTFOUND")
    ENDIF()
  ENDIF()
ENDMACRO()