// distribution boxbackup-0.11.1 (svn version: 2821_2827)
// Box Backup, http://www.boxbackup.org/
// 
// Copyright (c) 2003-2010, Ben Summers and contributors.
// All rights reserved.
// 
// Note that this project uses mixed licensing. Any file with this license
// attached, or where the code LICENSE-GPL appears on the first line, falls
// under the "Box Backup GPL" license. See the file COPYING.txt for more
// information about this license.
// 
// ---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
// 
// [http://www.gnu.org/licenses/old-licenses/gpl-2.0.html#SEC4]
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any software that can be downloaded from
// the OpenSSL website [http://www.openssl.org] under either the
// "OpenSSL License" or the "Original SSLeay License", and to distribute
// the linked executables under the terms of the "Box Backup GPL" license.
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any version of Microsoft's Volume Shadow Copy Service 7.2 SDK
// or Microsoft Windows Software Development Kit (SDK), including
// vssapi.lib, that can be downloaded from the Microsoft website
// [*.microsoft.com], and to distribute the linked executables under the
// terms of the "Box Backup GPL" license.
// --------------------------------------------------------------------------
//
// File
//		Name:    BackupStoreAccountDatabase.h
//		Purpose: Database of accounts for the backup store
//		Created: 2003/08/20
//
// --------------------------------------------------------------------------

#ifndef BACKUPSTOREACCOUNTDATABASE__H
#define BACKUPSTOREACCOUNTDATABASE__H

#include <memory>
#include <vector>

#include "BoxTime.h"

class _BackupStoreAccountDatabase;

// --------------------------------------------------------------------------
//
// Class
//		Name:    BackupStoreAccountDatabase
//		Purpose: Database of accounts for the backup store
//		Created: 2003/08/20
//
// --------------------------------------------------------------------------
class BackupStoreAccountDatabase
{
public:
	friend class _BackupStoreAccountDatabase;	// to stop compiler warnings
	~BackupStoreAccountDatabase();
private:
	BackupStoreAccountDatabase(const char *Filename);
	BackupStoreAccountDatabase(const BackupStoreAccountDatabase &);
public:

	static std::auto_ptr<BackupStoreAccountDatabase> Read(const char *Filename);
	void Write();

	class Entry
	{
	public:
		Entry();
		Entry(int32_t ID, int DiscSet);
		Entry(const Entry &rEntry);
		~Entry();

		int32_t GetID() const {return mID;}
		int GetDiscSet() const {return mDiscSet;}
		
	private:
		int32_t mID;
		int mDiscSet;
	};

	bool EntryExists(int32_t ID) const;
	Entry GetEntry(int32_t ID) const;
	Entry AddEntry(int32_t ID, int DiscSet);
	void DeleteEntry(int32_t ID);

	// This interface should change in the future. But for now it'll do.
	void GetAllAccountIDs(std::vector<int32_t> &rIDsOut);

private:
	void ReadFile() const;	// const in concept only
	void CheckUpToDate() const;	// const in concept only
	box_time_t GetDBFileModificationTime() const;

private:
	mutable _BackupStoreAccountDatabase *pImpl;
};

#endif // BACKUPSTOREACCOUNTDATABASE__H

