#!/usr/bin/perl -w
# distribution boxbackup-0.11.1 (svn version: 2821_2827)
# Box Backup, http://www.boxbackup.org/
# 
# Copyright (c) 2003-2010, Ben Summers and contributors.
# All rights reserved.
# 
# Note that this project uses mixed licensing. Any file with this license
# attached, or where the code LICENSE-GPL appears on the first line, falls
# under the "Box Backup GPL" license. See the file COPYING.txt for more
# information about this license.
# 
# ---------------------------------------------------------------------
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# 
# [http://www.gnu.org/licenses/old-licenses/gpl-2.0.html#SEC4]
# 
# As a special exception to the GPLv2, the Box Backup Project gives
# permission to link any code falling under this license (the Box Backup
# GPL) with any software that can be downloaded from
# the OpenSSL website [http://www.openssl.org] under either the
# "OpenSSL License" or the "Original SSLeay License", and to distribute
# the linked executables under the terms of the "Box Backup GPL" license.
# 
# As a special exception to the GPLv2, the Box Backup Project gives
# permission to link any code falling under this license (the Box Backup
# GPL) with any version of Microsoft's Volume Shadow Copy Service 7.2 SDK
# or Microsoft Windows Software Development Kit (SDK), including
# vssapi.lib, that can be downloaded from the Microsoft website
# [*.microsoft.com], and to distribute the linked executables under the
# terms of the "Box Backup GPL" license.
use strict;

open (EXCEPT,  "< $ARGV[0]") or die "Can't open $ARGV[0]: $!\n";
open (DOCBOOK, "> $ARGV[1]") or die "Can't open $ARGV[1] for writing: $!\n";

print DOCBOOK <<EOD;
<?xml version="1.0" encoding="UTF-8"?>

<appendix>
    <title>Exception codes</title>

EOD
my $sectionName;
my $sectionNum;
my $sectionDesc;
my $exceptionCode;
my $exceptionShortDesc;
my $exceptionLongDesc;
while(<EXCEPT>)
{
    next if(m/^#/);
    chomp;
    if(m/^EXCEPTION TYPE (\w+) (\d+)/)
    {
        $sectionName = ucfirst(lc($1));
        $sectionNum = $2;
        if($sectionName ne "Common")
        {
            $sectionDesc = "the " . $sectionName;
        }
        else
        {
            $sectionDesc = "any";
        }
        print DOCBOOK <<EOD;
    <section>
      <title>$sectionName Exceptions ($sectionNum)</title>
      
      <para>These are exceptions that can occur in $sectionDesc module
      of the system.</para>
      
      <itemizedlist>
EOD
    }
    
    # The END TYPE line
    if(m/^END TYPE$/)
    {
        print DOCBOOK "      </itemizedlist>\n    </section>\n";
    }
    
    # The actual exceptions
    if(m/(\(\d+\/\d+\)) - (\w+ \w+)(?: - )?(.*)$/)
    {
        $exceptionCode = $1;
        $exceptionShortDesc = $2;
        $exceptionLongDesc = $3;
        
        print DOCBOOK "        <listitem>\n          <para><emphasis role=\"bold\">";
        print DOCBOOK $exceptionCode . ": " . $exceptionShortDesc . "</emphasis>";
        if($exceptionLongDesc ne "")
        {
            print DOCBOOK " -- " . $exceptionLongDesc;
        }
        print DOCBOOK "</para>\n        </listitem>\n";
    }
}

print DOCBOOK "</appendix>\n";

close EXCEPT;
close DOCBOOK;
        
