// distribution boxbackup-0.11.1 (svn version: 2821_2827)
// Box Backup, http://www.boxbackup.org/
// 
// Copyright (c) 2003-2010, Ben Summers and contributors.
// All rights reserved.
// 
// Note that this project uses mixed licensing. Any file with this license
// attached, or where the code LICENSE-GPL appears on the first line, falls
// under the "Box Backup GPL" license. See the file COPYING.txt for more
// information about this license.
// 
// ---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
// 
// [http://www.gnu.org/licenses/old-licenses/gpl-2.0.html#SEC4]
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any software that can be downloaded from
// the OpenSSL website [http://www.openssl.org] under either the
// "OpenSSL License" or the "Original SSLeay License", and to distribute
// the linked executables under the terms of the "Box Backup GPL" license.
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any version of Microsoft's Volume Shadow Copy Service 7.2 SDK
// or Microsoft Windows Software Development Kit (SDK), including
// vssapi.lib, that can be downloaded from the Microsoft website
// [*.microsoft.com], and to distribute the linked executables under the
// terms of the "Box Backup GPL" license.
// --------------------------------------------------------------------------
//
// File
//		Name:    BackupClientDeleteList.h
//		Purpose: List of pending deletes for backup
//		Created: 10/11/03
//
// --------------------------------------------------------------------------

#ifndef BACKUPCLIENTDELETELIST__H
#define BACKUPCLIENTDELETELIST__H

#include "BackupStoreFilename.h"

class BackupClientContext;

#include <vector>
#include <utility>
#include <set>

// --------------------------------------------------------------------------
//
// Class
//		Name:    BackupClientDeleteList
//		Purpose: List of pending deletes for backup
//		Created: 10/11/03
//
// --------------------------------------------------------------------------
class BackupClientDeleteList
{
private:
	class FileToDelete
	{
		public:
		int64_t mDirectoryID;
		BackupStoreFilename mFilename;
		std::string mLocalPath;
		FileToDelete(int64_t DirectoryID, 
			const BackupStoreFilename& rFilename,
			const std::string& rLocalPath);
	};

	class DirToDelete
	{
		public:
		int64_t mObjectID;
		std::string mLocalPath;
		DirToDelete(int64_t ObjectID, const std::string& rLocalPath);
	};

public:
	BackupClientDeleteList();
	~BackupClientDeleteList();
	
	void AddDirectoryDelete(int64_t ObjectID,
		const std::string& rLocalPath);
	void AddFileDelete(int64_t DirectoryID,
		const BackupStoreFilename &rFilename,
		const std::string& rLocalPath);

	void StopDirectoryDeletion(int64_t ObjectID);
	void StopFileDeletion(int64_t DirectoryID,
		const BackupStoreFilename &rFilename);
	
	void PerformDeletions(BackupClientContext &rContext);
	
private:
	std::vector<DirToDelete> mDirectoryList;
	std::set<int64_t> mDirectoryNoDeleteList;	// note: things only get in this list if they're not present in mDirectoryList when they are 'added'
	std::vector<FileToDelete> mFileList;
	std::vector<std::pair<int64_t, BackupStoreFilename> > mFileNoDeleteList;
};

#endif // BACKUPCLIENTDELETELIST__H

