/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;

public class PureJavaReflectionProvider
implements ReflectionProvider {
    protected FieldDictionary fieldDictionary = new FieldDictionary();

    public Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ObjectAccessException("Cannot construct " + clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectAccessException("Cannot construct " + clazz.getName(), illegalAccessException);
        }
    }

    public void visitSerializableFields(Object object, ReflectionProvider.Visitor visitor) {
        Iterator iterator = this.fieldDictionary.serializableFieldsFor(object.getClass());
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!this.fieldModifiersSupported(field)) continue;
            this.validateFieldAccess(field);
            Object object2 = null;
            try {
                object2 = field.get(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), illegalAccessException);
            }
            visitor.visit(field.getName(), field.getType(), field.getDeclaringClass(), object2);
        }
    }

    public void writeField(Object object, String string, Object object2, Class clazz) {
        Field field = this.fieldDictionary.field(object.getClass(), string, clazz);
        this.validateFieldAccess(field);
        try {
            field.set(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName(), illegalAccessException);
        }
    }

    public Class getFieldType(Object object, String string, Class clazz) {
        return this.fieldDictionary.field(object.getClass(), string, clazz).getType();
    }

    public boolean fieldDefinedInClass(String string, Class clazz) {
        try {
            this.fieldDictionary.field(clazz, string, null);
            return true;
        }
        catch (ObjectAccessException objectAccessException) {
            return false;
        }
    }

    protected boolean fieldModifiersSupported(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers());
    }

    protected void validateFieldAccess(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new ObjectAccessException("Invalid final field " + field.getDeclaringClass().getName() + "." + field.getName());
        }
    }
}

