/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.velocity.app.Velocity;

public class LogSystemCommonsLog
implements Log {
    private boolean printStackTrace = false;

    public LogSystemCommonsLog() {
    }

    public LogSystemCommonsLog(String name) {
    }

    public LogSystemCommonsLog(boolean pst) {
        this.printStackTrace = pst;
    }

    private void log(int level, Object message) {
        switch (level) {
            case 2: {
                Velocity.warn((Object)message);
                break;
            }
            case 1: {
                Velocity.info((Object)message);
                break;
            }
            case 0: {
                Velocity.debug((Object)message);
                break;
            }
            case 3: {
                Velocity.error((Object)message);
                break;
            }
            default: {
                Velocity.debug((Object)message);
            }
        }
    }

    private void log(int level, Object message, Throwable t) {
        if (this.printStackTrace) {
            StringWriter sw = new StringWriter();
            sw.write(String.valueOf(message));
            t.printStackTrace(new PrintWriter(sw));
            this.log(level, sw);
        } else {
            StringBuffer buffer = new StringBuffer(String.valueOf(message));
            buffer.append(" - ");
            buffer.append(t.getMessage());
            this.log(level, buffer);
        }
    }

    public void trace(Object message) {
        this.log(0, message);
    }

    public void trace(Object message, Throwable t) {
        this.log(0, message, t);
    }

    public void debug(Object message) {
        this.log(0, message);
    }

    public void debug(Object message, Throwable t) {
        this.log(0, message, t);
    }

    public void info(Object message) {
        this.log(1, message);
    }

    public void info(Object message, Throwable t) {
        this.log(1, message, t);
    }

    public void warn(Object message) {
        this.log(2, message);
    }

    public void warn(Object message, Throwable t) {
        this.log(2, message, t);
    }

    public void error(Object message) {
        this.log(3, message);
    }

    public void error(Object message, Throwable t) {
        this.log(3, message, t);
    }

    public void fatal(Object message) {
        this.log(3, message);
    }

    public void fatal(Object message, Throwable t) {
        this.log(3, message, t);
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }
}

