/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.util.Iterator;
import java.util.LinkedList;
import org.codehaus.groovy.GroovyException;

public class ExceptionCollector
extends GroovyException {
    private LinkedList collection = new LinkedList();
    private int limit = 0;

    public ExceptionCollector() {
        super(false);
        this.limit = 1;
    }

    public ExceptionCollector(int limit) {
        super(false);
        this.limit = limit;
    }

    public ExceptionCollector(String message, int limit) {
        super(message, false);
        this.limit = limit;
    }

    public void add(GroovyException exception) throws ExceptionCollector {
        this.add(exception, true);
    }

    public void add(GroovyException exception, boolean withThrow) throws ExceptionCollector {
        this.collection.add(exception);
        if (exception.isFatal()) {
            this.setFatal(true);
        }
        if (withThrow) {
            this.throwIfCause();
        }
    }

    public void merge(ExceptionCollector other) throws ExceptionCollector {
        this.merge(other, true);
    }

    public void merge(ExceptionCollector other, boolean withThrow) throws ExceptionCollector {
        if (other != this) {
            this.collection.addAll(other.collection);
            if (other.isFatal()) {
                this.setFatal(true);
            }
        }
        if (withThrow) {
            this.throwIfCause();
        }
    }

    public void throwIfCause() throws ExceptionCollector {
        if (this.hasCause()) {
            throw this;
        }
    }

    public void throwUnlessEmpty() throws ExceptionCollector {
        if (!this.isEmpty()) {
            throw this;
        }
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public boolean isFull() {
        return this.collection.size() >= this.limit;
    }

    public boolean hasCause() {
        return this.isFatal() || this.isFull();
    }

    public int size() {
        return this.collection.size();
    }

    public GroovyException get(int child) {
        return (GroovyException)this.collection.get(child);
    }

    public void throwFirstChild() throws GroovyException {
        throw this.get(0);
    }

    public Iterator iterator() {
        return this.collection.iterator();
    }

    public String getMessage() {
        if (this.collection.size() == 1) {
            return "1 exception";
        }
        return "" + this.collection.size() + " exceptions";
    }

    public String toString() {
        return this.getMessage();
    }
}

