/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.lexer;

import org.codehaus.groovy.syntax.LookAheadExhaustionError;
import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.lexer.CharStream;
import org.codehaus.groovy.syntax.lexer.LexerException;
import org.codehaus.groovy.syntax.lexer.UnexpectedCharacterException;
import org.codehaus.groovy.syntax.lexer.UnterminatedStringLiteralException;

public class Lexer {
    private final char[] buf = new char[5];
    private final int[] charWidth = new int[this.buf.length];
    private int cur = 0;
    private int charsInBuffer = 0;
    private boolean eosRead = false;
    private boolean escapeLookahead = false;
    private char escapeLookaheadChar;
    private int line;
    private int column;
    private int startLine;
    private int startColumn;
    private CharStream charStream;

    public Lexer(CharStream charStream) {
        this.charStream = charStream;
        this.line = 1;
        this.column = 1;
    }

    public CharStream getCharStream() {
        return this.charStream;
    }

    public Token nextToken() throws ReadException, LexerException {
        Token token = null;
        block118: while (token == null) {
            char c = this.la();
            switch (c) {
                case '\uffff': {
                    break block118;
                }
                case '\t': 
                case ' ': {
                    this.consume();
                    token = null;
                    continue block118;
                }
                case '\r': {
                    this.consume();
                    if (this.la() == '\n') {
                        this.consume();
                        token = Token.newline(this.getStartLine(), this.getStartColumn());
                    } else {
                        token = null;
                    }
                    this.eol();
                    continue block118;
                }
                case '\n': {
                    this.consume();
                    if (this.la() == '\r') {
                        this.consume();
                    }
                    this.eol();
                    token = Token.newline(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '{': {
                    this.mark();
                    this.consume();
                    token = Token.leftCurlyBrace(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '}': {
                    this.mark();
                    this.consume();
                    token = Token.rightCurlyBrace(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '[': {
                    this.mark();
                    this.consume();
                    token = Token.leftSquareBracket(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case ']': {
                    this.mark();
                    this.consume();
                    token = Token.rightSquareBracket(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '(': {
                    this.mark();
                    this.consume();
                    token = Token.leftParenthesis(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case ')': {
                    this.mark();
                    this.consume();
                    token = Token.rightParenthesis(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '.': {
                    this.mark();
                    this.consume();
                    if (this.la() == '.') {
                        this.consume();
                        if (this.la() == '.') {
                            this.consume();
                            token = Token.dotDotDot(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                        token = Token.dotDot(this.getStartLine(), this.getStartColumn());
                        continue block118;
                    }
                    token = Token.dot(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '#': {
                    this.consume();
                    token = Token.newline(this.getStartLine(), this.getStartColumn() - 1);
                    while (true) {
                        switch (this.la()) {
                            case '\r': {
                                this.consume();
                                if (this.la() == '\n') {
                                    this.consume();
                                }
                                this.eol();
                                continue block118;
                            }
                            case '\n': {
                                this.consume();
                                this.eol();
                                continue block118;
                            }
                            case '\uffff': {
                                continue block118;
                            }
                        }
                        this.consume();
                    }
                }
                case '/': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '=': {
                            this.consume();
                            token = Token.divideEqual(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                        case '/': {
                            this.consume();
                            token = Token.newline(this.getStartLine(), this.getStartColumn() - 2);
                            while (true) {
                                switch (this.la()) {
                                    case '\r': {
                                        this.consume();
                                        if (this.la() == '\n') {
                                            this.consume();
                                        }
                                        this.eol();
                                        continue block118;
                                    }
                                    case '\n': {
                                        this.consume();
                                        this.eol();
                                        continue block118;
                                    }
                                    case '\uffff': {
                                        continue block118;
                                    }
                                }
                                this.consume();
                            }
                        }
                        case '*': {
                            block121: while (true) {
                                switch (this.la()) {
                                    case '*': {
                                        this.consume();
                                        if (this.la() != '/') continue block121;
                                        this.consume();
                                        break block121;
                                    }
                                    case '\r': {
                                        this.consume();
                                        if (this.la() == '\n') {
                                            this.consume();
                                        }
                                        this.eol();
                                        continue block121;
                                    }
                                    case '\n': {
                                        this.eol();
                                        this.consume();
                                        continue block121;
                                    }
                                    case '\uffff': {
                                        break block121;
                                    }
                                    default: {
                                        this.consume();
                                        continue block121;
                                    }
                                }
                                break;
                            }
                            token = null;
                            continue block118;
                        }
                    }
                    token = Token.divide(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '%': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '=': {
                            this.consume();
                            token = Token.modEqual(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    token = Token.mod(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '~': {
                    this.mark();
                    this.consume();
                    token = Token.patternRegex(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '!': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '=': {
                            this.consume();
                            token = Token.compareNotEqual(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    token = Token.not(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '=': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '=': {
                            this.consume();
                            c = this.la();
                            switch (c) {
                                case '=': {
                                    this.consume();
                                    token = Token.compareIdentical(this.getStartLine(), this.getStartColumn());
                                    continue block118;
                                }
                                case '~': {
                                    this.consume();
                                    token = Token.matchRegex(this.getStartLine(), this.getStartColumn());
                                    continue block118;
                                }
                            }
                            token = Token.compareEqual(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                        case '~': {
                            this.consume();
                            token = Token.findRegex(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    token = Token.equal(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '&': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '&': {
                            this.consume();
                            token = Token.logicalAnd(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    throw new UnexpectedCharacterException(this.getStartLine(), this.getStartColumn() + 1, c, new char[]{'&'});
                }
                case '|': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '|': {
                            this.consume();
                            token = Token.logicalOr(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    token = Token.pipe(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '+': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '+': {
                            this.consume();
                            token = Token.plusPlus(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                        case '=': {
                            this.consume();
                            token = Token.plusEqual(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    token = Token.plus(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '-': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '-': {
                            this.consume();
                            token = Token.minusMinus(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                        case '=': {
                            this.consume();
                            token = Token.minusEqual(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                        case '>': {
                            this.consume();
                            token = Token.navigate(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    token = Token.minus(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '*': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '=': {
                            this.consume();
                            token = Token.multiplyEqual(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    token = Token.multiply(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case ':': {
                    this.mark();
                    this.consume();
                    token = Token.colon(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case ',': {
                    this.mark();
                    this.consume();
                    token = Token.comma(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case ';': {
                    this.mark();
                    this.consume();
                    token = Token.semicolon(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '?': {
                    this.mark();
                    this.consume();
                    token = Token.question(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '<': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '=': {
                            this.consume();
                            c = this.la();
                            if (c == '>') {
                                this.consume();
                                token = Token.compareTo(this.getStartLine(), this.getStartColumn());
                                continue block118;
                            }
                            token = Token.compareLessThanEqual(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                        case '<': {
                            this.consume();
                            c = this.la();
                            if (c == '<') {
                                this.consume();
                                StringBuffer marker = new StringBuffer();
                                while ((c = this.la()) != '\n' && c != '\r') {
                                    marker.append(c);
                                    this.consume();
                                }
                                this.consume();
                                if (c == '\r' && this.la() == '\n') {
                                    this.consume();
                                }
                                this.eol();
                                this.mark();
                                StringBuffer stringLiteral = new StringBuffer();
                                block123: while (true) {
                                    c = this.la();
                                    switch (c) {
                                        case '\n': 
                                        case '\r': {
                                            this.eol();
                                            StringBuffer markerBuffer = new StringBuffer();
                                            this.consume();
                                            markerBuffer.append('\n');
                                            if (c == '\r' && this.la() == '\n') {
                                                this.consume();
                                            }
                                            for (int i = 0; i < marker.length(); ++i) {
                                                if (this.la() != marker.charAt(i)) {
                                                    stringLiteral.append(markerBuffer);
                                                    continue block123;
                                                }
                                                c = this.consume();
                                                markerBuffer.append(c);
                                            }
                                            break block123;
                                        }
                                        case '\uffff': {
                                            throw new UnterminatedStringLiteralException(this.getStartLine(), this.getStartColumn());
                                        }
                                        default: {
                                            stringLiteral.append(this.consume());
                                            continue block123;
                                        }
                                    }
                                    break;
                                }
                                token = Token.doubleQuoteString(this.getStartLine(), this.getStartColumn(), stringLiteral.toString());
                                continue block118;
                            }
                            token = Token.leftShift(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    token = Token.compareLessThan(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '>': {
                    this.mark();
                    this.consume();
                    c = this.la();
                    switch (c) {
                        case '=': {
                            this.consume();
                            token = Token.compareGreaterThanEqual(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                        case '>': {
                            this.consume();
                            token = Token.rightShift(this.getStartLine(), this.getStartColumn());
                            continue block118;
                        }
                    }
                    token = Token.compareGreaterThan(this.getStartLine(), this.getStartColumn());
                    continue block118;
                }
                case '\'': {
                    this.mark();
                    this.consume();
                    StringBuffer stringLiteral = new StringBuffer();
                    block125: while (true) {
                        c = this.la();
                        switch (c) {
                            case '\\': {
                                this.consume();
                                c = this.la();
                                switch (c) {
                                    case 't': {
                                        this.consume();
                                        stringLiteral.append('\t');
                                        continue block125;
                                    }
                                    case 'n': {
                                        this.consume();
                                        stringLiteral.append('\n');
                                        continue block125;
                                    }
                                    case 'r': {
                                        this.consume();
                                        stringLiteral.append('\r');
                                        continue block125;
                                    }
                                }
                                stringLiteral.append(this.consume());
                                continue block125;
                            }
                            case '\n': 
                            case '\r': 
                            case '\uffff': {
                                throw new UnterminatedStringLiteralException(this.getStartLine(), this.getStartColumn());
                            }
                            case '\'': {
                                this.consume();
                                break block125;
                            }
                            default: {
                                stringLiteral.append(this.consume());
                                continue block125;
                            }
                        }
                        break;
                    }
                    token = Token.singleQuoteString(this.getStartLine(), this.getStartColumn(), stringLiteral.toString());
                    continue block118;
                }
                case '\"': {
                    this.mark();
                    this.consume();
                    StringBuffer stringLiteral = new StringBuffer();
                    boolean tripleQuoted = false;
                    if (this.la() == '\"' && this.la(2) == '\"') {
                        tripleQuoted = true;
                        this.consume();
                        this.consume();
                    }
                    block126: while (true) {
                        char x = c = this.la();
                        switch (c) {
                            case '\\': {
                                this.consume();
                                c = this.la();
                                switch (c) {
                                    case 't': {
                                        this.consume();
                                        stringLiteral.append('\t');
                                        continue block126;
                                    }
                                    case 'n': {
                                        this.consume();
                                        stringLiteral.append('\n');
                                        continue block126;
                                    }
                                    case 'r': {
                                        this.consume();
                                        stringLiteral.append('\r');
                                        continue block126;
                                    }
                                }
                                stringLiteral.append(this.consume());
                                continue block126;
                            }
                            case '\"': {
                                if (!tripleQuoted) {
                                    this.consume();
                                    break block126;
                                }
                                if (this.la(2) == '\"' && this.la(3) == '\"') {
                                    this.consume();
                                    this.consume();
                                    this.consume();
                                    break block126;
                                }
                                stringLiteral.append(this.consume());
                                continue block126;
                            }
                            case '\uffff': {
                                throw new UnterminatedStringLiteralException(this.getStartLine(), this.getStartColumn());
                            }
                            default: {
                                stringLiteral.append(this.consume());
                                continue block126;
                            }
                        }
                        break;
                    }
                    token = Token.doubleQuoteString(this.getStartLine(), this.getStartColumn(), stringLiteral.toString());
                    continue block118;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.mark();
                    StringBuffer numericLiteral = new StringBuffer();
                    boolean isFloat = false;
                    while (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9') {
                        numericLiteral.append(this.consume());
                        c = this.la();
                    }
                    if (c == '.' && (c = this.la(2)) != '.') {
                        while (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9') {
                            if (!isFloat) {
                                numericLiteral.append(this.consume());
                            }
                            isFloat = true;
                            numericLiteral.append(this.consume());
                            c = this.la();
                        }
                    }
                    if (isFloat) {
                        token = Token.floatNumber(this.getStartLine(), this.getStartColumn(), numericLiteral.toString());
                        continue block118;
                    }
                    token = Token.integerNumber(this.getStartLine(), this.getStartColumn(), numericLiteral.toString());
                    continue block118;
                }
                default: {
                    this.mark();
                    if (Character.isJavaIdentifierStart(c)) {
                        StringBuffer identifier = new StringBuffer();
                        identifier.append(this.consume());
                        while (Character.isJavaIdentifierPart(c = this.la())) {
                            identifier.append(this.consume());
                        }
                        token = Token.keyword(this.getStartLine(), this.getStartColumn(), identifier.toString());
                        if (token != null) continue block118;
                        token = Token.identifier(this.getStartLine(), this.getStartColumn(), identifier.toString());
                        continue block118;
                    }
                    throw new UnexpectedCharacterException(this.getStartLine(), this.getStartColumn() + 1, c, new char[0]);
                }
            }
        }
        return token;
    }

    protected void eol() {
        ++this.line;
        this.column = 1;
    }

    protected void mark() {
        this.startLine = this.line;
        this.startColumn = this.column;
    }

    protected int getStartLine() {
        return this.startLine;
    }

    protected int getStartColumn() {
        return this.startColumn;
    }

    protected char la() throws UnexpectedCharacterException, ReadException {
        return this.la(1);
    }

    protected char la(int k) throws UnexpectedCharacterException, ReadException {
        if (k > this.charsInBuffer) {
            if (k > this.buf.length) {
                throw new LookAheadExhaustionError(k);
            }
            int i = 0;
            while (i != this.charsInBuffer) {
                this.buf[i] = this.buf[this.cur];
                this.charWidth[i] = this.charWidth[this.cur];
                ++i;
                ++this.cur;
            }
            this.fillBuffer();
        }
        return this.buf[this.cur + k - 1];
    }

    protected char consume() throws UnexpectedCharacterException, ReadException {
        if (this.charsInBuffer == 0) {
            this.fillBuffer();
        }
        --this.charsInBuffer;
        this.column += this.charWidth[this.cur];
        return this.buf[this.cur++];
    }

    private void fillBuffer() throws ReadException, UnexpectedCharacterException {
        this.cur = 0;
        do {
            if (this.eosRead) {
                this.buf[this.charsInBuffer] = 65535;
                continue;
            }
            char c = this.escapeLookahead ? this.escapeLookaheadChar : this.charStream.consume();
            this.escapeLookahead = false;
            this.charWidth[this.charsInBuffer] = 1;
            if (c == '\uffff') {
                this.eosRead = true;
            }
            if (c == '\\') {
                c = this.charStream.consume();
                if (c == 'u') {
                    do {
                        int n = this.charsInBuffer;
                        this.charWidth[n] = this.charWidth[n] + 1;
                    } while ((c = (char)this.charStream.consume()) == 117);
                    try {
                        c = (char)Integer.parseInt(new String(new char[]{c, this.charStream.consume(), this.charStream.consume(), this.charStream.consume()}), 16);
                        int n = this.charsInBuffer;
                        this.charWidth[n] = this.charWidth[n] + 4;
                    }
                    catch (NumberFormatException e) {
                        throw new UnexpectedCharacterException(this.getStartLine(), this.getStartColumn() + 1, c, new char[0]);
                    }
                } else {
                    this.escapeLookahead = true;
                    this.escapeLookaheadChar = c;
                    c = '\\';
                }
            }
            this.buf[this.charsInBuffer] = c;
        } while (++this.charsInBuffer != this.buf.length);
    }
}

