/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.ClassGenerator;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.lexer.CharStream;
import org.codehaus.groovy.syntax.lexer.InputStreamCharStream;
import org.codehaus.groovy.syntax.lexer.Lexer;
import org.codehaus.groovy.syntax.lexer.LexerTokenStream;
import org.codehaus.groovy.syntax.parser.ASTBuilder;
import org.codehaus.groovy.syntax.parser.CSTNode;
import org.codehaus.groovy.syntax.parser.Parser;
import org.codehaus.groovy.syntax.parser.RuntimeParserException;
import org.codehaus.groovy.tools.ExceptionCollector;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public abstract class CompilerFacade {
    private static final boolean DEBUGGING = false;
    private Verifier verifier = new Verifier();
    private ClassLoader classLoader;
    private CompileUnit unit;

    public CompilerFacade(ClassLoader classLoader, CompileUnit unit) {
        this.classLoader = classLoader;
        this.unit = unit;
    }

    public void parseClass(InputStream in, String file) throws SyntaxException, IOException {
        try {
            this.parseClass(new InputStreamCharStream(in), file);
        }
        catch (SyntaxException e) {
            try {
                in.close();
            }
            catch (Exception hide) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeParserException e) {
            e.throwParserException();
        }
        catch (IOException e) {
            try {
                in.close();
            }
            catch (Exception hide) {
                // empty catch block
            }
            throw e;
        }
        in.close();
    }

    public void generateClass(GeneratorContext context, ClassNode classNode, String file) {
        this.verifier.visitClass(classNode);
        ClassWriter classWriter = new ClassWriter(true);
        ClassGenerator generator = new ClassGenerator(context, (ClassVisitor)classWriter, this.classLoader, file);
        generator.visitClass(classNode);
        this.onClass(classWriter, classNode);
        LinkedList innerClasses = new LinkedList(generator.getInnerClasses());
        generator.getInnerClasses().clear();
        while (!innerClasses.isEmpty()) {
            ClassNode innerNode = (ClassNode)innerClasses.removeFirst();
            this.generateClass(context, innerNode, file);
        }
    }

    protected void parseClass(CharStream charStream, String file) throws SyntaxException, IOException {
        try {
            Lexer lexer = new Lexer(charStream);
            Parser parser = new Parser(new LexerTokenStream(lexer));
            CSTNode compilationUnit = parser.compilationUnit();
            ASTBuilder astBuilder = new ASTBuilder(this.classLoader);
            ModuleNode module = astBuilder.build(compilationUnit);
            this.unit.addModule(module);
            module.setDescription(file);
            GeneratorContext context = new GeneratorContext(this.unit);
            Iterator iter = module.getClasses().iterator();
            while (iter.hasNext()) {
                this.generateClass(context, (ClassNode)iter.next(), file);
            }
        }
        catch (ReadException e) {
            throw e.getIOCause();
        }
        catch (ExceptionCollector e) {
            throw (SyntaxException)e.get(0);
        }
    }

    protected abstract void onClass(ClassWriter var1, ClassNode var2);
}

