/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.factory;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPTLSSocketFactory;

public class JSSESocketFactory
implements LDAPTLSSocketFactory,
Serializable {
    static final long serialVersionUID = 6834205777733266610L;
    protected String[] suites;
    protected SSLSocketFactory factory;

    public JSSESocketFactory() {
        this(null, null);
    }

    public JSSESocketFactory(String[] stringArray) {
        this(stringArray, null);
    }

    public JSSESocketFactory(String[] stringArray, SSLSocketFactory sSLSocketFactory) {
        this.suites = stringArray;
        this.factory = sSLSocketFactory != null ? sSLSocketFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public Socket makeSocket(String string, int n) throws LDAPException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)this.factory.createSocket(string, n);
            if (this.suites != null) {
                sSLSocket.setEnabledCipherSuites(this.suites);
            }
            sSLSocket.startHandshake();
        }
        catch (UnknownHostException unknownHostException) {
            throw new LDAPException("JSSESocketFactory.makeSocket - Unknown host: " + string, 91);
        }
        catch (IOException iOException) {
            throw new LDAPException("JSSESocketFactory.makeSocket " + string + ":" + n + ", " + iOException.getMessage(), 91);
        }
        return sSLSocket;
    }

    public Socket makeSocket(Socket socket) throws LDAPException {
        SSLSocket sSLSocket = null;
        String string = socket.getInetAddress().getHostName();
        int n = socket.getPort();
        try {
            sSLSocket = (SSLSocket)this.factory.createSocket(socket, string, n, true);
            if (this.suites != null) {
                sSLSocket.setEnabledCipherSuites(this.suites);
            }
            sSLSocket.startHandshake();
        }
        catch (IOException iOException) {
            throw new LDAPException("JSSESocketFactory - start TLS, " + iOException.getMessage(), 112);
        }
        return sSLSocket;
    }
}

