/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BEROctetString
extends BERElement {
    private byte[] m_value = null;

    public BEROctetString(String string) {
        if (string == null) {
            return;
        }
        try {
            this.m_value = string.getBytes("UTF8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public BEROctetString(byte[] byArray) {
        this.m_value = byArray;
    }

    public BEROctetString(byte[] byArray, int n, int n2) {
        this.m_value = new byte[n2 - n];
        for (int i = 0; i < n2 - n; ++i) {
            this.m_value[i] = byArray[n + i];
        }
    }

    public BEROctetString(BERTagDecoder bERTagDecoder, InputStream inputStream, int[] nArray) throws IOException {
        int n = BERElement.readLengthOctets(inputStream, nArray);
        int[] nArray2 = new int[1];
        BERElement bERElement = null;
        if (n == -1) {
            do {
                nArray2[0] = 0;
                bERElement = BEROctetString.getElement(bERTagDecoder, inputStream, nArray2);
                if (bERElement == null) continue;
                BEROctetString bEROctetString = (BEROctetString)bERElement;
                byte[] byArray = bEROctetString.getValue();
                if (this.m_value == null) {
                    this.m_value = new byte[byArray.length];
                    System.arraycopy(byArray, 0, this.m_value, 0, byArray.length);
                    continue;
                }
                byte[] byArray2 = new byte[this.m_value.length + byArray.length];
                System.arraycopy(this.m_value, 0, byArray2, 0, this.m_value.length);
                System.arraycopy(byArray, 0, byArray2, this.m_value.length, byArray.length);
                this.m_value = byArray2;
            } while (bERElement != null);
        } else {
            nArray[0] = nArray[0] + n;
            this.m_value = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n; i += n2) {
                n2 = inputStream.read(this.m_value, i, n - i);
            }
        }
    }

    public BEROctetString(InputStream inputStream, int[] nArray) throws IOException {
        int n = BERElement.readLengthOctets(inputStream, nArray);
        if (n > 0) {
            this.m_value = new byte[n];
            for (int i = 0; i < n; ++i) {
                this.m_value[i] = (byte)inputStream.read();
            }
            nArray[0] = nArray[0] + n;
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(4);
        if (this.m_value == null) {
            BEROctetString.sendDefiniteLength(outputStream, 0);
        } else {
            BEROctetString.sendDefiniteLength(outputStream, this.m_value.length);
            outputStream.write(this.m_value, 0, this.m_value.length);
        }
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public int getType() {
        return 4;
    }

    public String toString() {
        if (this.m_value == null) {
            return "OctetString (null)";
        }
        StringBuffer stringBuffer = new StringBuffer("OctetString {");
        for (int i = 0; i < this.m_value.length; ++i) {
            if (i != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.byteToHexString(this.m_value[i]));
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

