/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.NonStringException;
import freemarker.core.Range;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;

final class DynamicKeyName
extends Expression {
    private final Expression nameExpression;
    private final Expression target;

    DynamicKeyName(Expression target, Expression nameExpression) {
        this.target = target;
        this.nameExpression = nameExpression;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel targetModel = this.target.getAsTemplateModel(env);
        DynamicKeyName.assertNonNull(targetModel, this.target, env);
        if (this.nameExpression instanceof Range) {
            return this.dealWithRangeKey(targetModel, (Range)this.nameExpression, env);
        }
        TemplateModel keyModel = this.nameExpression.getAsTemplateModel(env);
        if (keyModel == null) {
            if (env.isClassicCompatible()) {
                keyModel = TemplateScalarModel.EMPTY_STRING;
            } else {
                DynamicKeyName.assertNonNull(keyModel, this.nameExpression, env);
            }
        }
        if (keyModel instanceof TemplateNumberModel) {
            int index = EvaluationUtil.getNumber(keyModel, this.nameExpression, env).intValue();
            return this.dealWithNumericalKey(targetModel, index, env);
        }
        if (keyModel instanceof TemplateScalarModel) {
            String key = EvaluationUtil.getString((TemplateScalarModel)keyModel, this.nameExpression, env);
            return this.dealWithStringKey(targetModel, key, env);
        }
        throw DynamicKeyName.invalidTypeException(keyModel, this.nameExpression, env, "number, range, or string");
    }

    private TemplateModel dealWithNumericalKey(TemplateModel targetModel, int index, Environment env) throws TemplateException {
        if (targetModel instanceof TemplateSequenceModel) {
            TemplateSequenceModel tsm = (TemplateSequenceModel)targetModel;
            int size = Integer.MAX_VALUE;
            try {
                size = tsm.size();
            }
            catch (Exception e) {
                // empty catch block
            }
            return index < size ? tsm.get(index) : null;
        }
        try {
            String s = this.target.getStringValue(env);
            try {
                return new SimpleScalar(s.substring(index, index + 1));
            }
            catch (RuntimeException re) {
                throw new TemplateException("", re, env);
            }
        }
        catch (NonStringException e) {
            throw DynamicKeyName.invalidTypeException(targetModel, this.target, env, "number, sequence, or string");
        }
    }

    private TemplateModel dealWithStringKey(TemplateModel targetModel, String key, Environment env) throws TemplateException {
        if (targetModel instanceof TemplateHashModel) {
            return ((TemplateHashModel)targetModel).get(key);
        }
        throw DynamicKeyName.invalidTypeException(targetModel, this.target, env, "hash");
    }

    private TemplateModel dealWithRangeKey(TemplateModel targetModel, Range range, Environment env) throws TemplateException {
        int start = EvaluationUtil.getNumber(range.left, env).intValue();
        int end = EvaluationUtil.getNumber(range.right, env).intValue();
        if (targetModel instanceof TemplateSequenceModel) {
            TemplateSequenceModel sequence = (TemplateSequenceModel)targetModel;
            ArrayList<TemplateModel> list = new ArrayList<TemplateModel>(1 + Math.abs(start - end));
            if (start > end) {
                for (int i = start; i >= end; --i) {
                    list.add(sequence.get(i));
                }
            } else {
                for (int i = start; i <= end; ++i) {
                    list.add(sequence.get(i));
                }
            }
            return new SimpleSequence(list);
        }
        try {
            String s = this.target.getStringValue(env);
            try {
                return new SimpleScalar(s.substring(start, end + 1));
            }
            catch (RuntimeException re) {
                String msg = "Error " + this.getStartLocation();
                throw new TemplateException(msg, re, env);
            }
        }
        catch (NonStringException e) {
            throw DynamicKeyName.invalidTypeException(this.target.getAsTemplateModel(env), this.target, env, "number, scalar, or sequence");
        }
    }

    public String getCanonicalForm() {
        return this.target.getCanonicalForm() + "[" + this.nameExpression.getCanonicalForm() + "]";
    }

    boolean isLiteral() {
        return this.constantValue != null || this.target.isLiteral() && this.nameExpression.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new DynamicKeyName(this.target.deepClone(name, subst), this.nameExpression.deepClone(name, subst));
    }
}

