/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class SandlerUtilities {
    public static final String RFC_822_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z";
    public static final String UTC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String PATTERN_ESCAPEDCONTENT = "\\&(\\w+)\\;";
    public static final Pattern ESCAPED_PATTERN_OBJECT = Pattern.compile("\\&(\\w+)\\;");
    private static final ThreadLocal UTC_DATE_FORMAT_OBJECT = new ThreadLocal(){

        protected Object initialValue() {
            return new SimpleDateFormat(SandlerUtilities.UTC_DATE_FORMAT);
        }
    };

    private SandlerUtilities() {
    }

    public static String getUTCDate(Date date) {
        String utcDate = null;
        if (date != null) {
            utcDate = ((SimpleDateFormat)UTC_DATE_FORMAT_OBJECT.get()).format(date).replaceAll("GMT", "");
        }
        return utcDate;
    }

    public static Date getDateFromUTCDate(String date) throws ParseException {
        Date result = null;
        if (date != null) {
            result = ((SimpleDateFormat)UTC_DATE_FORMAT_OBJECT.get()).parse(date);
        }
        return result;
    }

    public static String downloadUrl(String url) {
        String result = null;
        if (url != null) {
            try {
                URL downloadUrl = new URL(url);
                if (downloadUrl.getProtocol().startsWith("http")) {
                    int n;
                    HttpURLConnection http = (HttpURLConnection)downloadUrl.openConnection();
                    http.setRequestProperty("User-Agent", "Sandler/1.0");
                    BufferedInputStream in = new BufferedInputStream(http.getInputStream());
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((n = in.read(buffer, 0, 4096)) >= 0) {
                        os.write(buffer, 0, n);
                    }
                    os.close();
                    in.close();
                    http.disconnect();
                    result = os.toString();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String escapeString(String input) {
        if (input == null) {
            return null;
        }
        String unescaped = SandlerUtilities.replace(input, "&", "&amp;");
        unescaped = SandlerUtilities.replace(unescaped, "<", "&lt;");
        unescaped = SandlerUtilities.replace(unescaped, ">", "&gt;");
        unescaped = SandlerUtilities.replace(unescaped, "\"", "&quot;");
        unescaped = SandlerUtilities.replace(unescaped, "'", "&apos;");
        return unescaped;
    }

    public static String replace(String str, String pattern, String replace) {
        if (str == null || "".equals(str)) {
            return str;
        }
        if (replace == null) {
            return str;
        }
        if ("".equals(pattern)) {
            return str;
        }
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static boolean containsEscapedContent(String content) {
        return ESCAPED_PATTERN_OBJECT.matcher(content).find();
    }
}

