/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.builders;

import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.intabulas.sandler.builders.SyndicationBuilder;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.elements.Generator;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.elements.impl.AbstractEntryElement;
import org.intabulas.sandler.elements.impl.ContentImpl;
import org.intabulas.sandler.elements.impl.EntryImpl;
import org.intabulas.sandler.elements.impl.FeedImpl;
import org.intabulas.sandler.elements.impl.GeneratorImpl;
import org.intabulas.sandler.elements.impl.LinkImpl;
import org.intabulas.sandler.elements.impl.PersonImpl;
import org.intabulas.sandler.util.SandlerUtilities;

public class StaxBuilder
implements SyndicationBuilder {
    private Logger _logger = Logger.getLogger((class$org$intabulas$sandler$builders$StaxBuilder == null ? (class$org$intabulas$sandler$builders$StaxBuilder = StaxBuilder.class$("org.intabulas.sandler.builders.StaxBuilder")) : class$org$intabulas$sandler$builders$StaxBuilder).getName());
    static /* synthetic */ Class class$org$intabulas$sandler$builders$StaxBuilder;

    public StaxBuilder() {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.bea.xml.stream.MXParserFactory");
    }

    public Feed parseInput(InputStream in) {
        return this.parseInput(in, "UTF-8");
    }

    public Feed parseInput(InputStream in, String encoding) {
        FeedImpl result = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(in, encoding);
            result = new FeedImpl();
            this.loadFeedDocument(parser, result);
        }
        catch (XMLStreamException e) {
            this._logger.log(Level.SEVERE, "Unable to load feed", e);
        }
        return result;
    }

    public Entry parseEntryInput(InputStream in) {
        return this.parseEntryInput(in, "UTF-8");
    }

    public Entry parseEntryInput(InputStream in, String encoding) {
        EntryImpl result = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(in, encoding);
            result = new EntryImpl();
            this.loadEntryDocument(parser, result);
        }
        catch (XMLStreamException e) {
            this._logger.log(Level.SEVERE, "Unable to load entry", e);
        }
        return result;
    }

    private void loadFeedDocument(XMLStreamReader parser, Feed feed) throws XMLStreamException {
        int eventType = parser.next();
        do {
            if (eventType != 1 || !parser.getLocalName().equalsIgnoreCase("feed")) continue;
            this.processFeedDocumentAttributes(parser, feed);
            this.processFeedDocumentElements(parser, feed);
        } while ((eventType = parser.next()) != 8);
    }

    private void processFeedDocumentElements(XMLStreamReader parser, Feed feed) throws XMLStreamException {
        String entityName = null;
        int eventType = parser.next();
        do {
            if (eventType == 1) {
                entityName = parser.getLocalName();
                if (entityName.equalsIgnoreCase("title")) {
                    this.processTitleTag(parser, (AbstractEntryElement)((Object)feed));
                } else if (entityName.equalsIgnoreCase("link")) {
                    LinkImpl link = new LinkImpl();
                    this.loadLinkDocument(parser, link);
                    feed.addLink(link);
                } else if (entityName.equalsIgnoreCase("id")) {
                    this.processIdTag(parser, (AbstractEntryElement)((Object)feed));
                } else if (entityName.equalsIgnoreCase("modified")) {
                    this.processModifiedTag(parser, (AbstractEntryElement)((Object)feed));
                } else if (entityName.equalsIgnoreCase("tagline")) {
                    this.processTaglineTag(parser, feed);
                } else if (entityName.equalsIgnoreCase("info")) {
                    this.processInfoTag(parser, feed);
                } else if (entityName.equalsIgnoreCase("copyright")) {
                    this.processCopyrightTag(parser, feed);
                } else if (entityName.equalsIgnoreCase("generator")) {
                    GeneratorImpl generator = new GeneratorImpl();
                    this.loadGeneratorDocument(parser, generator);
                    feed.setGenerator(generator);
                } else if (entityName.equalsIgnoreCase("entry")) {
                    EntryImpl entry = new EntryImpl();
                    this.loadEntryDocument(parser, entry);
                    feed.addEntry(entry);
                } else if (entityName.equalsIgnoreCase("author")) {
                    PersonImpl author = new PersonImpl();
                    this.loadPersonDocument(parser, author);
                    feed.setAuthor(author);
                } else if (entityName.equalsIgnoreCase("contributor")) {
                    PersonImpl contrib = new PersonImpl();
                    this.loadPersonDocument(parser, contrib);
                    feed.addContributor(contrib);
                }
            }
            try {
                eventType = parser.next();
            }
            catch (XMLStreamException e) {
                this._logger.log(Level.SEVERE, "Unable to process feed document elements", e);
                throw e;
            }
        } while (eventType != 2 || !"feed".equals(parser.getLocalName()));
    }

    private void processFeedDocumentAttributes(XMLStreamReader parser, Feed feed) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeLocalName(x).equals("version")) {
                feed.setVersion(parser.getAttributeValue(x));
            }
            if (!parser.getAttributeLocalName(x).equals("lang")) continue;
            feed.setLanguage(parser.getAttributeValue(x));
        }
    }

    private void processTitleTag(XMLStreamReader parser, AbstractEntryElement element) throws XMLStreamException {
        ContentImpl content = new ContentImpl();
        this.loadContentDocument(parser, content);
        element.setTitle(content);
    }

    private void processCopyrightTag(XMLStreamReader parser, Feed feed) throws XMLStreamException {
        ContentImpl content = new ContentImpl();
        this.loadContentDocument(parser, content);
        feed.setCopyright(content);
    }

    private void processIdTag(XMLStreamReader parser, AbstractEntryElement element) {
        try {
            element.setId(parser.getElementText());
        }
        catch (XMLStreamException e) {
            this._logger.log(Level.SEVERE, "Unable to process ID tag", e);
        }
    }

    private void processTaglineTag(XMLStreamReader parser, Feed feed) throws XMLStreamException {
        ContentImpl content = new ContentImpl();
        this.loadContentDocument(parser, content);
        feed.setTagline(content);
    }

    private void processInfoTag(XMLStreamReader parser, Feed feed) throws XMLStreamException {
        ContentImpl content = new ContentImpl();
        this.loadContentDocument(parser, content);
        feed.setInfo(content);
    }

    private void processModifiedTag(XMLStreamReader parser, AbstractEntryElement feed) {
        try {
            feed.setModified(SandlerUtilities.getDateFromUTCDate(parser.getElementText()));
        }
        catch (ParseException e) {
            this._logger.log(Level.SEVERE, "Unable to process modified tag", e);
            feed.setModified(new Date());
        }
        catch (XMLStreamException e) {
            this._logger.log(Level.SEVERE, "Unable to process modified tag", e);
            feed.setModified(new Date());
        }
    }

    public void loadGeneratorDocument(XMLStreamReader parser, Generator generator) {
        this.processGeneratorAttributes(parser, generator);
        try {
            generator.setName(parser.getElementText());
        }
        catch (XMLStreamException e) {
            this._logger.log(Level.SEVERE, "Unable to process generator tag", e);
        }
    }

    private void processGeneratorAttributes(XMLStreamReader parser, Generator generator) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeLocalName(x).equals("url")) {
                generator.setUri(parser.getAttributeValue(x));
                continue;
            }
            if (!parser.getAttributeLocalName(x).equals("version")) continue;
            generator.setVersion(parser.getAttributeValue(x));
        }
    }

    public void loadPersonDocument(XMLStreamReader parser, Person person) throws XMLStreamException {
        try {
            parser.next();
        }
        catch (XMLStreamException e) {
            this._logger.log(Level.SEVERE, "Unable to process person tag", e);
        }
        int eventType = parser.getEventType();
        boolean endElement = false;
        do {
            if (eventType == 2) {
                endElement = true;
            } else if (eventType == 1) {
                if (parser.getLocalName().equals("name")) {
                    try {
                        person.setName(parser.getElementText());
                    }
                    catch (XMLStreamException e) {
                        this._logger.log(Level.SEVERE, "Unable to process person name", e);
                    }
                } else if (parser.getLocalName().equals("email")) {
                    try {
                        String content = parser.getElementText();
                        person.setEmail(content);
                    }
                    catch (XMLStreamException e) {
                        this._logger.log(Level.SEVERE, "Unable to process person e-mail", e);
                    }
                } else if (parser.getLocalName().equals("url")) {
                    try {
                        person.setUrl(parser.getElementText());
                    }
                    catch (XMLStreamException e) {
                        this._logger.log(Level.SEVERE, "Unable to process person URL", e);
                    }
                } else if (parser.getLocalName().equals("homepage")) {
                    try {
                        person.setUrl(parser.getElementText());
                    }
                    catch (XMLStreamException e) {
                        this._logger.log(Level.SEVERE, "Unable to process person homepage", e);
                    }
                }
            }
            try {
                eventType = parser.next();
            }
            catch (XMLStreamException e) {
                this._logger.log(Level.SEVERE, "Unable to process person tag", e);
                throw e;
            }
        } while (!endElement);
    }

    public void loadLinkDocument(XMLStreamReader parser, Link link) {
        this.processLinkAttributes(parser, link);
    }

    private void processLinkAttributes(XMLStreamReader parser, Link link) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeLocalName(x).equals("rel")) {
                link.setRelationship(parser.getAttributeValue(x));
                continue;
            }
            if (parser.getAttributeLocalName(x).equals("type")) {
                link.setType(parser.getAttributeValue(x));
                continue;
            }
            if (parser.getAttributeLocalName(x).equals("href")) {
                link.setHref(parser.getAttributeValue(x));
                continue;
            }
            if (!parser.getAttributeLocalName(x).equals("title")) continue;
            link.setTitle(parser.getAttributeValue(x));
        }
    }

    public void loadContentDocument(XMLStreamReader parser, Content content) throws XMLStreamException {
        int eventType = parser.getEventType();
        String elementName = parser.getLocalName();
        boolean endElement = false;
        StringBuffer buffer = new StringBuffer();
        do {
            if (eventType == 2) {
                endElement = true;
            } else if (eventType == 4) {
                int start = parser.getTextStart();
                int length = parser.getTextLength();
                buffer.append(new String(parser.getTextCharacters(), start, length));
            } else if (eventType == 1) {
                if (elementName == null) {
                    elementName = parser.getLocalName();
                }
                this.processDocumentAttributes(parser, content);
            }
            try {
                eventType = parser.next();
            }
            catch (XMLStreamException e) {
                this._logger.log(Level.SEVERE, "Unable to process content document", e);
                throw e;
            }
        } while (!endElement);
        content.setBody(buffer.toString());
    }

    private void processDocumentAttributes(XMLStreamReader parser, Content content) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeLocalName(x).equals("mode")) {
                content.setMode(parser.getAttributeValue(x));
                continue;
            }
            if (!parser.getAttributeLocalName(x).equals("type")) continue;
            content.setMimeType(parser.getAttributeValue(x));
        }
    }

    public void loadEntryDocument(XMLStreamReader parser, Entry element) throws XMLStreamException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 1) {
                ContentImpl content;
                if (parser.getLocalName().equalsIgnoreCase("title")) {
                    content = new ContentImpl();
                    this.loadContentDocument(parser, content);
                    element.setTitle(content);
                } else if (parser.getLocalName().equalsIgnoreCase("link")) {
                    LinkImpl link = new LinkImpl();
                    this.loadLinkDocument(parser, link);
                    element.addLink(link);
                } else if (parser.getLocalName().equalsIgnoreCase("id")) {
                    try {
                        element.setId(parser.getElementText());
                    }
                    catch (XMLStreamException e) {
                        this._logger.log(Level.SEVERE, "Unable to process entry ID", e);
                    }
                } else if (parser.getLocalName().equalsIgnoreCase("summary")) {
                    content = new ContentImpl();
                    this.loadContentDocument(parser, content);
                    element.setSummary(content);
                } else if (parser.getLocalName().equalsIgnoreCase("modified")) {
                    this.processModifiedTag(parser, (AbstractEntryElement)((Object)element));
                } else if (parser.getLocalName().equalsIgnoreCase("issued")) {
                    this.processIssuedTag(parser, element);
                } else if (parser.getLocalName().equalsIgnoreCase("created")) {
                    this.processCreatedTag(parser, element);
                } else if (parser.getLocalName().equalsIgnoreCase("author")) {
                    PersonImpl author = new PersonImpl();
                    this.loadPersonDocument(parser, author);
                    element.setAuthor(author);
                } else if (parser.getLocalName().equalsIgnoreCase("content")) {
                    content = new ContentImpl();
                    this.loadContentDocument(parser, content);
                    element.addContent(content);
                } else if (parser.getLocalName().equalsIgnoreCase("contributor")) {
                    PersonImpl contrib = new PersonImpl();
                    this.loadPersonDocument(parser, contrib);
                    element.addContributor(contrib);
                }
            }
            try {
                eventType = parser.next();
            }
            catch (XMLStreamException e) {
                this._logger.log(Level.SEVERE, "Unable to process entry document", e);
                throw e;
            }
        } while (eventType != 2 || !"entry".equals(parser.getLocalName()));
    }

    private void processCreatedTag(XMLStreamReader parser, Entry entry) {
        try {
            entry.setCreated(SandlerUtilities.getDateFromUTCDate(parser.getElementText()));
        }
        catch (ParseException e) {
            this._logger.log(Level.SEVERE, "Unable to process created tag date", e);
            entry.setCreated(new Date());
        }
        catch (XMLStreamException e) {
            this._logger.log(Level.SEVERE, "Unable to process created tag", e);
            entry.setCreated(new Date());
        }
    }

    private void processIssuedTag(XMLStreamReader parser, Entry entry) {
        try {
            entry.setIssued(SandlerUtilities.getDateFromUTCDate(parser.getElementText()));
        }
        catch (ParseException e) {
            this._logger.log(Level.SEVERE, "Unable to process issued tag date", e);
            entry.setIssued(new Date());
        }
        catch (XMLStreamException e) {
            this._logger.log(Level.SEVERE, "Unable to process created tag", e);
            entry.setCreated(new Date());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

