/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.authentication;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.intabulas.sandler.AtomConstants;
import org.intabulas.sandler.authentication.AuthenticationException;
import org.intabulas.sandler.authentication.DigestUtilities;
import org.intabulas.sandler.util.Base64;

public class AtomAuthentication
implements AtomConstants {
    Logger _logger = Logger.getLogger((class$org$intabulas$sandler$authentication$AtomAuthentication == null ? (class$org$intabulas$sandler$authentication$AtomAuthentication = AtomAuthentication.class$("org.intabulas.sandler.authentication.AtomAuthentication")) : class$org$intabulas$sandler$authentication$AtomAuthentication).getName());
    private String _username;
    private String _nonce;
    private String _response;
    private String _created;
    static /* synthetic */ Class class$org$intabulas$sandler$authentication$AtomAuthentication;

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String _username) {
        this._username = _username;
    }

    public AtomAuthentication(String authHeader) {
        this.parseAuthHeader(authHeader);
    }

    private void parseAuthHeader(String header) {
        String[] tokens = header.split(",");
        for (int x = 0; x < tokens.length; ++x) {
            int index = tokens[x].indexOf(61);
            if (index == -1) continue;
            String key = tokens[x].substring(0, index).trim();
            String value = tokens[x].substring(index + 1).trim();
            value = value.replaceAll("\"", "");
            if (key.startsWith("UsernameToken")) {
                key = key.substring(ATOM_PROFILE_KEY_LENGTH).trim();
            }
            if (key.equalsIgnoreCase("username")) {
                this._username = value;
                continue;
            }
            if (key.equalsIgnoreCase("nonce")) {
                this._nonce = value;
                continue;
            }
            if (key.equalsIgnoreCase("passworddigest")) {
                this._response = value;
                continue;
            }
            if (!key.equalsIgnoreCase("created")) continue;
            this._created = value;
        }
    }

    public boolean authenticate(String password) throws AuthenticationException {
        String nonce = null;
        try {
            nonce = new String(Base64.decode(this._nonce));
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Unable to deconstruct nonce", e);
        }
        String base64 = "";
        byte[] digest = DigestUtilities.digestStringEx(nonce + this._created + password);
        try {
            base64 = Base64.encode(digest);
        }
        catch (IOException e) {
            this._logger.log(Level.WARNING, "Unable to construct nonce", e);
        }
        return base64.equals(this._response);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

