/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2006 Blender Foundation.
 * All rights reserved.
 */

/** \file
 * \ingroup bke
 * \brief Generic geometry attributes built on CustomData.
 */

#pragma once

#include "BLI_sys_types.h"

#include "BKE_customdata.h"

#ifdef __cplusplus
extern "C" {
#endif

struct CustomData;
struct CustomDataLayer;
struct ID;
struct PointerRNA;
struct ReportList;

/* Attribute.domain */
typedef enum AttributeDomain {
  ATTR_DOMAIN_VERTEX = 0,  /* Mesh Vertex */
  ATTR_DOMAIN_EDGE = 1,    /* Mesh Edge */
  ATTR_DOMAIN_CORNER = 2,  /* Mesh Corner */
  ATTR_DOMAIN_POLYGON = 3, /* Mesh Polygon */

  ATTR_DOMAIN_POINT = 4, /* Hair or PointCloud Point */
  ATTR_DOMAIN_CURVE = 5, /* Hair Curve */

  ATTR_DOMAIN_NUM
} AttributeDomain;

/* Attributes */

bool BKE_id_attributes_supported(struct ID *id);

struct CustomDataLayer *BKE_id_attribute_new(struct ID *id,
                                             const char *name,
                                             const int type,
                                             const AttributeDomain domain,
                                             struct ReportList *reports);
bool BKE_id_attribute_remove(struct ID *id,
                             struct CustomDataLayer *layer,
                             struct ReportList *reports);

AttributeDomain BKE_id_attribute_domain(struct ID *id, struct CustomDataLayer *layer);
int BKE_id_attribute_data_length(struct ID *id, struct CustomDataLayer *layer);
bool BKE_id_attribute_required(struct ID *id, struct CustomDataLayer *layer);
bool BKE_id_attribute_rename(struct ID *id,
                             struct CustomDataLayer *layer,
                             const char *new_name,
                             struct ReportList *reports);

int BKE_id_attributes_length(struct ID *id, const CustomDataMask mask);

struct CustomDataLayer *BKE_id_attributes_active_get(struct ID *id);
void BKE_id_attributes_active_set(struct ID *id, struct CustomDataLayer *layer);
int *BKE_id_attributes_active_index_p(struct ID *id);

CustomData *BKE_id_attributes_iterator_next_domain(struct ID *id, struct CustomDataLayer *layers);

#ifdef __cplusplus
}
#endif
