;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt --memory-packing -all --zero-filled-memory      -S -o - | filecheck %s
;; RUN: foreach %s %t wasm-opt --memory-packing -all --zero-filled-memory -tnh -S -o - | filecheck %s --check-prefix=TNH__

(module
  ;; We should not optimize out a segment that will trap, as that is an effect
  ;; we need to preserve (unless TrapsNeverHappen).
  ;; CHECK:      (memory $memory 1 2)
  ;; TNH__:      (memory $memory 1 2)
  (memory $memory 1 2)
  ;; CHECK:      (data $data (i32.const -1) "\00")
  (data $data (i32.const -1) "\00")
)

(module
  ;; We should handle the possible overflow in adding the offset and size, and
  ;; see this might trap. To keep the segment trapping, we will emit a segment
  ;; with offset -1 of size 1 (which is the minimal thing we need for a trap).
  ;; CHECK:      (memory $memory 1 2)
  ;; TNH__:      (memory $memory 1 2)
  (memory $memory 1 2)
  ;; CHECK:      (data $data (i32.const -1) "\00")
  (data $data (i32.const -2) "\00\00\00")
)

(module
  ;; This segment will almost trap, but not.
  ;; CHECK:      (memory $memory 1 2)
  ;; TNH__:      (memory $memory 1 2)
  (memory $memory 1 2)
  (data $data (i32.const 65535) "\00")
)

(module
  ;; This one is slightly larger, and will trap. We can at least shorten the
  ;; segment to only contain one byte, at the highest address the segment would
  ;; write to.
  ;; CHECK:      (memory $memory 1 2)
  ;; TNH__:      (memory $memory 1 2)
  (memory $memory 1 2)
  ;; CHECK:      (data $data (i32.const 65536) "\00")
  (data $data (i32.const 65535) "\00\00")
)

(module
  ;; This one is slightly larger, but the offset is lower so it will not trap.
  ;; CHECK:      (memory $memory 1 2)
  ;; TNH__:      (memory $memory 1 2)
  (memory $memory 1 2)
  (data $data (i32.const 65534) "\00\00")
)

(module
  ;; This one's offset is just large enough to trap.
  ;; CHECK:      (memory $memory 1 2)
  ;; TNH__:      (memory $memory 1 2)
  (memory $memory 1 2)
  ;; CHECK:      (data $data (i32.const 65536) "\00")
  (data $data (i32.const 65536) "\00")
)

(module
  ;; This offset is unknown, so assume the worst.
  ;; TODO: We could remove it in TNH mode

  ;; CHECK:      (import "a" "b" (global $g i32))
  ;; TNH__:      (import "a" "b" (global $g i32))
  (import "a" "b" (global $g i32))
  ;; CHECK:      (memory $memory 1 2)
  ;; TNH__:      (memory $memory 1 2)
  (memory $memory 1 2)
  ;; CHECK:      (data $data (global.get $g) "\00")
  ;; TNH__:      (data $data (global.get $g) "\00")
  (data $data (global.get $g) "\00")
)

(module
  ;; Passive segments cannot trap during startup and are removable if they have
  ;; no uses, like here.
  ;; CHECK:      (memory $memory 1 2)
  ;; TNH__:      (memory $memory 1 2)
  (memory $memory 1 2)
  (data $data "\00\00\00")
)
