;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.
;; RUN: wasm-opt %s -all --dae -S -o - | filecheck %s
;; RUN: wasm-opt %s -all --dae --nominal -S -o - | filecheck %s --check-prefix NOMNL

(module
 ;; CHECK:      (type $return_{} (func (result (ref ${}))))
 ;; NOMNL:      (type $return_{} (func_subtype (result (ref ${})) func))
 (type $return_{} (func (result (ref ${}))))

 ;; CHECK:      (type ${i32} (struct (field i32)))

 ;; CHECK:      (type ${i32_f32} (struct (field i32) (field f32)))
 ;; NOMNL:      (type ${} (struct_subtype  data))

 ;; NOMNL:      (type ${i32} (struct_subtype (field i32) ${}))

 ;; NOMNL:      (type ${i32_f32} (struct_subtype (field i32) (field f32) ${i32}))
 (type ${i32_f32} (struct_subtype (field i32) (field f32) ${i32}))

 ;; CHECK:      (type ${i32_i64} (struct (field i32) (field i64)))
 ;; NOMNL:      (type ${i32_i64} (struct_subtype (field i32) (field i64) ${i32}))
 (type ${i32_i64} (struct_subtype (field i32) (field i64) ${i32}))

 (type ${i32} (struct_subtype (field i32) ${}))

 ;; CHECK:      (type ${} (struct ))
 (type ${} (struct))

 (table 1 1 funcref)

 ;; We cannot refine the return type if nothing is actually returned.
 ;; CHECK:      (func $refine-return-no-return (result anyref)
 ;; CHECK-NEXT:  (local $temp anyref)
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (call $refine-return-no-return)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $refine-return-no-return (type $none_=>_anyref) (result anyref)
 ;; NOMNL-NEXT:  (local $temp anyref)
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (call $refine-return-no-return)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (unreachable)
 ;; NOMNL-NEXT: )
 (func $refine-return-no-return (result anyref)
  ;; Call this function, so that we attempt to optimize it. Note that we do not
  ;; just drop the result, as that would cause the drop optimizations to kick
  ;; in.
  (local $temp anyref)
  (local.set $temp (call $refine-return-no-return))

  (unreachable)
 )

 ;; We cannot refine the return type if it is already the best it can be.
 ;; CHECK:      (func $refine-return-no-refining (result anyref)
 ;; CHECK-NEXT:  (local $temp anyref)
 ;; CHECK-NEXT:  (local $any anyref)
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (call $refine-return-no-refining)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.get $any)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $refine-return-no-refining (type $none_=>_anyref) (result anyref)
 ;; NOMNL-NEXT:  (local $temp anyref)
 ;; NOMNL-NEXT:  (local $any anyref)
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (call $refine-return-no-refining)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.get $any)
 ;; NOMNL-NEXT: )
 (func $refine-return-no-refining (result anyref)
  (local $temp anyref)
  (local $any anyref)

  (local.set $temp (call $refine-return-no-refining))

  (local.get $any)
 )

 ;; Refine the return type based on the value flowing out.
 ;; CHECK:      (func $refine-return-flow (result i31ref)
 ;; CHECK-NEXT:  (local $temp anyref)
 ;; CHECK-NEXT:  (local $i31 i31ref)
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (call $refine-return-flow)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.get $i31)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $refine-return-flow (type $none_=>_i31ref) (result i31ref)
 ;; NOMNL-NEXT:  (local $temp anyref)
 ;; NOMNL-NEXT:  (local $i31 i31ref)
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (call $refine-return-flow)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.get $i31)
 ;; NOMNL-NEXT: )
 (func $refine-return-flow (result anyref)
  (local $temp anyref)
  (local $i31 (ref null i31))

  (local.set $temp (call $refine-return-flow))

  (local.get $i31)
 )
 ;; CHECK:      (func $call-refine-return-flow (result i31ref)
 ;; CHECK-NEXT:  (local $temp anyref)
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (call $call-refine-return-flow)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if (result i31ref)
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (call $refine-return-flow)
 ;; CHECK-NEXT:   (call $refine-return-flow)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $call-refine-return-flow (type $none_=>_i31ref) (result i31ref)
 ;; NOMNL-NEXT:  (local $temp anyref)
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (call $call-refine-return-flow)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (if (result i31ref)
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:   (call $refine-return-flow)
 ;; NOMNL-NEXT:   (call $refine-return-flow)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $call-refine-return-flow (result anyref)
  (local $temp anyref)
  (local.set $temp (call $call-refine-return-flow))

  ;; After refining the return value of the above function, refinalize will
  ;; update types here, which will lead to updating the if, and then the entire
  ;; function's return value.
  (if (result anyref)
   (i32.const 1)
   (call $refine-return-flow)
   (call $refine-return-flow)
  )
 )

 ;; Refine the return type based on a return.
 ;; CHECK:      (func $refine-return-return (result i31ref)
 ;; CHECK-NEXT:  (local $temp anyref)
 ;; CHECK-NEXT:  (local $i31 i31ref)
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (call $refine-return-return)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $i31)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $refine-return-return (type $none_=>_i31ref) (result i31ref)
 ;; NOMNL-NEXT:  (local $temp anyref)
 ;; NOMNL-NEXT:  (local $i31 i31ref)
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (call $refine-return-return)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (return
 ;; NOMNL-NEXT:   (local.get $i31)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $refine-return-return (result anyref)
  (local $temp anyref)
  (local $i31 (ref null i31))

  (local.set $temp (call $refine-return-return))

  (return (local.get $i31))
 )

 ;; Refine the return type based on multiple values.
 ;; CHECK:      (func $refine-return-many (result i31ref)
 ;; CHECK-NEXT:  (local $temp anyref)
 ;; CHECK-NEXT:  (local $i31 i31ref)
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (call $refine-return-many)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (local.get $i31)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (local.get $i31)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.get $i31)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $refine-return-many (type $none_=>_i31ref) (result i31ref)
 ;; NOMNL-NEXT:  (local $temp anyref)
 ;; NOMNL-NEXT:  (local $i31 i31ref)
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (call $refine-return-many)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (local.get $i31)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (i32.const 2)
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (local.get $i31)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.get $i31)
 ;; NOMNL-NEXT: )
 (func $refine-return-many (result anyref)
  (local $temp anyref)
  (local $i31 (ref null i31))

  (local.set $temp (call $refine-return-many))

  (if
   (i32.const 1)
   (return (local.get $i31))
  )
  (if
   (i32.const 2)
   (return (local.get $i31))
  )
  (local.get $i31)
 )

 ;; CHECK:      (func $refine-return-many-lub (result eqref)
 ;; CHECK-NEXT:  (local $temp anyref)
 ;; CHECK-NEXT:  (local $i31 i31ref)
 ;; CHECK-NEXT:  (local $data dataref)
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (call $refine-return-many-lub)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (local.get $i31)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (local.get $data)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.get $i31)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $refine-return-many-lub (type $none_=>_eqref) (result eqref)
 ;; NOMNL-NEXT:  (local $temp anyref)
 ;; NOMNL-NEXT:  (local $i31 i31ref)
 ;; NOMNL-NEXT:  (local $data dataref)
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (call $refine-return-many-lub)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (local.get $i31)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (i32.const 2)
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (local.get $data)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.get $i31)
 ;; NOMNL-NEXT: )
 (func $refine-return-many-lub (result anyref)
  (local $temp anyref)
  (local $i31 (ref null i31))
  (local $data (ref null data))

  (local.set $temp (call $refine-return-many-lub))

  (if
   (i32.const 1)
   (return (local.get $i31))
  )
  (if
   (i32.const 2)
   ;; The refined return type has to be a supertype of data.
   (return (local.get $data))
  )
  (local.get $i31)
 )

 ;; CHECK:      (func $refine-return-many-lub-2 (result eqref)
 ;; CHECK-NEXT:  (local $temp anyref)
 ;; CHECK-NEXT:  (local $i31 i31ref)
 ;; CHECK-NEXT:  (local $data dataref)
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (call $refine-return-many-lub-2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (local.get $i31)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (local.get $i31)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.get $data)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $refine-return-many-lub-2 (type $none_=>_eqref) (result eqref)
 ;; NOMNL-NEXT:  (local $temp anyref)
 ;; NOMNL-NEXT:  (local $i31 i31ref)
 ;; NOMNL-NEXT:  (local $data dataref)
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (call $refine-return-many-lub-2)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (local.get $i31)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (i32.const 2)
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (local.get $i31)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.get $data)
 ;; NOMNL-NEXT: )
 (func $refine-return-many-lub-2 (result anyref)
  (local $temp anyref)
  (local $i31 (ref null i31))
  (local $data (ref null data))

  (local.set $temp (call $refine-return-many-lub-2))

  (if
   (i32.const 1)
   (return (local.get $i31))
  )
  (if
   (i32.const 2)
   (return (local.get $i31))
  )
  ;; The refined return type has to be a supertype of data.
  (local.get $data)
 )

 ;; We can refine the return types of tuples.
 ;; CHECK:      (func $refine-return-tuple (result i31ref i32)
 ;; CHECK-NEXT:  (local $temp anyref)
 ;; CHECK-NEXT:  (local $i31 i31ref)
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (tuple.extract 0
 ;; CHECK-NEXT:    (call $refine-return-tuple)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (tuple.make
 ;; CHECK-NEXT:   (local.get $i31)
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $refine-return-tuple (type $none_=>_i31ref_i32) (result i31ref i32)
 ;; NOMNL-NEXT:  (local $temp anyref)
 ;; NOMNL-NEXT:  (local $i31 i31ref)
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (tuple.extract 0
 ;; NOMNL-NEXT:    (call $refine-return-tuple)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (tuple.make
 ;; NOMNL-NEXT:   (local.get $i31)
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $refine-return-tuple (result anyref i32)
  (local $temp anyref)
  (local $i31 (ref null i31))

  (local.set $temp
   (tuple.extract 0
    (call $refine-return-tuple)
   )
  )

  (tuple.make
   (local.get $i31)
   (i32.const 1)
  )
 )

 ;; This function does a return call of the one after it. The one after it
 ;; returns a ref.func of this one. They both begin by returning a funcref;
 ;; after refining the return type of the second function, it will have a more
 ;; specific type (which is ok as subtyping is allowed with tail calls).
 ;; CHECK:      (func $do-return-call (result funcref)
 ;; CHECK-NEXT:  (return_call $return-ref-func)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $do-return-call (type $none_=>_funcref) (result funcref)
 ;; NOMNL-NEXT:  (return_call $return-ref-func)
 ;; NOMNL-NEXT: )
 (func $do-return-call (result funcref)
  (return_call $return-ref-func)
 )
 ;; CHECK:      (func $return-ref-func (result (ref $none_=>_funcref))
 ;; CHECK-NEXT:  (ref.func $do-return-call)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $return-ref-func (type $none_=>_ref|none_->_funcref|) (result (ref $none_=>_funcref))
 ;; NOMNL-NEXT:  (ref.func $do-return-call)
 ;; NOMNL-NEXT: )
 (func $return-ref-func (result funcref)
  (ref.func $do-return-call)
 )

 ;; Show that we can optimize the return type of a function that does a tail
 ;; call.
 ;; CHECK:      (func $tail-callee (result (ref ${}))
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-callee (type $return_{}) (result (ref ${}))
 ;; NOMNL-NEXT:  (unreachable)
 ;; NOMNL-NEXT: )
 (func $tail-callee (result (ref ${}))
  (unreachable)
 )
 ;; CHECK:      (func $tail-caller-yes (result (ref ${}))
 ;; CHECK-NEXT:  (return_call $tail-callee)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-caller-yes (type $return_{}) (result (ref ${}))
 ;; NOMNL-NEXT:  (return_call $tail-callee)
 ;; NOMNL-NEXT: )
 (func $tail-caller-yes (result anyref)
  ;; This function's return type can be refined because of this call, whose
  ;; target's return type is more specific than anyref.
  (return_call $tail-callee)
 )
 ;; CHECK:      (func $tail-caller-no (result anyref)
 ;; CHECK-NEXT:  (local $any anyref)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (local.get $any)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call $tail-callee)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-caller-no (type $none_=>_anyref) (result anyref)
 ;; NOMNL-NEXT:  (local $any anyref)
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (local.get $any)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (return_call $tail-callee)
 ;; NOMNL-NEXT: )
 (func $tail-caller-no (result anyref)
  (local $any anyref)

  ;; This function's return type cannot be refined because of another return
  ;; whose type prevents it.
  (if (i32.const 1)
   (return (local.get $any))
  )
  (return_call $tail-callee)
 )
 ;; CHECK:      (func $tail-call-caller
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $tail-caller-yes)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $tail-caller-no)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-call-caller (type $none_=>_none)
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $tail-caller-yes)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $tail-caller-no)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $tail-call-caller
  ;; Call the functions to cause optimization to happen.
  (drop
   (call $tail-caller-yes)
  )
  (drop
   (call $tail-caller-no)
  )
 )

 ;; As above, but with an indirect tail call.
 ;; CHECK:      (func $tail-callee-indirect (result (ref ${}))
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-callee-indirect (type $return_{}) (result (ref ${}))
 ;; NOMNL-NEXT:  (unreachable)
 ;; NOMNL-NEXT: )
 (func $tail-callee-indirect (result (ref ${}))
  (unreachable)
 )
 ;; CHECK:      (func $tail-caller-indirect-yes (result (ref ${}))
 ;; CHECK-NEXT:  (return_call_indirect $0 (type $return_{})
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-caller-indirect-yes (type $return_{}) (result (ref ${}))
 ;; NOMNL-NEXT:  (return_call_indirect $0 (type $return_{})
 ;; NOMNL-NEXT:   (i32.const 0)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $tail-caller-indirect-yes (result anyref)
  (return_call_indirect (type $return_{}) (i32.const 0))
 )
 ;; CHECK:      (func $tail-caller-indirect-no (result anyref)
 ;; CHECK-NEXT:  (local $any anyref)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (local.get $any)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $0 (type $return_{})
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-caller-indirect-no (type $none_=>_anyref) (result anyref)
 ;; NOMNL-NEXT:  (local $any anyref)
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (local.get $any)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (return_call_indirect $0 (type $return_{})
 ;; NOMNL-NEXT:   (i32.const 0)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $tail-caller-indirect-no (result anyref)
  (local $any anyref)

  (if (i32.const 1)
   (return (local.get $any))
  )
  (return_call_indirect (type $return_{}) (i32.const 0))
 )
 ;; CHECK:      (func $tail-call-caller-indirect
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $tail-caller-indirect-yes)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $tail-caller-indirect-no)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-call-caller-indirect (type $none_=>_none)
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $tail-caller-indirect-yes)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $tail-caller-indirect-no)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $tail-call-caller-indirect
  (drop
   (call $tail-caller-indirect-yes)
  )
  (drop
   (call $tail-caller-indirect-no)
  )
 )

 ;; As above, but with a tail call by function reference.
 ;; CHECK:      (func $tail-callee-call_ref (result (ref ${}))
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-callee-call_ref (type $return_{}) (result (ref ${}))
 ;; NOMNL-NEXT:  (unreachable)
 ;; NOMNL-NEXT: )
 (func $tail-callee-call_ref (result (ref ${}))
  (unreachable)
 )
 ;; CHECK:      (func $tail-caller-call_ref-yes (result (ref ${}))
 ;; CHECK-NEXT:  (local $return_{} (ref null $return_{}))
 ;; CHECK-NEXT:  (return_call_ref $return_{}
 ;; CHECK-NEXT:   (local.get $return_{})
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-caller-call_ref-yes (type $return_{}) (result (ref ${}))
 ;; NOMNL-NEXT:  (local $return_{} (ref null $return_{}))
 ;; NOMNL-NEXT:  (return_call_ref $return_{}
 ;; NOMNL-NEXT:   (local.get $return_{})
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $tail-caller-call_ref-yes (result anyref)
  (local $return_{} (ref null $return_{}))

  (return_call_ref $return_{} (local.get $return_{}))
 )
 ;; CHECK:      (func $tail-caller-call_ref-no (result anyref)
 ;; CHECK-NEXT:  (local $any anyref)
 ;; CHECK-NEXT:  (local $return_{} (ref null $return_{}))
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (local.get $any)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_ref $return_{}
 ;; CHECK-NEXT:   (local.get $return_{})
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-caller-call_ref-no (type $none_=>_anyref) (result anyref)
 ;; NOMNL-NEXT:  (local $any anyref)
 ;; NOMNL-NEXT:  (local $return_{} (ref null $return_{}))
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (local.get $any)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (return_call_ref $return_{}
 ;; NOMNL-NEXT:   (local.get $return_{})
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $tail-caller-call_ref-no (result anyref)
  (local $any anyref)
  (local $return_{} (ref null $return_{}))

  (if (i32.const 1)
   (return (local.get $any))
  )
  (return_call_ref $return_{} (local.get $return_{}))
 )
 ;; CHECK:      (func $tail-caller-call_ref-unreachable (result anyref)
 ;; CHECK-NEXT:  (block ;; (replaces something unreachable we can't emit)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-caller-call_ref-unreachable (type $none_=>_anyref) (result anyref)
 ;; NOMNL-NEXT:  (block ;; (replaces something unreachable we can't emit)
 ;; NOMNL-NEXT:   (drop
 ;; NOMNL-NEXT:    (unreachable)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (unreachable)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $tail-caller-call_ref-unreachable (result anyref)
  ;; An unreachable means there is no function signature to even look at. We
  ;; should not hit an assertion on such things.
  (return_call_ref $return_{} (unreachable))
 )
 ;; CHECK:      (func $tail-call-caller-call_ref
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $tail-caller-call_ref-yes)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $tail-caller-call_ref-no)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $tail-caller-call_ref-unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $tail-call-caller-call_ref (type $none_=>_none)
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $tail-caller-call_ref-yes)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $tail-caller-call_ref-no)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $tail-caller-call_ref-unreachable)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $tail-call-caller-call_ref
  (drop
   (call $tail-caller-call_ref-yes)
  )
  (drop
   (call $tail-caller-call_ref-no)
  )
  (drop
   (call $tail-caller-call_ref-unreachable)
  )
 )

 ;; CHECK:      (func $update-null (param $x i32) (param $y i32) (result (ref null ${i32}))
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (local.get $y)
 ;; CHECK-NEXT:    (return
 ;; CHECK-NEXT:     (struct.new_default ${i32_f32})
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (return
 ;; CHECK-NEXT:     (ref.null none)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (struct.new_default ${i32_i64})
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $update-null (type $i32_i32_=>_ref?|${i32}|) (param $x i32) (param $y i32) (result (ref null ${i32}))
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (local.get $x)
 ;; NOMNL-NEXT:   (if
 ;; NOMNL-NEXT:    (local.get $y)
 ;; NOMNL-NEXT:    (return
 ;; NOMNL-NEXT:     (struct.new_default ${i32_f32})
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:    (return
 ;; NOMNL-NEXT:     (ref.null none)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (return
 ;; NOMNL-NEXT:    (struct.new_default ${i32_i64})
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $update-null (param $x i32) (param $y i32) (result anyref)
  ;; Of the three returns here, the null can be updated, and the LUB is
  ;; determined by the other two, and is their shared parent ${}.
  (if
   (local.get $x)
   (if
    (local.get $y)
    (return (struct.new ${i32_f32}))
    (return (ref.null any))
   )
   (return (struct.new ${i32_i64}))
  )
 )

 ;; CHECK:      (func $call-update-null (result anyref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $update-null
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $update-null
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $call-update-null (type $none_=>_anyref) (result anyref)
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $update-null
 ;; NOMNL-NEXT:    (i32.const 0)
 ;; NOMNL-NEXT:    (i32.const 1)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $update-null
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:   (i32.const 0)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $call-update-null (result anyref)
  ;; Call $update-null so it gets optimized. (Call it with various values so
  ;; that other opts do not inline the constants.)
  (drop
   ($call $update-null
    (i32.const 0)
    (i32.const 1)
   )
  )
  ($call $update-null
   (i32.const 1)
   (i32.const 0)
  )
 )
)
