/*
 * BamFileReader.h
 *
 *  Created on: Dec 4, 2012
 *      Author: nek3d
 */

#ifndef BAMFILEREADER_H_
#define BAMFILEREADER_H_

using namespace std;

#include "FileReader.h"
#include "QuickString.h"
#include "api/BamReader.h"
#include "api/BamAux.h"

class BamFileReader : public FileReader {
public:
	BamFileReader();
	virtual ~BamFileReader();
	virtual bool open(); //open the file
	virtual bool isOpen() const;
	virtual void close();
	virtual bool eof() const {
		return _eof;
	}

	//setUseTags will tell the BamReader to give us all
	//the extra tag information in a BAM record. By default,
	//this is set to false, so not using them, which reduces
	//the run time of reading a BAM file by more than half.
	virtual void setUseTags(bool flag) { _useTags = flag; }
	void setBamReader(BamTools::BamReader *bamReader) { _bamReader = bamReader; }
	virtual bool readEntry();

	virtual bool hasHeader() const { return _bamReader->IsOpen(); } //any open Bam file automatically has a header
	virtual const QuickString &getHeader() const { return _bamHeader; }
	const BamTools::RefVector &getReferences() const { return _references; }

	const BamTools::BamAlignment &getAlignment() const { return _bamAlignment; }


	void getChrName(QuickString &) const;
	int getBamChrId() const;
	int getStartPos() const;
	int getEndPos() const;
	void getName(QuickString &) const;
	void getScore(QuickString &) const;
	char getStrand() const;
	virtual int getNumFields() const { return MINIMUM_PRINTABLE_BAM_FIELDS; }

protected:

	BamTools::BamReader *_bamReader;
	BamTools::BamAlignment _bamAlignment;
	bool _eof;
	QuickString _bamHeader;
	BamTools::RefVector _references;
	bool _useTags;

	static const int MINIMUM_PRINTABLE_BAM_FIELDS = 6;
	void extractNameFromCore();
};


#endif /* BAMFILEREADER_H_ */
