/*
** int.h
** 
** Made by (gregoire barbier)
** Login   <barbie_g@epita.fr>
** 
** Started on  Tue Sep 21 15:53:01 1999 gregoire barbier
// Last update Tue Sep 21 19:16:30 1999 gregoire barbier
*/

#ifndef   __INT_H__
#define   __INT_H__

#include <stdio.h>		// for `NULL' definition

class Int
{
protected:
  typedef union u_int
  {
    signed int		s;
    unsigned int	u;
    
    u_int(signed int i = 0) : s(i)
      {}
    u_int(unsigned int i) : u(i)
      {}
  } t_int;
  
  t_int	i;
  
public:
  Int(signed int s) : i(s)
    {}
  Int(unsigned int u) : i(u)
    {}
  Int(const char *txt);
  ~Int()
    {}
  
  // converters
  const char	*getChar();	// "'a'" ou "" si hors plage
  const char	*getBase(const char *radix = NULL, const char *prefix = "",
			 bool isSigned = false, const char sign = '-');

  // accessors
  operator signed int()
    { return i.s; }
  operator unsigned int()
    { return i.u; }
  
  // predefined radixes
  const char	*getBase2()	// "0b0001001"
    { return getBase("01", "0b"); }
  const char	*getBase8()	// "0124523"
    { return getBase("01234567", "0"); }
  const char	*getBase10()	// "3556"
    { return getBase(); }
  const char	*getBase16()	// "0x2a"
    { return getBase("0123456789abcdef", "0x"); }
  const char	*getSignedBase10() // "-432"
    { return getBase(NULL, "", true); }

  // internals
protected:
  void		parseRadix(const char *radix, const char *txt);
  const char	*recognizeRadix(const char *&txt);
};


#endif /* __INT_H__ */
