//
// int.cpp for  in 
// 
// Made by gregoire barbier
// Login   <gregoire barbier@epita.fr>
// 
// Started on  Tue Sep 21 15:53:21 1999 gregoire barbier
// Last update Wed Apr 19 11:57:30 2000 gregoire barbier
//

#include "int.h"
#include <string.h>

Int::Int(const char *txt)
{
  const char	*radix;
  
  radix = recognizeRadix(txt);
  parseRadix(radix, txt);
}

void Int::parseRadix(const char *radix, const char *txt)
{
  bool		sign = false;
  unsigned int	u = 0;
  int		radix_len;
  
  // input preprocessing
  radix_len = strlen(radix);
  
  // sign preprocessing
  if (strstr(txt, "-") == txt)
    {
      ++txt;
      sign = true;
    }
  
  // main loop
  while (*txt != 0)
    {
      char	*p;
      
      p = strchr(radix, *txt);
      if (p == NULL)
	break;
      u = u*radix_len + p-radix;
      ++txt;
    }
  
  // sign postprocessing
  if (sign)
    i.s = -u;
  else
    i.u = u;
}

const char *Int::recognizeRadix(const char *&txt)
{
  if (strstr(txt, "0x") == txt)
    {
      txt += 2;
      return "0123456789abcdef";
    }
  if (strstr(txt, "0b") == txt)
    {
      txt += 2;
      return "01";
    }
  if (strstr(txt, "0") == txt)
    {
      ++txt;
      return "01234567";
    }
  return "0123456789";
}

const char *Int::getChar()
{
  static	char buf[5];
  
  strcpy(buf, "' '");
  if (i.s >= -128 && i.s < 0)
    buf[1] = (char)((signed char)i.s);
  else if (i.s >= 32 && i.s <= 255)
    buf[1] = (char)((unsigned char)i.s);
  else if (i.s >= 0 && i.s < 32)
    {
      strcpy(buf, "^ ");
      buf[1] = i.s + '@';
    }
  else
    return "";
  return buf;
}

#define BUF_LEN		(65+PREFIX_MAX)
#define PREFIX_MAX	5
const char *Int::getBase(const char *radix /*= NULL*/,
			 const char *prefix /*= NULL*/,
			 bool isSigned /*= false*/,
			 const char sign /*= '-'*/)
{
  static char	buf[BUF_LEN];
  int		idx = BUF_LEN - 2;
  bool		negative = false;
  int		radix_len;
  unsigned int	u;
  int		l;
  
  // input preprocessing
  if (radix == NULL)
    radix = "0123456789";
  if (prefix == NULL || strlen(prefix) > PREFIX_MAX)
    prefix = "";
  radix_len = strlen(radix);
  
  // case 0
  if (i.u == 0)
    {
      buf[0] = radix[0];
      buf[1] = 0;
      return buf;
    }
  
  // sign preprocessing
  if (isSigned && i.s < 0)
    {
      u = -i.s;
      negative = true;
    }
  else
    u = i.u;
  
  // main loop
  for (; u != 0; u/=radix_len)
    buf[idx--] = radix[u%radix_len];
  
  // sign postprocessing
  if (negative)
    {
      buf[idx--] = sign;
    }
  
  // prefix postprocessing
  l = strlen(prefix);
  idx -= l;
  memcpy(buf+idx+1, prefix, l);
  
  // output
  buf[sizeof(buf)] = 0;
  return buf+idx+1;
}


