//
// bcv.cpp for  in 
// 
// Made by gregoire barbier
// Login   <gregoire barbier@epita.fr>
// 
// Started on  Tue Sep 21 15:53:09 1999 gregoire barbier
// Last update Wed Apr 19 12:12:17 2000 gregoire barbier
//

#include "int.h"
#include <stdio.h>
#include <string.h>

void	bcv(Int i)
{
  const char	*c = strdup(i.getChar());
  
  printf("%10s = %12s = %34s = %4s%s%s\n",
	 strdup(i.getBase16()),
	 strdup(i.getBase8()),
	 strdup(i.getBase2()),
	 strdup(i.getSignedBase10()),
	 *c?" <-> ":"",
	 c);
}

void	bcv(const char *txt)
{
  if (strchr("0123456789-", *txt) != NULL)
    bcv(Int(txt));
  else if (txt[0] == '^' && txt[1] != '\0')
    bcv(Int(txt[1]-'@'));
  else
    while(*txt)
      bcv(Int(*(txt++)));
}

void	help(const char *argv0)
{
  printf("-------------------------------------------------------------"
	 "-------------------\n"
	 "BaseConVerter by barbier@sycomore.fr aka gbarbier@iname.com\n"
	 "version " VERSION " built on " __DATE__ " " __TIME__ "\n"
	 "\n"
	 "syntax:\n"
	 "%s [arg1 [arg2 [arg3 [...]]]]\n"
	 "argi can be :\n"
	 "* 0b110011 : binary\n"
	 "* 0x2a     : hex\n"
	 "* -34      : signed decimal\n"
	 "* c        : char\n"
	 "* hello    : char string\n"
	 "* ^M       : control char (<32)\n"
	 "\n"
	 "Software is under GPL2, see www.gnu.org for info about General Public Licence.\n"
	 "-------------------------------------------------------------"
	 "-------------------\n",
	 argv0);
}

int	main(int argc, char **argv)
{
  if (argc == 1 || strcmp(argv[1], "--help") == 0)
    help(argv[0]);
  for (int i = 1; i < argc; ++i)
    bcv(argv[i]);
  return 0;
}






