/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.bridge;

import com.google.caliper.bridge.GcLogMessage;
import com.google.caliper.bridge.HotspotLogMessage;
import com.google.caliper.bridge.LogMessage;
import com.google.caliper.bridge.VmOptionLogMessage;
import com.google.caliper.util.Parser;
import com.google.caliper.util.ShortDuration;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;

final class LogMessageParser
implements Parser<LogMessage> {
    private static final Pattern GC_PATTERN = Pattern.compile(".*\\[(?:(Full) )?GC.*(\\d+\\.\\d+) secs\\]");
    private static final Pattern JIT_PATTERN = Pattern.compile(".*::.*( \\(((\\d+ bytes)|(static))\\))?");
    private static final Pattern VM_OPTION_PATTERN = Pattern.compile("\\s*(\\w+)\\s+(\\w+)\\s+:?=\\s+([^\\s]*)\\s+\\{([^}]*)\\}\\s*");

    @Inject
    LogMessageParser() {
    }

    public LogMessage parse(CharSequence text) {
        String string = text.toString();
        Matcher gcMatcher = GC_PATTERN.matcher(string);
        if (gcMatcher.matches()) {
            return new GcLogMessage("Full".equals(gcMatcher.group(1)) ? GcLogMessage.Type.FULL : GcLogMessage.Type.INCREMENTAL, ShortDuration.of((BigDecimal)BigDecimal.valueOf(Double.parseDouble(gcMatcher.group(2))), (TimeUnit)TimeUnit.SECONDS));
        }
        Matcher jitMatcher = JIT_PATTERN.matcher(string);
        if (jitMatcher.matches()) {
            return new HotspotLogMessage();
        }
        Matcher vmOptionMatcher = VM_OPTION_PATTERN.matcher(string);
        if (vmOptionMatcher.matches()) {
            return new VmOptionLogMessage(vmOptionMatcher.group(2), vmOptionMatcher.group(3));
        }
        return null;
    }
}

