/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.ArrayList;
import java.util.List;
import proguard.util.ConcatenatingStringFunction;
import proguard.util.ConstantStringFunction;
import proguard.util.MatchedStringFunction;
import proguard.util.MatchedStringMatcher;
import proguard.util.StringFunction;
import proguard.util.StringMatcher;
import proguard.util.VariableStringMatcher;

public class WildcardManager {
    private List<VariableStringMatcher> variableStringMatchers;

    public WildcardManager() {
        this(new ArrayList<VariableStringMatcher>());
    }

    public WildcardManager(WildcardManager wildcardManager) {
        this(new ArrayList<VariableStringMatcher>(wildcardManager.variableStringMatchers));
    }

    private WildcardManager(List<VariableStringMatcher> variableStringMatchers) {
        this.variableStringMatchers = variableStringMatchers;
    }

    public void reset() {
        this.variableStringMatchers.clear();
    }

    public VariableStringMatcher createVariableStringMatcher(char[] allowedCharacters, char[] disallowedCharacters, int minimumLength, int maximumLength, StringMatcher nextMatcher) {
        VariableStringMatcher variableStringMatcher = new VariableStringMatcher(allowedCharacters, disallowedCharacters, minimumLength, maximumLength, nextMatcher);
        this.rememberVariableStringMatcher(variableStringMatcher);
        return variableStringMatcher;
    }

    public void rememberVariableStringMatcher(VariableStringMatcher variableStringMatcher) {
        this.variableStringMatchers.add(variableStringMatcher);
    }

    public MatchedStringMatcher createMatchedStringMatcher(int index, StringMatcher nextMatcher) {
        return new MatchedStringMatcher(this.variableStringMatchers.get(index), nextMatcher);
    }

    public StringFunction createMatchedStringFunction(String expression) {
        StringFunction stringFunction = null;
        int prefixIndex = 0;
        for (int index = 0; index < expression.length(); ++index) {
            int wildCardIndex = this.wildCardIndex(expression, index);
            if (wildCardIndex < 0) continue;
            MatchedStringFunction matchedStringFunction = new MatchedStringFunction(this.variableStringMatchers.get(wildCardIndex));
            StringFunction additionalStringFunction = prefixIndex == index ? matchedStringFunction : new ConcatenatingStringFunction(new ConstantStringFunction(expression.substring(prefixIndex, index)), matchedStringFunction);
            stringFunction = stringFunction == null ? additionalStringFunction : new ConcatenatingStringFunction(stringFunction, additionalStringFunction);
            index = expression.indexOf(62, index + 1);
            prefixIndex = index + 1;
        }
        return stringFunction == null ? new ConstantStringFunction(expression) : (prefixIndex == expression.length() ? stringFunction : new ConcatenatingStringFunction(stringFunction, new ConstantStringFunction(expression.substring(prefixIndex))));
    }

    public int wildCardIndex(String regularExpression, int index) throws IllegalArgumentException {
        if (this.variableStringMatchers == null || regularExpression.charAt(index) != '<') {
            return -1;
        }
        int closingBracketIndex = regularExpression.indexOf(62, index);
        if (closingBracketIndex < 0) {
            throw new IllegalArgumentException("Missing closing angular bracket after opening bracket at index " + index + " in [" + regularExpression + "]");
        }
        String argumentBetweenBrackets = regularExpression.substring(index + 1, closingBracketIndex);
        try {
            int wildcardIndex = Integer.parseInt(argumentBetweenBrackets);
            if (wildcardIndex < 1 || wildcardIndex > this.variableStringMatchers.size()) {
                throw new IllegalArgumentException("Invalid reference to wildcard (" + wildcardIndex + ", must lie between 1 and " + this.variableStringMatchers.size() + " in [" + regularExpression + "])");
            }
            return wildcardIndex - 1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

