/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.evaluation.value.DetailedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedValueFactory;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;

public class DetailedArrayValueFactory
extends IdentifiedValueFactory {
    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
        return type == null ? TypedReferenceValueFactory.REFERENCE_VALUE_NULL : (arrayLength.isParticular() ? new DetailedArrayReferenceValue('[' + type, referencedClass, false, arrayLength, this, DetailedArrayValueFactory.generateReferenceId()) : new IdentifiedArrayReferenceValue('[' + type, referencedClass, false, arrayLength, this, DetailedArrayValueFactory.generateReferenceId()));
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength, Object elementValues) {
        if (type == null) {
            return TypedReferenceValueFactory.REFERENCE_VALUE_NULL;
        }
        if (!arrayLength.isParticular()) {
            return new IdentifiedArrayReferenceValue(type, referencedClass, false, arrayLength, this, DetailedArrayValueFactory.generateReferenceId());
        }
        if (!elementValues.getClass().isArray() || elementValues.getClass().getComponentType().isArray()) {
            throw new IllegalArgumentException("Only one-dimension array type is supported: " + elementValues.getClass());
        }
        DetailedArrayReferenceValue detailedArray = new DetailedArrayReferenceValue(type, referencedClass, false, arrayLength, this, DetailedArrayValueFactory.generateReferenceId());
        if (elementValues.getClass().isArray()) {
            switch (type.charAt(1)) {
                case 'Z': {
                    this.storeBooleanArray(detailedArray, (boolean[])elementValues);
                    break;
                }
                case 'B': {
                    this.storeByteArray(detailedArray, (byte[])elementValues);
                    break;
                }
                case 'C': {
                    this.storeCharArray(detailedArray, (char[])elementValues);
                    break;
                }
                case 'S': {
                    this.storeShortArray(detailedArray, (short[])elementValues);
                    break;
                }
                case 'I': {
                    this.storeIntArray(detailedArray, (int[])elementValues);
                    break;
                }
                case 'J': {
                    this.storeLongArray(detailedArray, (long[])elementValues);
                    break;
                }
                case 'F': {
                    this.storeFloatArray(detailedArray, (float[])elementValues);
                    break;
                }
                case 'D': {
                    this.storeDoubleArray(detailedArray, (double[])elementValues);
                    break;
                }
                default: {
                    this.storeObjectArray(detailedArray, (Object[])elementValues);
                }
            }
        }
        return detailedArray;
    }

    private void storeBooleanArray(DetailedArrayReferenceValue detailedArray, boolean[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i] ? 1 : 0));
        }
    }

    private void storeByteArray(DetailedArrayReferenceValue detailedArray, byte[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i]));
        }
    }

    private void storeCharArray(DetailedArrayReferenceValue detailedArray, char[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i]));
        }
    }

    private void storeShortArray(DetailedArrayReferenceValue detailedArray, short[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i]));
        }
    }

    private void storeIntArray(DetailedArrayReferenceValue detailedArray, int[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i]));
        }
    }

    private void storeLongArray(DetailedArrayReferenceValue detailedArray, long[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createLongValue(elementValues[i]));
        }
    }

    private void storeFloatArray(DetailedArrayReferenceValue detailedArray, float[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createFloatValue(elementValues[i]));
        }
    }

    private void storeDoubleArray(DetailedArrayReferenceValue detailedArray, double[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createDoubleValue(elementValues[i]));
        }
    }

    private void storeObjectArray(DetailedArrayReferenceValue detailedArray, Object[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createReferenceValue(detailedArray.referencedClass, elementValues[i]));
        }
    }
}

