/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.bridge.StartVmRequest;
import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.config.DeviceConfig;
import com.google.caliper.runner.config.InvalidConfigurationException;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.server.ServerSocketService;
import com.google.caliper.runner.target.Device;
import com.google.caliper.runner.target.DeviceException;
import com.google.caliper.runner.target.ProxyConnectionService;
import com.google.caliper.runner.target.Shell;
import com.google.caliper.runner.target.ShellException;
import com.google.caliper.runner.target.ShutdownHookRegistrar;
import com.google.caliper.runner.target.VirtualMachineException;
import com.google.caliper.runner.target.Vm;
import com.google.caliper.runner.target.VmProcess;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.Stdout;
import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
final class AdbDevice
extends Device {
    private static final int MIN_API_LEVEL = 21;
    private static final CharMatcher DIGITS = CharMatcher.inRange((char)'0', (char)'9');
    private static final Splitter CLASSPATH_SPLITTER = Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value());
    private static final String CALIPER_PACKAGE_NAME = "com.google.caliper";
    private final CaliperOptions caliperOptions;
    private final CaliperConfig caliperConfig;
    private final PrintWriter stdout;
    private Shell shell;
    private final String adb = "adb";
    private final ImmutableList<String> adbArgs;
    private final ServerSocketService server;
    private final ProxyConnectionService proxyConnection;
    private String remoteClasspath;
    private String remoteNativeLibraryDir;
    private int port;

    @Inject
    AdbDevice(DeviceConfig config, ShutdownHookRegistrar shutdownHookRegistrar, CaliperOptions caliperOptions, CaliperConfig caliperConfig, Shell shell, ServerSocketService server, ProxyConnectionService proxyConnection, @Stdout PrintWriter stdout) {
        super(config, shutdownHookRegistrar);
        this.caliperOptions = caliperOptions;
        this.caliperConfig = caliperConfig;
        this.shell = shell;
        this.server = server;
        this.proxyConnection = proxyConnection;
        this.stdout = stdout;
        this.adbArgs = caliperOptions.adbArgs();
    }

    private ImmutableList<String> adbCommand(String ... args) {
        return this.adbCommand(Arrays.asList(args));
    }

    private ImmutableList<String> adbCommand(Iterable<String> args) {
        return ImmutableList.builder().add((Object)"adb").addAll(this.adbArgs).addAll(args).build();
    }

    protected void startUp() throws Exception {
        this.shell.execute((List<String>)this.adbCommand("start-server")).orThrow();
        String selector = Strings.nullToEmpty((String)((String)this.config().options().get((Object)"selector")));
        ImmutableList<String> getSerialNumber = this.adbCommand(Iterables.concat((Iterable)Splitter.on((char)' ').omitEmptyStrings().split((CharSequence)selector), (Iterable)ImmutableList.of((Object)"get-serialno")));
        String deviceSerialNumber = this.shell.execute((List<String>)getSerialNumber).orThrow().stdout();
        this.selectDevice(deviceSerialNumber);
        this.install(this.getWorkerApk());
        this.port = this.server.getPort();
        this.setReversePortForwarding();
        int n = this.port;
        this.startActivity("com.google.caliper/.worker.CaliperProxyActivity", (Map<String, String>)ImmutableMap.of((Object)"com.google.caliper.runner_port", (Object)new StringBuilder(11).append(n).toString(), (Object)"com.google.caliper.proxy_id", (Object)this.proxyConnection.proxyId().toString()));
        try {
            this.proxyConnection.startAsync().awaitRunning(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new DeviceException("Timed out waiting for a connection from the Caliper proxy app on the device. It may have failed to start.", e);
        }
        this.remoteClasspath = this.proxyConnection.getRemoteClasspath();
        this.remoteNativeLibraryDir = this.proxyConnection.getRemoteNativeLibraryDir();
    }

    private void selectDevice(String serialNumber) {
        this.shell = this.shell.withEnv((Map<String, String>)ImmutableMap.of((Object)"ANDROID_SERIAL", (Object)serialNumber));
        int apiLevel = this.getApiLevel();
        this.checkDeviceApiLevel(apiLevel);
        String model = this.shell.execute((List<String>)this.adbCommand("shell", "getprop", "ro.product.model")).orThrow().stdout();
        this.stdout.printf("adb: using %s device %s at API level %s%n", model, serialNumber, apiLevel);
    }

    private int getApiLevel() {
        String out = this.shell.execute((List<String>)this.adbCommand("shell", "getprop", "ro.build.version.sdk")).orThrow().stdout();
        if (!DIGITS.matchesAllOf((CharSequence)out)) {
            String string = String.valueOf(out);
            throw new ShellException(string.length() != 0 ? "unexpected output from command 'adb shell getprop ro.build.version.sdk': ".concat(string) : new String("unexpected output from command 'adb shell getprop ro.build.version.sdk': "));
        }
        return Integer.parseInt(out);
    }

    private void checkDeviceApiLevel(int apiLevel) {
        if (apiLevel < 21) {
            throw new InvalidConfigurationException(String.format("device API level %s is not supported; Caliper only supports API level %s+", apiLevel, 21));
        }
    }

    private void setReversePortForwarding() {
        int n = this.port;
        String tcpPort = new StringBuilder(15).append("tcp:").append(n).toString();
        this.shell.execute((List<String>)this.adbCommand("reverse", tcpPort, tcpPort)).orThrow();
    }

    private void removeReversePortForwarding() {
        int n = this.port;
        String tcpPort = new StringBuilder(15).append("tcp:").append(n).toString();
        this.shell.execute((List<String>)this.adbCommand("reverse", "--remove", tcpPort)).orThrow();
    }

    private void install(File apk) {
        String string = String.valueOf(apk);
        this.stdout.println(new StringBuilder(16 + String.valueOf(string).length()).append("adb: installing ").append(string).toString());
        this.shell.execute((List<String>)this.adbCommand("install", "-r", apk.getAbsolutePath())).orThrow();
    }

    private void uninstall(String packageName) {
        String string = String.valueOf(packageName);
        this.stdout.println(string.length() != 0 ? "adb: uninstalling package ".concat(string) : new String("adb: uninstalling package "));
        this.shell.execute((List<String>)this.adbCommand("uninstall", packageName));
    }

    private void startActivity(String intent, Map<String, String> extras) {
        this.stdout.println("adb: starting proxy activity");
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)"shell").add((Object[])new String[]{"am", "start"}).add((Object[])new String[]{"-n", intent}).add((Object[])new String[]{"-a", "android.intent.action.MAIN"}).add((Object[])new String[]{"-c", "android.intent.category.LAUNCHER"});
        for (Map.Entry<String, String> entry : extras.entrySet()) {
            builder.add((Object[])new String[]{"-e", entry.getKey(), entry.getValue()});
        }
        this.shell.execute((List<String>)this.adbCommand((Iterable<String>)builder.build())).orThrow("failed to start activity");
    }

    private File getWorkerApk() {
        Optional<String> optionalClasspath = this.caliperOptions.workerClasspath(VmType.ANDROID.toString());
        if (!optionalClasspath.isPresent()) {
            throw new InvalidCommandException("No worker classpath for VM type %s provided", new Object[]{VmType.ANDROID});
        }
        List classpath = CLASSPATH_SPLITTER.splitToList((CharSequence)optionalClasspath.get());
        if (classpath.size() != 1 || !((String)classpath.get(0)).endsWith(".apk")) {
            throw new InvalidCommandException("Android worker classpath must consist of a single file with extension .apk", new Object[0]);
        }
        File apk = new File((String)classpath.get(0));
        if (!apk.isFile()) {
            String string = String.valueOf(apk);
            throw new InvalidCommandException(new StringBuilder(60 + String.valueOf(string).length()).append("Android worker apk '").append(string).append("' does not exist or isn't a regular file").toString(), new Object[0]);
        }
        return apk;
    }

    protected void shutDown() throws Exception {
        try {
            this.proxyConnection.stopAsync().awaitTerminated();
        }
        finally {
            try {
                this.uninstall(CALIPER_PACKAGE_NAME);
            }
            finally {
                this.removeReversePortForwarding();
            }
        }
    }

    @Override
    public String vmExecutablePath(Vm vm) {
        String executable;
        Preconditions.checkState((boolean)this.isRunning(), (Object)"AdbDevice service must be running to get VM executable path");
        String string = String.valueOf(vm.executable());
        String string2 = executable = string.length() != 0 ? "/system/bin/".concat(string) : new String("/system/bin/");
        if (!this.fileExists(executable)) {
            String string3 = String.valueOf((Object)this);
            throw new VirtualMachineException(new StringBuilder(39 + String.valueOf(executable).length() + String.valueOf(string3).length()).append("VM executable ").append(executable).append(" doesn't exist on device ").append(string3).toString());
        }
        return executable;
    }

    @Override
    public String workerClasspath(VmType type) {
        Preconditions.checkArgument((boolean)type.equals((Object)VmType.ANDROID), (String)"type must be ANDROID, not %s", (Object)((Object)type));
        Preconditions.checkState((boolean)this.isRunning(), (Object)"AdbDevice service must be running to get worker classpath");
        return this.remoteClasspath;
    }

    @Override
    public Optional<String> workerNativeLibraryDir(VmType type) {
        Preconditions.checkArgument((boolean)type.equals((Object)VmType.ANDROID), (String)"type must be ANDROID, not %s", (Object)((Object)type));
        Preconditions.checkState((boolean)this.isRunning(), (Object)"AdbDevice service must be running to get worker nativeLibraryDir");
        return Optional.of((Object)this.remoteNativeLibraryDir);
    }

    @Override
    public VmType defaultVmType() {
        return VmType.ANDROID;
    }

    @Override
    public VmConfig defaultVmConfig() {
        return this.caliperConfig.getVmConfig("app_process");
    }

    @Override
    protected VmProcess doStartVm(VmProcess.Spec spec, VmProcess.Logger logger) throws Exception {
        StartVmRequest request = StartVmRequest.create((UUID)spec.id(), AdbDevice.createCommand(spec));
        return this.proxyConnection.startVm(request);
    }

    private boolean fileExists(String path) {
        Shell.Result result = this.shell.execute((List<String>)this.adbCommand("shell", "[", "-f", path, "]"));
        if (!result.isSuccessful() && !result.stderr().isEmpty()) {
            result.orThrow();
            throw new AssertionError();
        }
        return result.isSuccessful();
    }

    private static ImmutableList<String> createCommand(VmProcess.Spec spec) {
        return new ImmutableList.Builder().add((Object)spec.target().vmExecutablePath()).addAll(spec.vmOptions()).add((Object)spec.mainClass()).addAll(spec.mainArgs()).build();
    }
}

