/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class InnerClassesAccessFixer
extends SimplifiedVisitor
implements InnerClassesInfoVisitor,
ConstantVisitor,
ClassVisitor {
    private int innerClassAccessFlags;

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        this.innerClassAccessFlags = innerClassesInfo.u2innerClassAccessFlags;
        innerClassesInfo.innerClassConstantAccept(clazz, this);
        innerClassesInfo.u2innerClassAccessFlags = this.innerClassAccessFlags;
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.innerClassAccessFlags = AccessUtil.replaceAccessFlags(this.innerClassAccessFlags, programClass.u2accessFlags);
    }
}

