/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ErrorProneSignatureGenerator;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Name;

public final class Signatures {
    private static final Type.Visitor<String, Void> PRETTY_TYPE_VISITOR = new Types.DefaultTypeVisitor<String, Void>(){

        @Override
        public String visitWildcardType(Type.WildcardType t, Void unused) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)t.kind);
            if (t.kind != BoundKind.UNBOUND) {
                sb.append(t.type.accept(this, null));
            }
            return sb.toString();
        }

        @Override
        public String visitClassType(Type.ClassType t, Void s) {
            StringBuilder sb = new StringBuilder();
            sb.append(t.tsym.getSimpleName());
            if (((List)t.getTypeArguments()).nonEmpty()) {
                sb.append('<');
                sb.append(t.getTypeArguments().stream().map(a -> a.accept(this, null)).collect(Collectors.joining(", ")));
                sb.append(">");
            }
            return sb.toString();
        }

        @Override
        public String visitCapturedType(Type.CapturedType t, Void s) {
            return t.wildcard.accept(this, null);
        }

        @Override
        public String visitArrayType(Type.ArrayType t, Void unused) {
            return t.elemtype.accept(this, null) + "[]";
        }

        @Override
        public String visitType(Type t, Void s) {
            return t.toString();
        }
    };

    public static String classDescriptor(Type type, VisitorState state) {
        Types types = state.getTypes();
        ErrorProneSignatureGenerator sig = new ErrorProneSignatureGenerator(types, state.getNames());
        sig.assembleClassSig(types.erasure(type));
        return sig.toString();
    }

    public static String descriptor(Type type, VisitorState state) {
        Types types = state.getTypes();
        ErrorProneSignatureGenerator sig = new ErrorProneSignatureGenerator(types, state.getNames());
        sig.assembleSig(types.erasure(type));
        return sig.toString();
    }

    public static String prettyMethodSignature(Symbol.ClassSymbol origin, Symbol.MethodSymbol m) {
        StringBuilder sb = new StringBuilder();
        if (m.isConstructor()) {
            Name name = m.owner.enclClass().getSimpleName();
            if (name.isEmpty()) {
                name = m.owner.enclClass().getSuperclass().asElement().getSimpleName();
            }
            sb.append(name);
        } else {
            if (!m.owner.equals(origin)) {
                sb.append(m.owner.getSimpleName()).append('.');
            }
            sb.append(m.getSimpleName());
        }
        sb.append(m.getParameters().stream().map(v -> v.type.accept(PRETTY_TYPE_VISITOR, null)).collect(Collectors.joining(", ", "(", ")")));
        return sb.toString();
    }

    public static String prettyType(Type type) {
        return type.accept(PRETTY_TYPE_VISITOR, null);
    }

    private Signatures() {
    }
}

